/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.liquid_blaze_burner;

import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlock;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.recipe.FluidRecipeWrapper;
import com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipe;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTransferable;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_746;

public class LiquidBlazeBurnerTileEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IObserveTileEntity,
FluidTransferable {
    public static final int MAX_HEAT_CAPACITY = 10000;
    protected FuelType activeFuel;
    protected int remainingBurnTime = 0;
    protected LerpedFloat headAnimation;
    protected LerpedFloat headAngle;
    protected boolean isCreative = false;
    protected boolean goggles = false;
    protected boolean hat;
    protected FluidTank tankInventory;
    private Optional<LiquidBurningRecipe> recipeCache = Optional.empty();
    private class_3611 lastFluid = null;
    private int updateTimeout = 10;
    private boolean changed = true;
    public boolean first = true;

    public LiquidBlazeBurnerTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.activeFuel = FuelType.NONE;
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((class_2350)state.method_28500((class_2769)LiquidBlazeBurnerBlock.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f));
        this.tankInventory = this.createInventory();
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(4000L, this::onFluidStackChanged);
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.method_11002()) {
            return;
        }
        this.update(newFluidStack);
    }

    private void update(FluidStack stack) {
        if (this.field_11863.method_8608()) {
            return;
        }
        if (stack.getFluid() != this.lastFluid) {
            this.recipeCache = this.find(stack, this.field_11863);
        }
        this.lastFluid = stack.getFluid();
        this.changed = true;
    }

    public Optional<LiquidBurningRecipe> find(FluidStack stack, class_1937 world) {
        if (stack == null) {
            return Optional.empty();
        }
        if (world == null) {
            return Optional.empty();
        }
        if (LiquidBurningRecipe.TYPE == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(LiquidBurningRecipe.TYPE, (class_1263)new FluidRecipeWrapper(stack), world);
    }

    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 side) {
        return this.tankInventory;
    }

    public void burningTick() {
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.first) {
            this.update(this.tankInventory.getFluid());
        }
        this.first = false;
        if (this.remainingBurnTime < 1 && this.recipeCache.isEmpty()) {
            return;
        }
        if (this.tankInventory.getFluidAmount() < 100L) {
            return;
        }
        if (this.remainingBurnTime > 10000) {
            return;
        }
        try {
            this.remainingBurnTime += this.recipeCache.get().getBurnTime() / 10;
            this.activeFuel = this.recipeCache.get().isSuperheated() ? FuelType.SPECIAL : FuelType.NORMAL;
        }
        catch (Exception e) {
            return;
        }
        TransferUtil.extractAnyFluid((Storage)this.tankInventory, (long)8100L);
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14991, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 1.15f - this.field_11863.field_9229.nextFloat() * 0.25f);
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
        }
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            }
            return;
        }
        this.burningTick();
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    @Environment(value=EnvType.CLIENT)
    private void tickAnimation() {
        boolean active;
        boolean bl = active = this.getHeatLevelFromBlock().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.isValidBlockAbove();
        if (!active) {
            float target = 0.0f;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && !player.method_5767()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.method_23317();
                    z = player.method_23321();
                }
                double dx = x - ((double)this.method_11016().method_10263() + 0.5);
                double dz = z - ((double)this.method_11016().method_10260() + 0.5);
                target = AngleHelper.deg((double)(-class_3532.method_15349((double)dz, (double)dx))) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
            this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
            this.headAngle.tickChaser();
        } else {
            this.headAngle.chase((double)((AngleHelper.horizontalAngle((class_2350)this.method_11010().method_28500((class_2769)LiquidBlazeBurnerBlock.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f), 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public void write(class_2487 compound, boolean clientPacket) {
        if (!this.isCreative) {
            compound.method_10569("fuelLevel", this.activeFuel.ordinal());
            compound.method_10569("burnTimeRemaining", this.remainingBurnTime);
        } else {
            compound.method_10556("isCreative", true);
        }
        if (this.goggles) {
            compound.method_10556("Goggles", true);
        }
        if (this.hat) {
            compound.method_10556("TrainHat", true);
        }
        compound.method_10566("TankContent", (class_2520)this.tankInventory.writeToNBT(new class_2487()));
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.activeFuel = FuelType.values()[compound.method_10550("fuelLevel")];
        this.remainingBurnTime = compound.method_10550("burnTimeRemaining");
        this.isCreative = compound.method_10577("isCreative");
        this.goggles = compound.method_10545("Goggles");
        this.hat = compound.method_10545("TrainHat");
        this.tankInventory.readFromNBT(compound.method_10562("TankContent"));
        super.read(compound, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf((class_2680)this.method_11010());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevelFromFuelType(this.activeFuel));
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(LiquidBlazeBurnerBlock.HEAT_LEVEL, (Comparable)heat));
        this.notifyUpdate();
    }

    private boolean tryUpdateLiquid(class_1799 itemStack, class_1657 player, class_1268 hand) {
        Storage handler = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
        if (handler == null) {
            return false;
        }
        FluidStack stack = TransferUtil.firstOrEmpty((Storage)handler);
        if (stack.isEmpty()) {
            return false;
        }
        Optional<LiquidBurningRecipe> recipe = this.find(stack, this.field_11863);
        if (!recipe.isPresent()) {
            return false;
        }
        Storage<FluidVariant> tehandler = this.getFluidStorage(null);
        if (tehandler == null) {
            return false;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            StorageView view;
            Iterator iterator = tehandler.iterable((TransactionContext)t).iterator();
            if (iterator.hasNext() && (view = (StorageView)iterator.next()).getCapacity() - view.getAmount() < 81000L) {
                boolean bl = false;
                return bl;
            }
            tehandler.insert((Object)stack.getType(), 81000L, (TransactionContext)t);
            t.commit();
        }
        this.field_11863.method_8396(null, this.method_11016(), class_3417.field_14834, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 0.75f - this.field_11863.field_9229.nextFloat() * 0.25f);
        return true;
    }

    protected boolean tryUpdateFuel(class_1799 itemStack, class_1657 player, class_1268 hand, boolean forceOverflow, boolean simulate) {
        int newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        if (this.tryUpdateLiquid(itemStack, player, hand)) {
            return true;
        }
        if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_SPECIAL.matches(itemStack)) {
            newBurnTime = 1000;
            newFuel = FuelType.SPECIAL;
        } else {
            Integer burn = (Integer)FuelRegistry.INSTANCE.get((class_1935)itemStack.method_7909());
            int n = newBurnTime = burn != null ? burn : 0;
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            } else if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.matches(itemStack)) {
                newBurnTime = 1600;
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (this.activeFuel == FuelType.SPECIAL && this.remainingBurnTime > 20) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime + newBurnTime > 10000 && !forceOverflow) {
                return false;
            }
            newBurnTime = class_3532.method_15340((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)10000);
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        if (this.field_11863.field_9236) {
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
            return true;
        }
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14991, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 1.15f - this.field_11863.field_9229.nextFloat() * 0.25f);
        }
        return true;
    }

    protected void applyCreativeFuel() {
        this.activeFuel = FuelType.NONE;
        this.remainingBurnTime = 0;
        this.isCreative = true;
        BlazeBurnerBlock.HeatLevel next = this.getHeatLevelFromBlock().nextActiveLevel();
        if (this.field_11863.field_9236) {
            this.spawnParticleBurst(next.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING));
            return;
        }
        this.playSound();
        if (next == BlazeBurnerBlock.HeatLevel.FADING) {
            next = next.nextActiveLevel();
        }
        this.setBlockHeat(next);
    }

    public boolean isCreativeFuel(class_1799 stack) {
        return AllItems.CREATIVE_BLAZE_CAKE.isIn(stack);
    }

    public boolean isValidBlockAbove() {
        class_2680 blockState = this.field_11863.method_8320(this.field_11867.method_10084());
        return AllBlocks.BASIN.has(blockState) || blockState.method_26204() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14970, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 0.75f - this.field_11863.field_9229.nextFloat() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevelFromFuelType(FuelType fuel) {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel) {
            case SPECIAL: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case NORMAL: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.field_11863 == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        Random r = this.field_11863.method_8409();
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_243 v = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (Random)r, (float)0.125f).method_18805(1.0, 0.0, 1.0));
        if (r.nextInt(3) == 0) {
            this.field_11863.method_8406((class_2394)class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0.0, 0.0, 0.0);
        }
        if (r.nextInt(2) != 0) {
            return;
        }
        boolean empty = this.field_11863.method_8320(this.field_11867.method_10084()).method_26220((class_1922)this.field_11863, this.field_11867.method_10084()).method_1110();
        double yMotion = empty ? 0.0625 : r.nextDouble() * (double)0.0125f;
        class_243 v2 = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (Random)r, (float)0.5f).method_18805(1.0, 0.25, 1.0).method_1029().method_1021((empty ? 0.25 : 0.5) + r.nextDouble() * 0.125)).method_1031(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_22246, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_11240, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        Random r = this.field_11863.field_9229;
        for (int i = 0; i < 20; ++i) {
            class_243 offset = VecHelper.offsetRandomly((class_243)class_243.field_1353, (Random)r, (float)0.5f).method_18805(1.0, 0.25, 1.0).method_1029();
            class_243 v = c.method_1019(offset.method_1021(0.5 + r.nextDouble() * 0.125)).method_1031(0.0, 0.125, 0.0);
            class_243 m = offset.method_1021(0.03125);
            this.field_11863.method_8406((class_2394)(soulFlame ? class_2398.field_22246 : class_2398.field_11240), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.field_11867, 0);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidStorage(null));
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        this.notifyUpdate();
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

