/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.ConnectorBlock;
import com.mrh0.createaddition.blocks.connector.ConnectorMode;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class ConnectorTileEntity
extends BaseElectricTileEntity
implements IWireNode,
IObserveTileEntity,
IHaveGoggleInformation,
IDebugDrawer {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes = new LocalNode[this.getNodeCount()];
    private final IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    private EnergyNetwork network;
    private long demand = 0L;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    public static class_243 OFFSET_DOWN = new class_243(0.0, -0.1875, 0.0);
    public static class_243 OFFSET_UP = new class_243(0.0, 0.1875, 0.0);
    public static class_243 OFFSET_NORTH = new class_243(0.0, 0.0, -0.1875);
    public static class_243 OFFSET_WEST = new class_243(-0.1875, 0.0, 0.0);
    public static class_243 OFFSET_SOUTH = new class_243(0.0, 0.0, 0.1875);
    public static class_243 OFFSET_EAST = new class_243(0.1875, 0.0, 0.0);
    public static final int NODE_COUNT = 4;

    public ConnectorTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state, (Long)Config.CONNECTOR_CAPACITY.get(), (Long)Config.CONNECTOR_MAX_INPUT.get(), (Long)Config.CONNECTOR_MAX_OUTPUT.get());
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.field_11863);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public void setNode(int index, int other, class_2338 pos, WireType type) {
        this.localNodes[index] = new LocalNode((class_2586)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.nodeCache[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.network != null) {
            this.network.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public int getNodeCount() {
        return 4;
    }

    @Override
    public class_243 getNodeOffset(int node) {
        return switch ((class_2350)this.method_11010().method_11654((class_2769)ConnectorBlock.FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> OFFSET_DOWN;
            case class_2350.field_11036 -> OFFSET_UP;
            case class_2350.field_11043 -> OFFSET_NORTH;
            case class_2350.field_11039 -> OFFSET_WEST;
            case class_2350.field_11035 -> OFFSET_SOUTH;
            case class_2350.field_11034 -> OFFSET_EAST;
        };
    }

    @Override
    public class_2338 getPos() {
        return this.method_11016();
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        this.network = network;
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.network;
    }

    @Override
    public boolean isEnergyInput(class_2350 side) {
        return this.method_11010().method_11654((class_2769)ConnectorBlock.FACING) == side;
    }

    @Override
    public boolean isEnergyOutput(class_2350 side) {
        return this.method_11010().method_11654((class_2769)ConnectorBlock.FACING) == side;
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && nbt.method_10545("node0")) {
            this.convertOldNbt(nbt);
            this.method_5431();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        class_2499 nodes = nbt.method_10554("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((class_2586)this, (class_2487)tag);
        });
        if (nbt.method_10545("contraption") && !clientPacket) {
            this.wasContraption = nbt.method_10577("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.method_11010().method_11654(NodeRotation.ROTATION));
            if (rotation != NodeRotation.NONE) {
                this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        class_2499 nodes = new class_2499();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            class_2487 tag = new class_2487();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.method_10566("nodes", (class_2520)nodes);
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.network != null) {
                this.network.invalidate();
            }
        }
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            if (this.wasContraption && !this.field_11863.method_8608()) {
                this.wasContraption = false;
                this.validateNodes();
            }
        }
        if (!this.wireCache.isEmpty() && !this.method_11015()) {
            this.handleWireCache(this.field_11863, this.wireCache);
        }
        if (this.getMode() == ConnectorMode.None) {
            return;
        }
        super.tick();
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            return;
        }
        if (this.awakeNetwork(this.field_11863)) {
            this.notifyUpdate();
        }
        this.networkTick(this.network);
    }

    private void networkTick(EnergyNetwork network) {
        ConnectorMode mode = this.getMode();
        if (this.field_11863.method_8608()) {
            return;
        }
        class_2350 d = (class_2350)this.method_11010().method_11654((class_2769)ConnectorBlock.FACING);
        EnergyStorage ies = this.getCachedEnergy(d);
        if (ies == null) {
            return;
        }
        if (mode == ConnectorMode.Push || mode == ConnectorMode.Passive) {
            long pull = network.pull(this.demand);
            try (Transaction t = TransferUtil.getTransaction();){
                ies.insert(pull, (TransactionContext)t);
                t.commit();
            }
            t = TransferUtil.getTransaction();
            try {
                long testInsert = ies.insert(this.MAX_OUT, (TransactionContext)t);
                this.demand = network.demand(testInsert);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        if (mode == ConnectorMode.Pull) {
            try (Transaction t = TransferUtil.getTransaction();){
                long extracted = ies.extract(this.localEnergy.getSpace(), (TransactionContext)t);
                this.localEnergy.internalProduceEnergy(extracted);
                t.commit();
            }
        }
        if (mode == ConnectorMode.Pull || mode == ConnectorMode.Passive) {
            long testExtract = this.localEnergy.simulateExtract(Long.MAX_VALUE);
            long push = network.push(testExtract);
            this.localEnergy.internalConsumeEnergy(push);
        }
    }

    public void remove() {
        if (this.field_11863.method_8608()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public ConnectorMode getMode() {
        return (ConnectorMode)((Object)this.method_11010().method_11654(ConnectorBlock.MODE));
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.field_11867, this.getNetwork(0).getPulled(), this.getNetwork(0).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.field_11867, 0);
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.connector.info").method_27692(class_124.field_1068)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.mode").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2585(" ")).method_10852((class_2561)((ConnectorMode)((Object)this.method_11010().method_11654(ConnectorBlock.MODE))).getTooltip().method_27692(class_124.field_1075)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.usage").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_27693(" ").method_27693(Util.format(EnergyNetworkPacket.clientBuff)).method_27693("fe/t").method_27692(class_124.field_1075));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    @Override
    public boolean ignoreCapSide() {
        return ((ConnectorMode)((Object)this.method_11010().method_11654(ConnectorBlock.MODE))).isActive();
    }

    @Override
    public void drawDebug() {
        if (this.field_11863 == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            class_2338 pos = localNode.getPos();
            class_2680 state = this.field_11863.method_8320(pos);
            class_265 shape = state.method_26222((class_1922)this.field_11863, pos);
            int color = i == 0 ? 0xFF0000 : (i == 1 ? 65280 : (i == 2 ? 255 : 0xFFFFFF));
            if (!(this.field_11863.method_8321(pos) instanceof IWireNode)) {
                shape = class_259.method_1077();
                color = 0xFF00FF;
            }
            CreateClient.OUTLINER.chaseAABB((Object)("ca_nodes_" + i), shape.method_1107().method_996(pos)).lineWidth(0.0625f).colored(color);
        }
        class_2338 pos = this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)ConnectorBlock.FACING));
        EnergyStorage cap = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, pos, (Object)((class_2350)this.method_11010().method_11654((class_2769)ConnectorBlock.FACING)).method_10153());
        if (cap == null) {
            return;
        }
        class_265 shape = this.field_11863.method_8320(pos).method_26222((class_1922)this.field_11863, pos);
        CreateClient.OUTLINER.chaseAABB((Object)"ca_output", shape.method_1107().method_996(pos)).lineWidth(0.0625f).colored(0x5B5BFF);
    }
}

