/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.accumulator;

import com.mrh0.createaddition.blocks.accumulator.AccumulatorBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class AccumulatorTileEntity
extends BaseElectricTileEntity
implements IWireNode,
IHaveGoggleInformation,
IComparatorOverride,
IObserveTileEntity {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes;
    private final IWireNode[] nodeCache;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    public static class_243 OFFSET_NORTH = new class_243(0.0, 0.5625, -0.3125);
    public static class_243 OFFSET_WEST = new class_243(-0.3125, 0.5625, 0.0);
    public static class_243 OFFSET_SOUTH = new class_243(0.0, 0.5625, 0.3125);
    public static class_243 OFFSET_EAST = new class_243(0.3125, 0.5625, 0.0);
    public static final int NODE_COUNT = 8;
    private int lastComparator = 0;
    private boolean firstTickState = true;
    private long demandOut = 0L;
    private long demandIn = 0L;
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;

    public AccumulatorTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state, (Long)Config.ACCUMULATOR_CAPACITY.get(), (Long)Config.ACCUMULATOR_MAX_INPUT.get(), (Long)Config.ACCUMULATOR_MAX_OUTPUT.get());
        this.setLazyTickRate(20);
        this.localNodes = new LocalNode[this.getNodeCount()];
        this.nodeCache = new IWireNode[this.getNodeCount()];
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.field_11863);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public class_243 getNodeOffset(int node) {
        if (node > 3) {
            switch ((class_2350)this.method_11010().method_11654((class_2769)AccumulatorBlock.FACING)) {
                case field_11043: {
                    return OFFSET_NORTH;
                }
                case field_11039: {
                    return OFFSET_WEST;
                }
                case field_11035: {
                    return OFFSET_SOUTH;
                }
                case field_11034: {
                    return OFFSET_EAST;
                }
            }
        } else {
            switch ((class_2350)this.method_11010().method_11654((class_2769)AccumulatorBlock.FACING)) {
                case field_11043: {
                    return OFFSET_SOUTH;
                }
                case field_11039: {
                    return OFFSET_EAST;
                }
                case field_11035: {
                    return OFFSET_NORTH;
                }
                case field_11034: {
                    return OFFSET_WEST;
                }
            }
        }
        return OFFSET_NORTH;
    }

    @Override
    public boolean isEnergyInput(class_2350 side) {
        return side != class_2350.field_11036;
    }

    @Override
    public boolean isEnergyOutput(class_2350 side) {
        return false;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public int getAvailableNode(class_243 pos) {
        assert (this.field_11863 != null);
        class_2350 dir = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AccumulatorBlock.FACING);
        boolean upper = true;
        pos = pos.method_1023((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        switch (dir) {
            case field_11043: {
                upper = pos.method_10215() < 0.5;
                break;
            }
            case field_11039: {
                upper = pos.method_10216() < 0.5;
                break;
            }
            case field_11035: {
                upper = pos.method_10215() > 0.5;
                break;
            }
            case field_11034: {
                upper = pos.method_10216() > 0.5;
                break;
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setNode(int index, int other, class_2338 pos, WireType type) {
        this.localNodes[index] = new LocalNode((class_2586)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.nodeCache[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public class_2338 getPos() {
        return this.method_11016();
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && nbt.method_10545("node0")) {
            this.convertOldNbt(nbt);
            this.method_5431();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        class_2499 nodes = nbt.method_10554("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((class_2586)this, (class_2487)tag);
        });
        if (nbt.method_10545("contraption") && !clientPacket) {
            this.wasContraption = nbt.method_10577("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.method_11010().method_11654(NodeRotation.ROTATION));
            if (rotation != NodeRotation.NONE) {
                this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.networkIn != null && this.networkOut != null) {
            this.networkIn.invalidate();
            this.networkOut.invalidate();
        }
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        class_2499 nodes = new class_2499();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            class_2487 tag = new class_2487();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.method_10566("nodes", (class_2520)nodes);
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        int comp = this.getComparatorOverride();
        if (comp != this.lastComparator) {
            assert (this.field_11863 != null);
            this.field_11863.method_8452(this.field_11867, (class_2248)CABlocks.ACCUMULATOR.get());
        }
        this.lastComparator = comp;
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.networkIn != null) {
                this.networkIn.invalidate();
            }
            if (this.networkOut != null) {
                this.networkOut.invalidate();
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.firstTick) {
            this.firstTick = false;
            if (this.wasContraption && !this.field_11863.method_8608()) {
                this.wasContraption = false;
                this.validateNodes();
            }
        }
        if (!this.wireCache.isEmpty() && !this.method_11015()) {
            this.handleWireCache(this.field_11863, this.wireCache);
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        assert (this.field_11863 != null);
        if (this.field_11863.method_8608()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        Transaction nested;
        if (this.awakeNetwork(this.field_11863)) {
            this.notifyUpdate();
        }
        if (this.networkOut == null) {
            return;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            long toExtract = 0L;
            nested = TransferUtil.getTransaction();
            try {
                toExtract = this.localEnergy.extract(this.demandOut, (TransactionContext)nested);
            }
            finally {
                if (nested != null) {
                    nested.close();
                }
            }
            this.localEnergy.extract(this.networkOut.push(toExtract), (TransactionContext)t);
            t.commit();
        }
        this.demandOut = this.networkOut.getDemand();
        t = TransferUtil.getTransaction();
        try {
            long toInsert = 0L;
            nested = TransferUtil.getTransaction();
            try {
                toInsert = this.localEnergy.insert(this.MAX_IN, (TransactionContext)nested);
            }
            finally {
                if (nested != null) {
                    nested.close();
                }
            }
            this.localEnergy.insert(this.networkIn.pull(Math.min(this.demandIn, toInsert)), (TransactionContext)t);
            t.commit();
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        t = TransferUtil.getTransaction();
        try {
            this.demandIn = this.networkIn.demand(this.localEnergy.insert(this.MAX_IN, (TransactionContext)t));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    public void remove() {
        if (this.field_11863.method_8608()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    @Override
    public boolean isNodeIndicesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    public void setEnergy(int energy) {
        this.localEnergy.setEnergy(energy);
    }

    @Override
    public int getComparatorOverride() {
        return (int)((double)this.localEnergy.getAmount() / (double)this.localEnergy.getCapacity() * 15.0);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        class_239 ray = class_310.method_1551().field_1765;
        if (ray == null) {
            return false;
        }
        int node = this.getAvailableNode(ray.method_17784());
        ObservePacket.send(this.field_11867, node);
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.accumulator.info").method_27692(class_124.field_1068)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.stored").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2585(" ")).method_10852((class_2561)Util.getTextComponent(this.localEnergy)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.selected").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2585(" ")).method_10852((class_2561)new class_2588(this.isNodeInput(node) ? "createaddition.tooltip.energy.input" : "createaddition.tooltip.energy.output").method_27692(class_124.field_1075)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.usage").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_27693(" ").method_27693(Util.format(EnergyNetworkPacket.clientBuff)).method_27693("fe/t").method_27692(class_124.field_1075));
        return true;
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.field_11867, this.getNetwork(pack.node()).getPulled(), this.getNetwork(pack.node()).getPushed(), player);
        }
        this.notifyUpdate();
    }
}

