/*
 * Decompiled with CFR 0.152.
 */
package velizarbg.suggestion_tweaker;

import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="suggestion-tweaker")
@Config.Gui.Background(value="minecraft:textures/block/ice.png")
public class ModConfig
implements ConfigData {
    @Comment(value="Should case be taken into account when suggestions are filtered and sorted?")
    public boolean isCaseSensitive = false;
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    @Comment(value="What is the requirement for a suggestion to be shown?\nSTRICT: It should start with the input\nSLIGHTLY_LOOSE: It should contain the input anywhere inside of it\nLOOSE: It should contain all of the input words that are separated by _ (an underscore), in any order\nVERY_LOOSE: It should contain all of the input's letters, in any order")
    public FilteringMode filteringMode = FilteringMode.LOOSE;
    public boolean shouldHideSuggestionsWithPrefix = false;
    public String hidePrefix = "_";

    public static ModConfig init() {
        AutoConfig.register(ModConfig.class, JanksonConfigSerializer::new);
        return (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FilteringMode {
        STRICT{

            @Override
            public boolean test(String input, String candidate) {
                return candidate.startsWith(input);
            }
        }
        ,
        SLIGHTLY_LOOSE{

            @Override
            public boolean test(String input, String candidate) {
                return candidate.contains(input);
            }
        }
        ,
        LOOSE{

            @Override
            public boolean test(String input, String candidate) {
                String[] allWords;
                for (String word : allWords = input.split("_")) {
                    if (candidate.contains(word)) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        VERY_LOOSE{

            @Override
            public boolean test(String input, String candidate) {
                Char2IntOpenHashMap inputCharCountMap = new Char2IntOpenHashMap();
                for (char c : input.toCharArray()) {
                    inputCharCountMap.addTo(c, 1);
                }
                for (char c : candidate.toCharArray()) {
                    if (!inputCharCountMap.containsKey(c)) continue;
                    inputCharCountMap.addTo(c, -1);
                    if (inputCharCountMap.get(c) != 0) continue;
                    inputCharCountMap.remove(c);
                }
                return inputCharCountMap.isEmpty();
            }
        };


        public abstract boolean test(String var1, String var2);

        public String toString() {
            return "suggestion-tweaker.filtering." + this.name().toLowerCase();
        }
    }
}

