/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2591;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_5134;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RegistryOverrideHandlers {
    public static final List<Pair<Class<?>, Class<?>>> REQUESTED_FIELDS = new ArrayList();
    public static final BiConsumer<Object, Object> BLOCKS = RegistryOverrideHandlers.overrideFields(class_2246.class, class_2248.class);
    public static final BiConsumer<Object, Object> FLUIDS = RegistryOverrideHandlers.overrideFields(class_3612.class, class_3611.class);
    public static final BiConsumer<Object, Object> ITEMS = RegistryOverrideHandlers.overrideFields(class_1802.class, class_1792.class).andThen((oldValue, newValue) -> class_1792.field_8003.entrySet().stream().filter(entry -> entry.getValue() == oldValue).toList().forEach(entry -> class_1792.field_8003.put((class_2248)entry.getKey(), (class_1792)newValue)));
    public static final BiConsumer<Object, Object> MOB_EFFECTS = RegistryOverrideHandlers.overrideFields(class_1294.class, class_1291.class);
    public static final BiConsumer<Object, Object> SOUND_EVENTS = RegistryOverrideHandlers.overrideFields(class_3417.class, class_3414.class);
    public static final BiConsumer<Object, Object> POTIONS = RegistryOverrideHandlers.overrideFields(class_1847.class, class_1842.class);
    public static final BiConsumer<Object, Object> ENCHANTMENTS = RegistryOverrideHandlers.overrideFields(class_1893.class, class_1887.class);
    public static final BiConsumer<Object, Object> ENTITY_TYPES = RegistryOverrideHandlers.overrideFields(class_1299.class, class_1299.class);
    public static final BiConsumer<Object, Object> BLOCK_ENTITY_TYPES = RegistryOverrideHandlers.overrideFields(class_2591.class, class_2591.class);
    public static final BiConsumer<Object, Object> PARTICLE_TYPES = RegistryOverrideHandlers.overrideFields(class_2398.class, class_2396.class);
    public static final BiConsumer<Object, Object> MENU_TYPES = RegistryOverrideHandlers.overrideFields(class_3917.class, class_3917.class);
    public static final BiConsumer<Object, Object> RECIPE_TYPES = RegistryOverrideHandlers.overrideFields(class_3956.class, class_3956.class);
    public static final BiConsumer<Object, Object> RECIPE_SERIALIZERS = RegistryOverrideHandlers.overrideFields(class_1865.class, class_1865.class);
    public static final BiConsumer<Object, Object> ATTRIBUTES = RegistryOverrideHandlers.overrideFields(class_5134.class, class_1320.class);
    public static final BiConsumer<Object, Object> STAT_TYPES = RegistryOverrideHandlers.overrideFields(class_3468.class, class_3448.class);

    private static BiConsumer<Object, Object> overrideFields(Class<?> clazz, Class<?> fieldType) {
        REQUESTED_FIELDS.add(Pair.of(clazz, fieldType));
        Supplier<Field[]> fields = RegistryOverrideHandlers.findFieldsInClass(clazz, fieldType, false);
        return (oldValue, newValue) -> RegistryOverrideHandlers.replaceValueInFields((Field[])fields.get(), oldValue, newValue);
    }

    public static Supplier<Field[]> findFieldsInClass(Class<?> clazz, Class<?> fieldType, boolean allowFinal) {
        Holder fieldsHolder = new Holder();
        return () -> {
            if (fieldsHolder.get() == null) {
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Field field : clazz.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !allowFinal && Modifier.isFinal(field.getModifiers()) || !fieldType.isAssignableFrom(field.getType())) continue;
                    fields.add(field);
                }
                fieldsHolder.set((Field[])fields.toArray(Field[]::new));
            }
            return (Field[])fieldsHolder.get();
        };
    }

    private static void replaceValueInFields(Field[] fields, Object oldValue, Object newValue) {
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.get(null) != oldValue) continue;
                if (field.getType().isAssignableFrom(newValue.getClass())) {
                    field.set(null, newValue);
                    continue;
                }
                CoreLib.LOGGER.warn("Could not override field '" + field + "' of type '" + field.getType() + "' with value '" + newValue + "' of type '" + newValue.getClass() + "'!");
            }
        }
        catch (IllegalAccessException e) {
            CoreLib.LOGGER.error("Encountered an exception whilst applying registry overrides in a vanilla class! Vanilla fields will not be updated!", (Throwable)e);
        }
    }
}

