/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.serialization.Lifecycle;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.data.tag.CustomTagEntrySerializer;
import com.supermartijn642.core.extensions.CoreLibMappedRegistry;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.core.registry.RegistryOverrideHandlers;
import com.supermartijn642.core.util.MappedSetView;
import com.supermartijn642.core.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class Registries {
    static final Map<class_2960, Registry<?>> IDENTIFIER_TO_REGISTRY = new HashMap();
    static final Map<class_2378<?>, Registry<?>> VANILLA_REGISTRY_MAP = new HashMap();
    static final List<Registry<?>> REGISTRATION_ORDER;
    public static final Registry<class_2248> BLOCKS;
    public static final Registry<class_3611> FLUIDS;
    public static final Registry<class_1792> ITEMS;
    public static final Registry<class_1291> MOB_EFFECTS;
    public static final Registry<class_3414> SOUND_EVENTS;
    public static final Registry<class_1842> POTIONS;
    public static final Registry<class_1887> ENCHANTMENTS;
    public static final Registry<class_1299<?>> ENTITY_TYPES;
    public static final Registry<class_2591<?>> BLOCK_ENTITY_TYPES;
    public static final Registry<class_2396<?>> PARTICLE_TYPES;
    public static final Registry<class_3917<?>> MENU_TYPES;
    public static final Registry<class_1535> PAINTING_VARIANTS;
    public static final Registry<class_3956<?>> RECIPE_TYPES;
    public static final Registry<class_1865<?>> RECIPE_SERIALIZERS;
    public static final Registry<class_1320> ATTRIBUTES;
    public static final Registry<class_3448<?>> STAT_TYPES;
    public static final Registry<ResourceConditionSerializer<?>> RESOURCE_CONDITION_SERIALIZERS;
    public static final Registry<CustomTagEntrySerializer<?>> CUSTOM_TAG_ENTRY_SERIALIZERS;

    private static void addRegistry(Registry<?> registry) {
        if (IDENTIFIER_TO_REGISTRY.containsKey(registry.getRegistryIdentifier())) {
            throw new RuntimeException("Duplicate registry registration for identifier '" + registry.getRegistryIdentifier() + "'!");
        }
        if (registry.hasVanillaRegistry() && VANILLA_REGISTRY_MAP.containsKey(registry.getVanillaRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + registry.getValueClass() + "'!");
        }
        IDENTIFIER_TO_REGISTRY.put(registry.getRegistryIdentifier(), registry);
        if (registry.hasVanillaRegistry()) {
            VANILLA_REGISTRY_MAP.put(registry.getVanillaRegistry(), registry);
        }
    }

    @Deprecated
    public static <T> Registry<T> fromUnderlying(class_2378<T> registry) {
        return VANILLA_REGISTRY_MAP.get(registry);
    }

    public static Registry<?> getRegistry(class_2960 identifier) {
        return IDENTIFIER_TO_REGISTRY.get(identifier);
    }

    private static <T> Registry<T> vanilla(class_2378<T> registry, Class<? super T> valueClass, BiConsumer<Object, Object> overrideConsumer) {
        return new VanillaRegistryWrapper<T>(registry, valueClass, overrideConsumer);
    }

    private static <T> Registry<T> vanilla(class_2378<T> registry, Class<? super T> valueClass) {
        return Registries.vanilla(registry, valueClass, null);
    }

    static {
        BLOCKS = Registries.vanilla(class_2378.field_11146, class_2248.class, RegistryOverrideHandlers.BLOCKS);
        FLUIDS = Registries.vanilla(class_2378.field_11154, class_3611.class, RegistryOverrideHandlers.FLUIDS);
        ITEMS = Registries.vanilla(class_2378.field_11142, class_1792.class, RegistryOverrideHandlers.ITEMS);
        MOB_EFFECTS = Registries.vanilla(class_2378.field_11159, class_1291.class, RegistryOverrideHandlers.MOB_EFFECTS);
        SOUND_EVENTS = Registries.vanilla(class_2378.field_11156, class_3414.class, RegistryOverrideHandlers.SOUND_EVENTS);
        POTIONS = Registries.vanilla(class_2378.field_11143, class_1842.class, RegistryOverrideHandlers.POTIONS);
        ENCHANTMENTS = Registries.vanilla(class_2378.field_11160, class_1887.class, RegistryOverrideHandlers.ENCHANTMENTS);
        ENTITY_TYPES = Registries.vanilla(class_2378.field_11145, class_1299.class, RegistryOverrideHandlers.ENTITY_TYPES);
        BLOCK_ENTITY_TYPES = Registries.vanilla(class_2378.field_11137, class_2591.class, RegistryOverrideHandlers.BLOCK_ENTITY_TYPES);
        PARTICLE_TYPES = Registries.vanilla(class_2378.field_11141, class_2396.class, RegistryOverrideHandlers.PARTICLE_TYPES);
        MENU_TYPES = Registries.vanilla(class_2378.field_17429, class_3917.class, RegistryOverrideHandlers.MENU_TYPES);
        PAINTING_VARIANTS = Registries.vanilla(class_2378.field_11150, class_1535.class);
        RECIPE_TYPES = Registries.vanilla(class_2378.field_17597, class_3956.class, RegistryOverrideHandlers.RECIPE_TYPES);
        RECIPE_SERIALIZERS = Registries.vanilla(class_2378.field_17598, class_1865.class, RegistryOverrideHandlers.RECIPE_SERIALIZERS);
        ATTRIBUTES = Registries.vanilla(class_2378.field_23781, class_1320.class, RegistryOverrideHandlers.ATTRIBUTES);
        STAT_TYPES = Registries.vanilla(class_2378.field_11152, class_3448.class, RegistryOverrideHandlers.STAT_TYPES);
        RESOURCE_CONDITION_SERIALIZERS = new MapBackedRegistry<ResourceConditionSerializer<?>>(new class_2960("supermartijn642corelib", "resource_conditions"), ResourceConditionSerializer.class){

            @Override
            public void register(class_2960 identifier, ResourceConditionSerializer<?> object) {
                super.register(identifier, object);
                ResourceConditions.register((class_2960)identifier, json -> {
                    Object condition;
                    try {
                        condition = object.deserialize((JsonObject)json);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Encountered exception whilst testing condition '" + identifier + "'!", e);
                    }
                    return condition.test(new ResourceConditionContext());
                });
            }
        };
        CUSTOM_TAG_ENTRY_SERIALIZERS = new MapBackedRegistry<CustomTagEntrySerializer>(new class_2960("supermartijn642corelib", "custom_tag_entries"), CustomTagEntrySerializer.class);
        REGISTRATION_ORDER = Lists.newArrayList((Object[])new Registry[]{BLOCKS, FLUIDS, ITEMS, MOB_EFFECTS, SOUND_EVENTS, POTIONS, ENCHANTMENTS, ENTITY_TYPES, BLOCK_ENTITY_TYPES, PARTICLE_TYPES, MENU_TYPES, PAINTING_VARIANTS, RECIPE_SERIALIZERS, ATTRIBUTES, STAT_TYPES, RESOURCE_CONDITION_SERIALIZERS, CUSTOM_TAG_ENTRY_SERIALIZERS});
    }

    public static interface Registry<T> {
        public class_2960 getRegistryIdentifier();

        @Nullable
        public class_2378<T> getVanillaRegistry();

        public boolean hasVanillaRegistry();

        public void register(class_2960 var1, T var2);

        public class_2960 getIdentifier(T var1);

        public boolean hasIdentifier(class_2960 var1);

        public T getValue(class_2960 var1);

        public Set<class_2960> getIdentifiers();

        public Collection<T> getValues();

        public Set<Pair<class_2960, T>> getEntries();

        public Class<T> getValueClass();
    }

    private static class VanillaRegistryWrapper<T>
    implements Registry<T> {
        private final class_2378<T> registry;
        private final class_2960 identifier;
        private final Class<T> valueClass;
        private final BiConsumer<Object, Object> overrideConsumer;

        private VanillaRegistryWrapper(class_2378<T> registry, Class<? super T> valueClass, BiConsumer<Object, Object> overrideConsumer) {
            this.registry = registry;
            this.identifier = registry.method_30517().method_29177();
            this.valueClass = valueClass;
            this.overrideConsumer = overrideConsumer;
            Registries.addRegistry(this);
        }

        @Override
        public class_2960 getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Deprecated
        @Nullable
        public class_2378<T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return true;
        }

        @Override
        public void register(class_2960 identifier, T object) {
            if (this.registry instanceof class_2370 && this.registry.method_10250(identifier)) {
                class_5321 key = class_5321.method_29179((class_5321)this.registry.method_30517(), (class_2960)identifier);
                Object oldObject = this.registry.method_29107(key);
                int id = this.registry.method_10206(oldObject);
                ((CoreLibMappedRegistry)this.registry).supermartijn642corelibSetRegisterOverrides(true, this.overrideConsumer);
                ((class_2370)this.registry).method_31062(OptionalInt.of(id), key, object, Lifecycle.stable());
                ((CoreLibMappedRegistry)this.registry).supermartijn642corelibSetRegisterOverrides(false, null);
                return;
            }
            class_2378.method_10230(this.registry, (class_2960)identifier, object);
        }

        @Override
        public class_2960 getIdentifier(T object) {
            return this.registry.method_10221(object);
        }

        @Override
        public boolean hasIdentifier(class_2960 identifier) {
            return this.registry.method_10250(identifier);
        }

        @Override
        public T getValue(class_2960 identifier) {
            return (T)this.registry.method_10223(identifier);
        }

        @Override
        public Set<class_2960> getIdentifiers() {
            return this.registry.method_10235();
        }

        @Override
        public Collection<T> getValues() {
            return MappedSetView.map(this.registry.method_29722(), Map.Entry::getValue);
        }

        @Override
        public Set<Pair<class_2960, T>> getEntries() {
            return MappedSetView.map(this.registry.method_29722(), entry -> Pair.of(((class_5321)entry.getKey()).method_29177(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            int result = this.registry.hashCode();
            result = 31 * result + this.valueClass.hashCode();
            return result;
        }
    }

    private static class MapBackedRegistry<T>
    implements Registry<T> {
        private final class_2960 identifier;
        private final Map<class_2960, T> identifierToObject = new HashMap<class_2960, T>();
        private final Map<T, class_2960> objectToIdentifier = new HashMap<T, class_2960>();
        private final Set<Pair<class_2960, T>> entries = new HashSet<Pair<class_2960, T>>();
        private final Class<T> valueClass;

        private MapBackedRegistry(class_2960 identifier, Class<? super T> valueClass) {
            this.identifier = identifier;
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        @Override
        public class_2960 getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        public class_2378<T> getVanillaRegistry() {
            return null;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return false;
        }

        @Override
        public void register(class_2960 identifier, T object) {
            if (this.identifierToObject.containsKey(identifier)) {
                throw new RuntimeException("Duplicate registry for identifier '" + identifier + "'!");
            }
            if (this.objectToIdentifier.containsKey(object)) {
                throw new RuntimeException("Duplicate registry for object under '" + this.objectToIdentifier.get(object) + "' and '" + identifier + "'!");
            }
            if (ResourceConditions.get((class_2960)identifier) != null) {
                throw new RuntimeException("A resource condition with identifier '" + identifier + "' has already been registered to Fabric's registry!");
            }
            this.identifierToObject.put(identifier, object);
            this.objectToIdentifier.put(object, identifier);
            this.entries.add(Pair.of(identifier, object));
            RegistryEntryAcceptor.Handler.onRegisterEvent(this, identifier, object);
        }

        @Override
        public class_2960 getIdentifier(T object) {
            return this.objectToIdentifier.get(object);
        }

        @Override
        public boolean hasIdentifier(class_2960 identifier) {
            return this.identifierToObject.containsKey(identifier);
        }

        @Override
        public T getValue(class_2960 identifier) {
            return this.identifierToObject.get(identifier);
        }

        @Override
        public Set<class_2960> getIdentifiers() {
            return Collections.unmodifiableSet(this.identifierToObject.keySet());
        }

        @Override
        public Collection<T> getValues() {
            return Collections.unmodifiableCollection(this.objectToIdentifier.keySet());
        }

        @Override
        public Set<Pair<class_2960, T>> getEntries() {
            return Collections.unmodifiableSet(this.entries);
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }
    }
}

