/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.BaseContainerType;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;

public abstract class ObjectBaseContainer<T>
extends BaseContainer {
    protected T object;
    private final boolean alwaysRenewObject;

    public ObjectBaseContainer(BaseContainerType<?> type, class_1657 player, boolean alwaysRenewObject) {
        super(type, player);
        this.alwaysRenewObject = alwaysRenewObject;
    }

    public ObjectBaseContainer(BaseContainerType<?> type, class_1657 player) {
        this(type, player, false);
    }

    @Override
    protected void addSlots(class_1657 player) {
        if (this.validateObjectOrClose()) {
            this.addSlots(player, this.object);
        }
    }

    protected abstract void addSlots(class_1657 var1, @NotNull T var2);

    protected abstract T getObject(T var1);

    protected abstract boolean validateObject(T var1);

    protected boolean validateObjectOrClose() {
        if (this.alwaysRenewObject || !this.validateObject(this.object)) {
            this.object = this.getObject(this.object);
            if (!this.validateObject(this.object)) {
                CommonUtils.closeContainer(this.player);
                return false;
            }
        }
        return true;
    }
}

