/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.TranslationsAggregator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public abstract class LanguageGenerator
extends ResourceGenerator {
    private final Map<String, String> translations = new LinkedHashMap<String, String>();
    protected final String langCode;

    public LanguageGenerator(String modid, ResourceCache cache, String langCode) {
        super(modid, cache);
        if (!langCode.matches("[a-z]{2}_[a-z]{2}")) {
            throw new IllegalArgumentException("Invalid lang code '" + langCode + "'!");
        }
        this.langCode = langCode;
    }

    @Override
    public void save() {
        this.cache.saveResource(ResourceType.ASSET, TranslationsAggregator.INSTANCE, this.translations, this.modid, "lang", this.langCode, ".json");
    }

    protected void translation(String translationKey, String translation) {
        if (translationKey.isBlank()) {
            throw new IllegalArgumentException("Translation key '" + translation + "' for translation '" + translation + "' must not be empty!");
        }
        this.translations.put(translationKey, translation);
    }

    protected void itemGroup(class_1761 group, String translation) {
        class_2561 component = group.method_7737();
        if (component instanceof class_2588) {
            this.translation(((class_2588)component).method_11022(), translation);
        }
        this.translation(group.field_7935, translation);
    }

    protected void item(class_1792 item, String translation) {
        this.translation(item.method_7876(), translation);
    }

    protected void block(class_2248 block, String translation) {
        this.translation(block.method_9539(), translation);
    }

    @Override
    public String getName() {
        return this.modName + " Language Generator";
    }
}

