/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.util.TriPredicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class BlockProperties {
    private final class_3614 material;
    private final class_3620 mapColor;
    private boolean hasCollision = true;
    private boolean canOcclude = true;
    private class_2498 soundType = class_2498.field_11544;
    private ToIntFunction<class_2680> lightLevel = state -> 0;
    private float explosionResistance;
    private float destroyTime;
    private boolean requiresCorrectTool = false;
    private boolean ticksRandomly = false;
    private float friction = 0.6f;
    private float speedFactor = 1.0f;
    private float jumpFactor = 1.0f;
    private boolean isAir = false;
    private TriPredicate<class_2680, class_1922, class_2338> isRedstoneConductor = (state, level, pos) -> state.method_26207().method_15804() && state.method_26234(level, pos);
    private TriPredicate<class_2680, class_1922, class_2338> isSuffocating = (state, level, pos) -> state.method_26207().method_15801() && state.method_26234(level, pos);
    private boolean hasDynamicShape = false;
    boolean noLootTable = false;
    Supplier<class_2248> lootTableBlock;
    class_2960 lootTable;

    public static BlockProperties create(class_3614 material, class_3620 color) {
        return new BlockProperties(material, color);
    }

    public static BlockProperties create(class_3614 material, class_1767 color) {
        return new BlockProperties(material, color.method_7794());
    }

    public static BlockProperties create(class_3614 material) {
        return new BlockProperties(material, material.method_15803());
    }

    public static BlockProperties copy(class_2248 block) {
        class_4970.class_2251 sourceProperties = block.field_23155;
        BlockProperties properties = BlockProperties.create(sourceProperties.field_10668, block.method_26403());
        properties.hasCollision = sourceProperties.field_10664;
        properties.canOcclude = block.method_9564().method_26225();
        properties.soundType = block.method_9573(block.method_9564());
        properties.lightLevel = sourceProperties.field_10663;
        properties.explosionResistance = block.method_9520();
        properties.destroyTime = block.method_36555();
        properties.requiresCorrectTool = block.method_9564().method_29291();
        properties.ticksRandomly = block.method_9542(block.method_9564());
        properties.friction = block.method_9499();
        properties.speedFactor = block.method_23349();
        properties.jumpFactor = block.method_23350();
        properties.isAir = block.method_9564().method_26215();
        properties.isRedstoneConductor = (arg_0, arg_1, arg_2) -> ((class_4970.class_4973)sourceProperties.field_23182).test(arg_0, arg_1, arg_2);
        properties.isSuffocating = (arg_0, arg_1, arg_2) -> ((class_4970.class_4973)sourceProperties.field_23183).test(arg_0, arg_1, arg_2);
        properties.hasDynamicShape = block.method_9543();
        properties.lootTable = sourceProperties.field_10666;
        return properties;
    }

    private BlockProperties(class_3614 material, class_3620 color) {
        this.material = material;
        this.mapColor = color;
    }

    public BlockProperties noCollision() {
        this.hasCollision = false;
        this.canOcclude = false;
        return this;
    }

    public BlockProperties noOcclusion() {
        this.canOcclude = false;
        return this;
    }

    public BlockProperties sound(class_2498 soundTypeIn) {
        this.soundType = soundTypeIn;
        return this;
    }

    public BlockProperties lightLevel(ToIntFunction<class_2680> stateLightFunction) {
        this.lightLevel = stateLightFunction;
        return this;
    }

    public BlockProperties lightLevel(int light) {
        this.lightLevel = state -> light;
        return this;
    }

    public BlockProperties explosionResistance(float resistance) {
        this.explosionResistance = Math.max(0.0f, resistance);
        return this;
    }

    public BlockProperties destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockProperties requiresCorrectTool() {
        this.requiresCorrectTool = true;
        return this;
    }

    public BlockProperties randomTicks() {
        this.ticksRandomly = true;
        return this;
    }

    public BlockProperties friction(float friction) {
        this.friction = friction;
        return this;
    }

    public BlockProperties speedFactor(float factor) {
        this.speedFactor = factor;
        return this;
    }

    public BlockProperties jumpFactor(float factor) {
        this.jumpFactor = factor;
        return this;
    }

    public BlockProperties air() {
        this.isAir = true;
        return this;
    }

    public BlockProperties isRedstoneConductor(TriPredicate<class_2680, class_1922, class_2338> isRedstoneConductor) {
        this.isRedstoneConductor = isRedstoneConductor;
        return this;
    }

    public BlockProperties isRedstoneConductor(boolean isRedstoneConductor) {
        this.isRedstoneConductor = (state, blockGetter, pos) -> isRedstoneConductor;
        return this;
    }

    public BlockProperties isSuffocating(TriPredicate<class_2680, class_1922, class_2338> isSuffocating) {
        this.isSuffocating = isSuffocating;
        return this;
    }

    public BlockProperties isSuffocating(boolean isSuffocating) {
        this.isSuffocating = (state, blockGetter, pos) -> isSuffocating;
        return this;
    }

    public BlockProperties dynamicShape() {
        this.hasDynamicShape = true;
        return this;
    }

    public BlockProperties noLootTable() {
        this.noLootTable = true;
        this.lootTableBlock = null;
        this.lootTable = null;
        return this;
    }

    public BlockProperties lootTable(class_2960 lootTable) {
        this.noLootTable = false;
        this.lootTableBlock = null;
        this.lootTable = lootTable;
        return this;
    }

    public BlockProperties lootTableFrom(Supplier<class_2248> block) {
        this.noLootTable = false;
        this.lootTableBlock = block;
        this.lootTable = null;
        return this;
    }

    @Deprecated
    public class_4970.class_2251 toUnderlying() {
        class_4970.class_2251 properties = class_4970.class_2251.method_9639((class_3614)this.material, (class_3620)this.mapColor);
        if (!this.hasCollision) {
            properties.method_9634();
        }
        properties.method_9626(this.soundType);
        properties.method_9631(this.lightLevel);
        properties.method_9632(this.explosionResistance);
        properties.method_36557(this.destroyTime);
        if (this.requiresCorrectTool) {
            properties.method_29292();
        }
        if (this.ticksRandomly) {
            properties.method_9640();
        }
        properties.method_9628(this.friction);
        properties.method_23351(this.speedFactor);
        properties.method_23352(this.jumpFactor);
        if (this.noLootTable) {
            properties.method_16229();
        }
        if (!this.canOcclude) {
            properties.method_22488();
        }
        if (this.isAir) {
            properties.method_26250();
        }
        properties.method_26236(this.isRedstoneConductor::test);
        properties.method_26243(this.isSuffocating::test);
        properties.method_26245(this.isSuffocating::test);
        if (this.hasDynamicShape) {
            properties.method_9624();
        }
        return properties;
    }
}

