/*
 * Decompiled with CFR 0.152.
 */
package net.cavoj.servertick;

import io.netty.buffer.ByteBuf;
import net.cavoj.servertick.NetworkC2S;
import net.cavoj.servertick.NetworkS2C;
import net.cavoj.servertick.extensions.SerializableMetricsData;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3517;

public class ServerTickClient
implements ClientModInitializer {
    private static ServerTickClient _instance;
    private boolean debugTpsEnabled;
    private class_3517 metrics;

    public ServerTickClient() {
        if (_instance != null) {
            throw new RuntimeException("Cannot have multiple instances");
        }
        _instance = this;
    }

    public static ServerTickClient getInstance() {
        return _instance;
    }

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkS2C.PACKET_FULL_METRICS, (client, handler, buf, responseSender) -> {
            ByteBuf bufcopy = buf.copy();
            client.execute(() -> {
                if (this.metrics == null) {
                    this.metrics = new class_3517();
                }
                ((SerializableMetricsData)this.metrics).deserialize(bufcopy);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkS2C.PACKET_LAST_SAMPLE, (client, handler, buf, responseSender) -> {
            long time = buf.readLong();
            client.execute(() -> {
                if (this.metrics != null) {
                    this.metrics.method_15247(time);
                }
            });
        });
    }

    public void setTpsEnabled(boolean enabled) {
        if (this.debugTpsEnabled != enabled) {
            if (enabled) {
                this.setMetricsData(null);
            }
            this.debugTpsEnabled = enabled;
            NetworkC2S.sendToggle(enabled);
        }
    }

    public void setMetricsData(class_3517 data) {
        this.metrics = data;
    }

    public class_3517 getMetricsData() {
        return this.metrics;
    }

    public void joined() {
        this.setMetricsData(null);
        this.setTpsEnabled(false);
    }
}

