/*
 * Decompiled with CFR 0.152.
 */
package dev.definedentity.astralgenerators.multiblock;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import definedentity.xenon.vec.Quat;
import definedentity.xenon.vec.Rotation;
import dev.definedentity.astralgenerators.AstralGenerators;
import dev.definedentity.astralgenerators.multiblock.MultiBlockDefinition;
import dev.definedentity.astralgenerators.multiblock.MultiBlockPart;
import dev.definedentity.astralgenerators.network.ChannelList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J3\u0010\u000e\u001a\u00020\r2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Ldev/definedentity/astralgenerators/multiblock/MultiBlockManager;", "Lnet/minecraft/class_4309;", "Lnet/fabricmc/fabric/api/resource/IdentifiableResourceReloadListener;", "<init>", "()V", "", "Lnet/minecraft/class_2960;", "Lcom/google/gson/JsonElement;", "object", "Lnet/minecraft/class_3300;", "resourceManager", "Lnet/minecraft/class_3695;", "profiler", "", "apply", "(Ljava/util/Map;Lnet/minecraft/class_3300;Lnet/minecraft/class_3695;)V", "getFabricId", "()Lnet/minecraft/class_2960;", "Companion", "astralgenerators"})
public final class MultiBlockManager
extends class_4309
implements IdentifiableResourceReloadListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Gson GSON;
    @NotNull
    private static final HashMap<class_2960, MultiBlockDefinition> LOCAL_DEFINITIONS;
    @NotNull
    private static final HashMap<class_2960, MultiBlockDefinition> SERVER_DEFINITIONS;

    public MultiBlockManager() {
        super(GSON, "multiblocks");
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> object, @NotNull class_3300 resourceManager, @NotNull class_3695 profiler) {
        Intrinsics.checkNotNullParameter(object, (String)"object");
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        LOCAL_DEFINITIONS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : object.entrySet()) {
            class_2960 key = entry.getKey();
            JsonElement value = entry.getValue();
            try {
                ((Map)LOCAL_DEFINITIONS).put(key, new MultiBlockDefinition(key, value));
            }
            catch (Exception e) {
                AstralGenerators.Companion.getLOGGER().error(e.getMessage());
            }
        }
    }

    @NotNull
    public class_2960 getFabricId() {
        return new class_2960(AstralGenerators.Companion.getMOD_ID(), "multiblocks");
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
        LOCAL_DEFINITIONS = new HashMap();
        SERVER_DEFINITIONS = new HashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001f\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\"\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b\"\u0010#R\u0017\u0010%\u001a\u00020$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R3\u0010+\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0)j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R3\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0)j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`*8\u0006\u00a2\u0006\f\n\u0004\b/\u0010,\u001a\u0004\b0\u0010.\u00a8\u00061"}, d2={"Ldev/definedentity/astralgenerators/multiblock/MultiBlockManager$Companion;", "", "<init>", "()V", "", "init", "Lnet/minecraft/class_3222;", "player", "", "isJoined", "syncDatapack", "(Lnet/minecraft/class_3222;Z)V", "", "Lnet/minecraft/class_2960;", "Ldev/definedentity/astralgenerators/multiblock/MultiBlockDefinition;", "multiBlockMap", "sendMultiBlockDefinition", "(Lnet/minecraft/class_3222;Ljava/util/Map;)V", "Lcom/google/common/collect/ImmutableMap;", "getDefinitions", "()Lcom/google/common/collect/ImmutableMap;", "Lcom/google/common/collect/ImmutableList;", "getRegisteredIds", "()Lcom/google/common/collect/ImmutableList;", "id", "getDefinition", "(Lnet/minecraft/class_2960;)Ldev/definedentity/astralgenerators/multiblock/MultiBlockDefinition;", "Lnet/minecraft/class_3218;", "level", "Lnet/minecraft/class_2338;", "placePos", "Lnet/minecraft/class_243;", "rotation", "", "placeCommand", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_2960;Lnet/minecraft/class_243;)I", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "LOCAL_DEFINITIONS", "Ljava/util/HashMap;", "getLOCAL_DEFINITIONS", "()Ljava/util/HashMap;", "SERVER_DEFINITIONS", "getSERVER_DEFINITIONS", "astralgenerators"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        @NotNull
        public final HashMap<class_2960, MultiBlockDefinition> getLOCAL_DEFINITIONS() {
            return LOCAL_DEFINITIONS;
        }

        @NotNull
        public final HashMap<class_2960, MultiBlockDefinition> getSERVER_DEFINITIONS() {
            return SERVER_DEFINITIONS;
        }

        public final void init() {
            ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new MultiBlockManager());
            ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(this::syncDatapack);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ClientPlayConnectionEvents.DISCONNECT.register(Companion::init$lambda$0);
            }
        }

        private final void syncDatapack(class_3222 player, boolean isJoined) {
            if (!isJoined) {
                return;
            }
            this.sendMultiBlockDefinition(player, (Map)this.getDefinitions());
        }

        private final void sendMultiBlockDefinition(class_3222 player, Map<class_2960, MultiBlockDefinition> multiBlockMap) {
            class_2540 packet = PacketByteBufs.create();
            packet.method_10804(multiBlockMap.size());
            for (Map.Entry<class_2960, MultiBlockDefinition> entry : multiBlockMap.entrySet()) {
                class_2960 key = entry.getKey();
                MultiBlockDefinition value = entry.getValue();
                packet.method_10812(key);
                packet.method_10814(this.getGSON().toJson(value.getJson()));
            }
            ServerPlayNetworking.send((class_3222)player, (class_2960)ChannelList.Companion.getMULTIBLOCK_CHANNEL(), (class_2540)packet);
        }

        @NotNull
        public final ImmutableMap<class_2960, MultiBlockDefinition> getDefinitions() {
            if (this.getSERVER_DEFINITIONS().isEmpty()) {
                ImmutableMap immutableMap = ImmutableMap.copyOf((Map)this.getLOCAL_DEFINITIONS());
                Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
                return immutableMap;
            }
            ImmutableMap immutableMap = ImmutableMap.copyOf((Map)this.getSERVER_DEFINITIONS());
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
            return immutableMap;
        }

        @NotNull
        public final ImmutableList<class_2960> getRegisteredIds() {
            ImmutableList immutableList = ImmutableList.copyOf((Collection)this.getLOCAL_DEFINITIONS().keySet());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            return immutableList;
        }

        @Nullable
        public final MultiBlockDefinition getDefinition(@NotNull class_2960 id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.getLOCAL_DEFINITIONS().get(id);
        }

        public final int placeCommand(@NotNull class_3218 level, @NotNull class_2338 placePos, @Nullable class_2960 id, @NotNull class_243 rotation) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)placePos, (String)"placePos");
            Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
            class_2960 class_29602 = id;
            Intrinsics.checkNotNull((Object)class_29602);
            MultiBlockDefinition definition = this.getDefinition(class_29602);
            if (definition != null) {
                for (Map.Entry entry : ((Map)definition.getBlocks(new Rotation(new Quat(new Quaternionf().rotationXYZ((float)rotation.field_1352 * ((float)Math.PI / 180), (float)rotation.field_1351 * ((float)Math.PI / 180), (float)rotation.field_1350 * ((float)Math.PI / 180)))))).entrySet()) {
                    class_2338 offset = (class_2338)entry.getKey();
                    MultiBlockPart value = (MultiBlockPart)entry.getValue();
                    ArrayList arrayList = Lists.newArrayList((Iterable)value.validBlocks());
                    Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
                    List blocks = arrayList;
                    if (!(!((Collection)blocks).isEmpty())) continue;
                    class_2338 pos = placePos.method_10081((class_2382)offset);
                    level.method_8501(pos, ((class_2248)blocks.get(0)).method_9564());
                }
                return 0;
            }
            return 1;
        }

        private static final void init$lambda$0(class_634 class_6342, class_310 class_3102) {
            Companion.getSERVER_DEFINITIONS().clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

