/*
 * Decompiled with CFR 0.152.
 */
package dev.definedentity.astralgenerators.multiblock;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import definedentity.xenon.vec.Rotation;
import definedentity.xenon.vec.Transformation;
import definedentity.xenon.vec.Vector3;
import dev.definedentity.astralgenerators.multiblock.BlockPart;
import dev.definedentity.astralgenerators.multiblock.EmptyPart;
import dev.definedentity.astralgenerators.multiblock.InvalidPart;
import dev.definedentity.astralgenerators.multiblock.MultiBlockPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0019J)\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0015\u0010\u001aJ#\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\u0004\b \u0010!J+\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b \u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$R\u001e\u0010&\u001a\n %*\u0004\u0018\u00010\u00100\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R0\u0010*\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110(j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Ldev/definedentity/astralgenerators/multiblock/MultiBlockDefinition;", "", "Lnet/minecraft/class_2960;", "id", "Lcom/google/gson/JsonElement;", "json", "<init>", "(Lnet/minecraft/class_2960;Lcom/google/gson/JsonElement;)V", "", "loadFromJson", "()V", "getId", "()Lnet/minecraft/class_2960;", "getJson", "()Lcom/google/gson/JsonElement;", "Lcom/google/common/collect/ImmutableMap;", "Lnet/minecraft/class_2338;", "Ldev/definedentity/astralgenerators/multiblock/MultiBlockPart;", "getBlocks", "()Lcom/google/common/collect/ImmutableMap;", "worldOrigin", "getBlockAt", "(Lnet/minecraft/class_2338;)Lcom/google/common/collect/ImmutableMap;", "Ldefinedentity/xenon/vec/Rotation;", "rotation", "(Ldefinedentity/xenon/vec/Rotation;)Lcom/google/common/collect/ImmutableMap;", "(Lnet/minecraft/class_2338;Ldefinedentity/xenon/vec/Rotation;)Lcom/google/common/collect/ImmutableMap;", "Lnet/minecraft/class_1937;", "level", "originPos", "Ljava/util/ArrayList;", "Ldev/definedentity/astralgenerators/multiblock/InvalidPart;", "test", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Ljava/util/ArrayList;", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Ldefinedentity/xenon/vec/Rotation;)Ljava/util/ArrayList;", "Lnet/minecraft/class_2960;", "Lcom/google/gson/JsonElement;", "kotlin.jvm.PlatformType", "origin", "Lnet/minecraft/class_2338;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "blockMap", "Ljava/util/HashMap;", "astralgenerators"})
@SourceDebugExtension(value={"SMAP\nMultiBlockDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiBlockDefinition.kt\ndev/definedentity/astralgenerators/multiblock/MultiBlockDefinition\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,162:1\n216#2,2:163\n216#2,2:165\n216#2,2:167\n216#2,2:169\n216#2,2:171\n*S KotlinDebug\n*F\n+ 1 MultiBlockDefinition.kt\ndev/definedentity/astralgenerators/multiblock/MultiBlockDefinition\n*L\n104#1:163,2\n113#1:165,2\n129#1:167,2\n141#1:169,2\n153#1:171,2\n*E\n"})
public final class MultiBlockDefinition {
    @NotNull
    private final class_2960 id;
    @NotNull
    private final JsonElement json;
    private class_2338 origin;
    @NotNull
    private final HashMap<class_2338, MultiBlockPart> blockMap;

    public MultiBlockDefinition(@NotNull class_2960 id, @NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.id = id;
        this.json = json;
        this.origin = class_2338.field_10980;
        this.blockMap = new HashMap();
        this.loadFromJson();
    }

    public final void loadFromJson() {
        JsonObject obj = this.json.getAsJsonObject();
        if (obj.has("origin")) {
            JsonObject origin = obj.get("origin").getAsJsonObject();
            this.origin = new class_2338(origin.get("x").getAsInt(), origin.get("y").getAsInt(), origin.get("z").getAsInt());
        }
        HashMap keyMap = new HashMap();
        JsonObject keysObj = obj.get("keys").getAsJsonObject();
        for (Map.Entry key : keysObj.entrySet()) {
            String keyName = (String)key.getKey();
            if (keyMap.containsKey(keyName)) {
                throw new IllegalArgumentException("Duplicate key name: " + keyName);
            }
            JsonObject keyVal = ((JsonElement)key.getValue()).getAsJsonObject();
            if (keyVal.has("block")) {
                class_2960 resourceLocation = new class_2960(keyVal.get("block").getAsString());
                if (Intrinsics.areEqual((Object)class_2378.field_11146.method_10223(resourceLocation), (Object)class_2246.field_10124)) {
                    ((Map)keyMap).put(keyName, new EmptyPart());
                    continue;
                }
                ((Map)keyMap).put(keyName, new BlockPart(resourceLocation));
                continue;
            }
            throw new IllegalArgumentException("Invalid key definition: " + keyName);
        }
        JsonArray structure = obj.get("pattern").getAsJsonArray();
        Iterator iterator = ((Iterable)structure).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int layer = n++;
            JsonElement layerElement = (JsonElement)iterator.next();
            JsonArray layerArray = layerElement.getAsJsonArray();
            Iterator iterator2 = ((Iterable)layerArray).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int row = n2++;
                JsonElement rowElement = (JsonElement)iterator2.next();
                String rowString = rowElement.getAsString();
                int n3 = ((CharSequence)rowString).length();
                for (int i = 0; i < n3; ++i) {
                    String key = String.valueOf(rowString.charAt(i));
                    class_2338 pos = new class_2338(i, layer, row).method_10059((class_2382)this.origin);
                    if (this.blockMap.containsKey(pos)) {
                        throw new IllegalArgumentException("Duplicate block position: " + pos);
                    }
                    if (Intrinsics.areEqual((Object)key, (Object)" ")) continue;
                    if (!keyMap.containsKey(key)) {
                        throw new IllegalArgumentException("Undefined key in multiblock definition: " + this.id + ", Key: " + key);
                    }
                    Map map = this.blockMap;
                    Object v = keyMap.get(key);
                    Intrinsics.checkNotNull(v);
                    map.put(pos, v);
                }
            }
        }
    }

    @NotNull
    public final class_2960 getId() {
        return this.id;
    }

    @NotNull
    public final JsonElement getJson() {
        return this.json;
    }

    @NotNull
    public final ImmutableMap<class_2338, MultiBlockPart> getBlocks() {
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)this.blockMap);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
        return immutableMap;
    }

    @NotNull
    public final ImmutableMap<class_2338, MultiBlockPart> getBlockAt(@NotNull class_2338 worldOrigin) {
        Intrinsics.checkNotNullParameter((Object)worldOrigin, (String)"worldOrigin");
        HashMap translated = new HashMap();
        Map $this$forEach$iv = this.blockMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            class_2338 pos = (class_2338)entry.getKey();
            MultiBlockPart part = (MultiBlockPart)entry.getValue();
            ((Map)translated).put(worldOrigin.method_10081((class_2382)pos), part);
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)translated);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
        return immutableMap;
    }

    @NotNull
    public final ImmutableMap<class_2338, MultiBlockPart> getBlocks(@NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        HashMap transformed = new HashMap();
        Transformation transform = (Transformation)rotation.at(Vector3.CENTER).inverse();
        Map $this$forEach$iv = this.blockMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            class_2338 pos = (class_2338)entry.getKey();
            MultiBlockPart part = (MultiBlockPart)entry.getValue();
            Vector3 vec = Vector3.fromBlockPosCenter((class_2338)pos);
            vec.apply(transform);
            ((Map)transformed).put(vec.pos(), part);
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)transformed);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
        return immutableMap;
    }

    @NotNull
    public final ImmutableMap<class_2338, MultiBlockPart> getBlockAt(@NotNull class_2338 worldOrigin, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)worldOrigin, (String)"worldOrigin");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        HashMap transformed = new HashMap();
        Transformation transform = (Transformation)rotation.at(Vector3.CENTER).inverse();
        Map $this$forEach$iv = this.blockMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            class_2338 pos = (class_2338)entry.getKey();
            MultiBlockPart part = (MultiBlockPart)entry.getValue();
            Vector3 vec = Vector3.fromBlockPosCenter((class_2338)pos);
            vec.apply(transform);
            ((Map)transformed).put(vec.add(worldOrigin).pos(), part);
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)transformed);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
        return immutableMap;
    }

    @NotNull
    public final ArrayList<InvalidPart> test(@NotNull class_1937 level, @NotNull class_2338 originPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)originPos, (String)"originPos");
        ArrayList<InvalidPart> result = new ArrayList<InvalidPart>();
        Map $this$forEach$iv = (Map)this.getBlockAt(originPos);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            class_2338 pos = (class_2338)entry.getKey();
            MultiBlockPart part = (MultiBlockPart)entry.getValue();
            Intrinsics.checkNotNull((Object)pos);
            if (part.isMatch(level, pos)) continue;
            Intrinsics.checkNotNull((Object)part);
            result.add(new InvalidPart(pos, part));
        }
        return result;
    }

    @NotNull
    public final ArrayList<InvalidPart> test(@NotNull class_1937 level, @NotNull class_2338 originPos, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)originPos, (String)"originPos");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        ArrayList<InvalidPart> result = new ArrayList<InvalidPart>();
        Map $this$forEach$iv = (Map)this.getBlockAt(originPos, rotation);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            class_2338 pos = (class_2338)entry.getKey();
            MultiBlockPart part = (MultiBlockPart)entry.getValue();
            Intrinsics.checkNotNull((Object)pos);
            if (part.isMatch(level, pos)) continue;
            Intrinsics.checkNotNull((Object)part);
            result.add(new InvalidPart(pos, part));
        }
        return result;
    }
}

