/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.util.beer;

import java.util.Arrays;
import java.util.Optional;
import lekavar.lma.drinkbeer.DrinkBeer;
import lekavar.lma.drinkbeer.util.beer.BeerRecipe;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;

public enum Beers {
    BEER_MUG(1, DrinkBeer.BEER_MUG.method_8389(), true, new BeerRecipe().setBeerResultNum(4).setBrewingTime(24000).addMaterial(3, class_1802.field_8861).addMaterial(class_1802.field_8705)),
    BEER_MUG_BLAZE_STOUT(2, DrinkBeer.BEER_MUG_BLAZE_STOUT.method_8389(), true, new BeerRecipe().setBeerResultNum(4).setBrewingTime(12000).addMaterial(2, class_1802.field_8861).addMaterial(class_1802.field_8705).addMaterial(class_1802.field_8183)),
    BEER_MUG_BLAZE_MILK_STOUT(3, DrinkBeer.BEER_MUG_BLAZE_MILK_STOUT.method_8389(), true, new BeerRecipe().setBeerResultNum(4).setBrewingTime(18000).addMaterial(class_1802.field_8861).addMaterial(class_1802.field_8183).addMaterial(class_1802.field_8479).addMaterial(class_1802.field_8705)),
    BEER_MUG_APPLE_LAMBIC(4, DrinkBeer.BEER_MUG_APPLE_LAMBIC.method_8389(), true, new BeerRecipe().setBeerResultNum(4).setBrewingTime(24000).addMaterial(2, class_1802.field_8861).addMaterial(class_1802.field_8279).addMaterial(class_1802.field_8705)),
    BEER_MUG_SWEET_BERRY_KRIEK(5, DrinkBeer.BEER_MUG_SWEET_BERRY_KRIEK.method_8389(), true, new BeerRecipe().setBeerResultNum(4).setBrewingTime(24000).addMaterial(2, class_1802.field_8861).addMaterial(class_1802.field_16998).addMaterial(class_1802.field_8705)),
    BEER_MUG_HAARS_ICEY_PALE_LAGER(6, DrinkBeer.BEER_MUG_HAARS_ICEY_PALE_LAGER.method_8389(), true, new BeerRecipe().setBeerResultNum(4).setBrewingTime(24000).addMaterial(3, class_1802.field_8861).addMaterial(class_1802.field_8426, class_1802.field_8178, class_1802.field_8081)),
    BEER_MUG_PUMPKIN_KVASS(7, DrinkBeer.BEER_MUG_PUMPKIN_KVASS.method_8389(), false, new BeerRecipe().setBeerResultNum(4).setBrewingTime(12000).addMaterial(2, class_1802.field_8229).addMaterial(class_1802.field_17518).addMaterial(class_1802.field_8705)),
    BEER_MUG_FROTHY_PINK_EGGNOG(8, DrinkBeer.BEER_MUG_FROTHY_PINK_EGGNOG.method_8389(), true, new BeerRecipe().setBeerResultNum(4).setBrewingTime(12000).addMaterial(class_1802.field_8861).addMaterial(class_1802.field_8186).addMaterial(class_1802.field_8803).addMaterial(class_1802.field_8103)),
    BEER_MUG_NIGHT_HOWL_KVASS(9, DrinkBeer.BEER_MUG_NIGHT_HOWL_KVASS.method_8389(), true, new BeerRecipe().setBeerResultNum(4).setBrewingTime(18000).addMaterial(2, class_1802.field_8229).addMaterial(class_1802.field_8606).addMaterial(class_1802.field_8705));

    public static final int SIZE = 9;
    public static final int DEFAULT_BEER_ID = 1;
    public static final Beers DEFAULT_BEER;
    public static final int EMPTY_BEER_ID = 0;
    private final int id;
    private final class_1792 beerItem;
    private final BeerRecipe beerRecipe;
    private final boolean hasStatusEffectTooltip;

    private Beers(int id, class_1792 beerItem, boolean hasStatusEffectTooltip, BeerRecipe beerRecipe) {
        this.id = id;
        this.beerItem = beerItem;
        this.hasStatusEffectTooltip = hasStatusEffectTooltip;
        this.beerRecipe = beerRecipe;
        this.beerRecipe.setBeerResult(this.beerItem);
    }

    public int getId() {
        return this.id;
    }

    public class_1792 getBeerItem() {
        return this.beerItem;
    }

    public boolean getHasStatusEffectTooltip() {
        return this.hasStatusEffectTooltip;
    }

    public BeerRecipe getBeerRecipe() {
        return this.beerRecipe;
    }

    public static Beers byId(int id) {
        Beers[] beers;
        for (Beers beer : beers = Beers.values()) {
            if (beer.id != id) continue;
            return beer;
        }
        return DEFAULT_BEER;
    }

    public static Beers byItem(class_1792 beerItem) {
        Beers[] beers;
        for (Beers beer : beers = Beers.values()) {
            if (!beer.beerItem.equals(beerItem)) continue;
            return beer;
        }
        return DEFAULT_BEER;
    }

    public static int size() {
        return Beers.values().length;
    }

    public static Beers byRecipeBoardBlock(class_2248 recipeBoardBlcok) {
        String beerName = recipeBoardBlcok.method_9539().replace("block.drinkbeer.recipe_board_", "");
        Optional<Beers> matchedBeer = Arrays.stream(Beers.values()).filter(beer -> beer.beerItem.method_7876().equals("block.drinkbeer." + beerName)).findFirst();
        return matchedBeer.isPresent() ? matchedBeer.get() : null;
    }

    static {
        DEFAULT_BEER = BEER_MUG;
    }
}

