/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import lekavar.lma.drinkbeer.DrinkBeer;
import lekavar.lma.drinkbeer.manager.TradeboxManager;
import lekavar.lma.drinkbeer.util.tradebox.Good;
import lekavar.lma.drinkbeer.util.tradebox.Locations;
import lekavar.lma.drinkbeer.util.tradebox.Residents;
import lekavar.lma.drinkbeer.util.tradebox.TradeMission;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;

public class TradeBoxScreenHandler
extends class_1703 {
    private final class_1263 tradeboxInventory;
    private final List<class_1735> tradeboxSlots;
    private final List<class_1735> goodSlots;
    class_3913 propertyDelegate;
    private final class_3914 context;
    private Runnable inventoryChangeListener;
    public class_1657 player;
    class_2338 pos;

    public TradeBoxScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public TradeBoxScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        this(syncId, playerInventory, (class_1263)new class_1277(8), null, class_3914.field_17304, (class_3913)new class_3919(4));
    }

    public TradeBoxScreenHandler(int syncId, class_1661 playerInventory, class_1263 goodInventory, class_2338 pos, class_3914 context, class_3913 propertyDelegate) {
        super(DrinkBeer.TRADE_BOX_SCREEN_HANDLER, syncId);
        this.propertyDelegate = propertyDelegate;
        this.method_17360(propertyDelegate);
        this.inventoryChangeListener = () -> {};
        this.context = context;
        this.player = playerInventory.field_7546;
        this.pos = pos;
        this.tradeboxSlots = new ArrayList<class_1735>();
        this.goodSlots = new ArrayList<class_1735>();
        this.tradeboxInventory = new class_1277(4){

            public void method_5431() {
                super.method_5431();
                TradeBoxScreenHandler.this.method_7609((class_1263)this);
                TradeBoxScreenHandler.this.inventoryChangeListener.run();
            }
        };
        TradeBoxScreenHandler.method_17359((class_1263)goodInventory, (int)8);
        AtomicInteger num = new AtomicInteger();
        IntStream.range(0, 2).forEach(i -> IntStream.range(0, 2).forEach(j -> {
            this.tradeboxSlots.add(this.method_7621(new class_1735(this.tradeboxInventory, num.get(), 25 + i * 18, 26 + j * 18){

                public boolean method_7680(class_1799 stack) {
                    return true;
                }
            }));
            num.getAndIncrement();
        }));
        num.set(0);
        IntStream.range(0, 2).forEach(j -> IntStream.range(0, 4).forEach(i -> {
            this.goodSlots.add(this.method_7621(new class_1735(goodInventory, num.get(), 85 + i * 18, 26 + j * 18){

                public boolean method_7680(class_1799 stack) {
                    return false;
                }

                public boolean method_7674(class_1657 playerEntity) {
                    return false;
                }

                public boolean method_7682() {
                    return !TradeBoxScreenHandler.this.isCooling();
                }
            }));
            num.getAndIncrement();
        }));
        IntStream.range(0, 3).forEach(m -> IntStream.range(0, 9).forEach(l -> this.method_7621(new class_1735((class_1263)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18))));
        IntStream.range(0, 9).forEach(m -> this.method_7621(new class_1735((class_1263)playerInventory, m, 8 + m * 18, 142)));
        if (this.isTrading() && !this.hasLegalTradeMission()) {
            this.setTradeboxTrading();
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public int getCoolingTime() {
        return this.propertyDelegate.method_17390(0);
    }

    public int getProcess() {
        return this.propertyDelegate.method_17390(3);
    }

    @Environment(value=EnvType.CLIENT)
    public void setInventoryChangeListener(Runnable inventoryChangeListener) {
        this.inventoryChangeListener = inventoryChangeListener;
    }

    public void method_7609(class_1263 inventory) {
        this.checkTradeMission();
        this.method_7623();
    }

    public void checkTradeMission() {
        Map<class_1792, Integer> neededGoodMap;
        if (!this.isTrading()) {
            return;
        }
        Map<class_1792, Integer> inputGoodMap = this.goodSlotListToGoodMap(this.tradeboxSlots);
        if (!TradeboxManager.test(inputGoodMap, neededGoodMap = this.goodSlotListToGoodMap(this.getToLocationGoodSlots()))) {
            return;
        }
        this.setProcess(0);
        this.consumeInputGood(neededGoodMap);
        this.context.method_17393((world, blockPos) -> this.method_7607(this.player, this.tradeboxInventory));
        int goodNum = 0;
        for (class_1735 slot : this.getFromLocationGoodSlots()) {
            if (!slot.method_7681()) continue;
            this.tradeboxSlots.get(goodNum).method_7673(slot.method_7677());
            ++goodNum;
        }
        this.setTradeboxCooling();
    }

    public void consumeInputGood(Map<class_1792, Integer> targetGoodMap) {
        block0: for (Map.Entry<class_1792, Integer> targetGood : targetGoodMap.entrySet()) {
            int currentNum = 0;
            int requiredNum = targetGood.getValue();
            for (class_1735 slot : this.tradeboxSlots) {
                if (targetGood.getKey().equals(slot.method_7677().method_7909())) {
                    class_1799 itemStack = slot.method_7677();
                    if (itemStack.method_7947() >= targetGood.getValue()) {
                        currentNum = requiredNum;
                        slot.method_7671(requiredNum);
                    } else {
                        currentNum += itemStack.method_7947();
                        slot.method_7671(itemStack.method_7947());
                    }
                }
                if (currentNum != requiredNum) continue;
                continue block0;
            }
        }
    }

    public boolean isCooling() {
        return this.getProcess() == 0;
    }

    public boolean isTrading() {
        return this.getProcess() == 1;
    }

    public void setProcess(int process) {
        this.propertyDelegate.method_17391(3, process);
    }

    public void setCoolingTime(int coolingTime) {
        this.propertyDelegate.method_17391(0, coolingTime);
    }

    public void setLocationId(int locationId) {
        this.propertyDelegate.method_17391(1, locationId);
    }

    public void setResidentId(int residentId) {
        this.propertyDelegate.method_17391(2, residentId);
    }

    public int getLocationId() {
        return this.propertyDelegate.method_17390(1);
    }

    public int getResidentId() {
        return this.propertyDelegate.method_17390(2);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (!player.field_6002.field_9236) {
            player.field_6002.method_8396(null, new class_2338(player.method_19538()), DrinkBeer.TRADEBOX_CLOSE_EVENT, class_3419.field_15245, 0.6f, 1.0f);
        }
        this.context.method_17393((world, blockPos) -> this.method_7607(player, this.tradeboxInventory));
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.tradeboxSlots.size() ? !this.method_7616(originalStack, this.tradeboxSlots.size(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.tradeboxSlots.size(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public void setTradeMission(TradeMission tradeMission) {
        this.setLocationId(tradeMission.getLocationId());
        this.setResidentId(tradeMission.getResidentId());
        if (!tradeMission.getGoodToLocationList().isEmpty()) {
            IntStream.range(0, tradeMission.getGoodToLocationList().size()).forEach(i -> {
                Good good = tradeMission.getGoodToLocationList().get(i);
                class_1799 goodItemStack = new class_1799((class_1935)good.getGoodItem(), good.getCount());
                this.goodSlots.get(i).method_7673(goodItemStack);
            });
        }
        if (!tradeMission.getGoodFromLocationList().isEmpty()) {
            IntStream.range(0, tradeMission.getGoodFromLocationList().size()).forEach(i -> {
                Good good = tradeMission.getGoodFromLocationList().get(i);
                class_1799 goodItemStack = new class_1799((class_1935)good.getGoodItem(), good.getCount());
                this.goodSlots.get(4 + i).method_7673(goodItemStack);
            });
        }
    }

    public void setTradeboxCooling() {
        this.setProcess(0);
        this.setCoolingTime(4800);
        this.setLocationId(Locations.EMPTY_LOCATION.getId());
        this.setResidentId(Residents.EMPTY_RESIDENT.getId());
        this.clearGoodInventory();
    }

    public void setTradeboxTrading() {
        TradeMission tradeMission = new TradeMission();
        try {
            class_2248 block = this.player.field_6002.method_8320(this.pos).method_26204();
            if (block.method_8389().equals(DrinkBeer.TRADE_BOX_NORMAL.method_8389())) {
                tradeMission = TradeMission.genRandomTradeMission();
            }
        }
        catch (Exception e) {
            tradeMission = TradeMission.genRandomTradeMission();
        }
        this.setTradeMission(tradeMission);
        this.setProcess(1);
    }

    public List<class_1735> getToLocationGoodSlots() {
        return this.goodSlots.subList(0, 4);
    }

    public List<class_1735> getFromLocationGoodSlots() {
        return this.goodSlots.subList(4, 8);
    }

    public boolean hasLegalTradeMission() {
        if (Math.max(this.getLocationId(), Locations.EMPTY_LOCATION.getId()) != Math.min(this.getLocationId(), Locations.size())) {
            return false;
        }
        if (Math.max(this.getResidentId(), Residents.EMPTY_RESIDENT.getId()) != Math.min(this.getResidentId(), Residents.size())) {
            return false;
        }
        if (this.getToLocationGoodSlots().stream().noneMatch(class_1735::method_7681)) {
            return false;
        }
        return this.getFromLocationGoodSlots().stream().anyMatch(class_1735::method_7681);
    }

    private void clearGoodInventory() {
        this.goodSlots.forEach(slot -> slot.method_7673(class_1799.field_8037));
    }

    private Map<class_1792, Integer> goodSlotListToGoodMap(List<class_1735> goodSlots) {
        HashMap<class_1792, Integer> goodMap = new HashMap<class_1792, Integer>();
        IntStream.range(0, 4).forEach(i -> {
            if (!((class_1735)goodSlots.get(i)).method_7681()) {
                return;
            }
            class_1799 inputTradeboxSlotsItemStack = ((class_1735)goodSlots.get(i)).method_7677();
            class_1792 inputTradeboxSlotsItem = inputTradeboxSlotsItemStack.method_7909();
            if (goodMap.containsKey(inputTradeboxSlotsItem)) {
                goodMap.replace(inputTradeboxSlotsItem, (Integer)goodMap.get(inputTradeboxSlotsItem) + inputTradeboxSlotsItemStack.method_7947());
            } else {
                goodMap.put(inputTradeboxSlotsItem, inputTradeboxSlotsItemStack.method_7947());
            }
        });
        return goodMap;
    }
}

