/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.manager;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lekavar.lma.drinkbeer.DrinkBeer;
import lekavar.lma.drinkbeer.entity.damage.AlcoholDamage;
import lekavar.lma.drinkbeer.item.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.manager.SpiceAndFlavorManager;
import lekavar.lma.drinkbeer.statuseffects.DrunkStatusEffect;
import lekavar.lma.drinkbeer.statuseffects.NightHowlStatusEffect;
import lekavar.lma.drinkbeer.util.beer.Beers;
import lekavar.lma.drinkbeer.util.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.util.mixedbeer.MixedBeerOnUsing;
import lekavar.lma.drinkbeer.util.mixedbeer.Spices;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class MixedBeerManager {
    public static final int MAX_SPICES_COUNT = 3;

    public static class_1799 genMixedBeerItemStack(int beerId, int ... spiceIds) {
        ArrayList<Integer> spiceList = new ArrayList<Integer>();
        for (int spiceId : spiceIds) {
            spiceList.add(spiceId);
        }
        return MixedBeerManager.genMixedBeerItemStack(beerId, spiceList);
    }

    public static class_1799 genMixedBeerItemStack(int beerId, List<Integer> spiceList) {
        class_1799 resultStack = new class_1799((class_1935)DrinkBeer.MIXED_BEER.method_8389(), 1);
        spiceList = MixedBeerManager.removeIllegalSpiceId(spiceList);
        class_2487 compoundTag = resultStack.method_7911("BlockEntityTag");
        class_2487 tag = new class_2487();
        compoundTag.method_10566("MixedBeer", (class_2520)tag);
        tag.method_10569("BeerId", beerId);
        class_2499 listTag = MixedBeerManager.genSpiceListTag(spiceList);
        if (listTag != null) {
            tag.method_10566("Spices", (class_2520)listTag);
        }
        resultStack.method_7953(tag);
        return resultStack;
    }

    public static class_2499 genSpiceListTag(List<Integer> spiceList) {
        class_2499 listTag = null;
        if (!spiceList.isEmpty()) {
            listTag = new class_2499();
            for (int i = 0; i < 3 && i < spiceList.size(); ++i) {
                class_2487 tag2 = new class_2487();
                tag2.method_10569("SpiceId", spiceList.get(i).intValue());
                listTag.add((Object)tag2);
            }
        }
        return listTag;
    }

    private static List<Integer> removeIllegalSpiceId(List<Integer> spiceList) {
        return spiceList.stream().filter(value -> value.compareTo(0) > 0 && value.compareTo(Spices.size()) <= 0).collect(Collectors.toList());
    }

    public static int getBeerId(class_1799 itemStack) {
        class_2487 compoundTag;
        int beerId = 0;
        if (itemStack.method_7909() instanceof MixedBeerBlockItem && (compoundTag = itemStack.method_7941("BlockEntityTag")) != null && compoundTag.method_10545("MixedBeer")) {
            class_2487 tag = compoundTag.method_10562("MixedBeer");
            beerId = tag.method_10550("BeerId");
        }
        return beerId;
    }

    public static List<Integer> getSpiceList(class_1799 itemStack) {
        ArrayList<Integer> spiceList = new ArrayList<Integer>();
        class_2487 compoundTag = itemStack.method_7941("BlockEntityTag");
        if (compoundTag != null && compoundTag.method_10545("MixedBeer")) {
            class_2487 tag = compoundTag.method_10562("MixedBeer");
            class_2499 listTag = tag.method_10554("Spices", 10);
            for (int i = 0; i < listTag.size() && i < 3; ++i) {
                class_2487 tag2 = listTag.method_10602(i);
                int spiceId = tag2.method_10550("SpiceId");
                spiceList.add(spiceId);
            }
        }
        return spiceList;
    }

    public static String getMixedBeerTranslationKey() {
        return DrinkBeer.MIXED_BEER.method_8389().method_7876();
    }

    public static String getBaseBeerToolTipTranslationKey() {
        return "item.drinkbeer.mixed_beer.tooltip_base";
    }

    public static String getUnmixedToolTipTranslationKey() {
        return "item.drinkbeer.mixed_beer.tooltip_unmixed";
    }

    public static void useMixedBeer(class_1799 stack, class_1937 world, class_1309 user) {
        MixedBeerOnUsing mixedBeerOnUsing = new MixedBeerOnUsing();
        mixedBeerOnUsing.setBeer(Beers.byId(MixedBeerManager.getBeerId(stack)));
        mixedBeerOnUsing.addHunger(Objects.requireNonNull(mixedBeerOnUsing.getBeerItem().method_19264()).method_19230());
        List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
        mixedBeerOnUsing.setSpiceList(spiceList);
        Flavors combinedFlavor = SpiceAndFlavorManager.getCombinedFlavor(spiceList);
        if (combinedFlavor != null) {
            mixedBeerOnUsing.addFlavor(combinedFlavor);
        }
        mixedBeerOnUsing.addStatusEffect(MixedBeerManager.getBeerStatusEffectList(mixedBeerOnUsing.getBeerItem(), world));
        SpiceAndFlavorManager.applyFlavorValue(mixedBeerOnUsing);
        DrunkStatusEffect.addStatusEffect(user, mixedBeerOnUsing.getDrunkValue());
        if (mixedBeerOnUsing.getBeer().equals((Object)Beers.BEER_MUG_NIGHT_HOWL_KVASS)) {
            NightHowlStatusEffect.playRandomHowlSound(world, user);
        }
        if (user instanceof class_1657 && !((class_1657)user).method_7337()) {
            ((class_1657)user).method_7344().method_7585(mixedBeerOnUsing.getHunger(), 0.0f);
        }
        if (user instanceof class_1657) {
            if (!((class_1657)user).method_7337()) {
                if (mixedBeerOnUsing.getHealth() < 0.0f) {
                    user.method_5643((class_1282)new AlcoholDamage(), Math.abs(mixedBeerOnUsing.getHealth()));
                } else {
                    user.method_6025(mixedBeerOnUsing.getHealth());
                }
            }
        } else {
            user.method_6033(user.method_6032() + mixedBeerOnUsing.getHealth());
        }
        for (org.apache.commons.lang3.tuple.Pair<class_1291, Integer> statusEffectPair : mixedBeerOnUsing.getStatusEffectList()) {
            user.method_6092(new class_1293((class_1291)statusEffectPair.getKey(), ((Integer)statusEffectPair.getValue()).intValue()));
        }
        SpiceAndFlavorManager.applyFlavorAction(mixedBeerOnUsing, world, user);
    }

    private static List<org.apache.commons.lang3.tuple.Pair<class_1291, Integer>> getBeerStatusEffectList(class_1792 beerItem, class_1937 world) {
        ArrayList<org.apache.commons.lang3.tuple.Pair<class_1291, Integer>> resultStatusEffectList = new ArrayList<org.apache.commons.lang3.tuple.Pair<class_1291, Integer>>();
        List statusEffectList = Objects.requireNonNull(beerItem.method_19264()).method_19235();
        if (statusEffectList != null && !statusEffectList.isEmpty()) {
            for (Pair statusEffect : statusEffectList) {
                resultStatusEffectList.add((org.apache.commons.lang3.tuple.Pair<class_1291, Integer>)org.apache.commons.lang3.tuple.Pair.of((Object)((class_1293)statusEffect.getFirst()).method_5579(), (Object)((class_1293)statusEffect.getFirst()).method_5584()));
            }
        }
        if (beerItem.equals(Beers.BEER_MUG_NIGHT_HOWL_KVASS.getBeerItem())) {
            org.apache.commons.lang3.tuple.Pair<class_1291, Integer> nightHowlStatusEffectPair = NightHowlStatusEffect.getStatusEffectPair(world);
            resultStatusEffectList.add(nightHowlStatusEffectPair);
        }
        return resultStatusEffectList;
    }

    public static int getActionedTimes(int index, Flavors targetAction, List<Flavors> actionList) {
        if (index == 0) {
            return 0;
        }
        int actionTime = 0;
        for (int i = 0; i < index; ++i) {
            if (!actionList.get(i).equals((Object)targetAction)) continue;
            ++actionTime;
        }
        return actionTime;
    }

    public static boolean hasActionedBefore(int index, Flavors targetAction, List<Flavors> actionList) {
        return MixedBeerManager.getActionedTimes(index, targetAction, actionList) != 0;
    }

    public static boolean hasActionAfter(int index, Flavors targetAction, List<Flavors> actionList) {
        if (actionList.size() - 1 == index) {
            return false;
        }
        for (int i = index + 1; i < actionList.size(); ++i) {
            if (!actionList.get(i).equals((Object)targetAction)) continue;
            return true;
        }
        return false;
    }
}

