/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.dorianpb.cem.internal.api.CemModel;
import net.dorianpb.cem.internal.config.CemConfigFairy;
import net.dorianpb.cem.internal.file.JemFile;
import net.dorianpb.cem.internal.models.CemModelEntry;
import net.dorianpb.cem.internal.util.CemFairy;
import net.dorianpb.cem.internal.util.CemStringParser;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public class CemModelRegistry {
    private final HashMap<ArrayList<String>, CemModelEntry> database = new HashMap();
    private final ArrayList<CemAnimation> animations = new ArrayList();
    private final HashMap<String, CemModelEntry> partNameRefs = new HashMap();
    private final JemFile file;

    public CemModelRegistry(JemFile file) {
        JemFile.JemModel data;
        this.file = file;
        for (String part : this.file.getModelList()) {
            data = this.file.getModel(part);
            this.addEntry(new CemModelEntry(data, file.getTextureSize().get(0).intValue(), file.getTextureSize().get(1).intValue()), new ArrayList<String>());
        }
        for (String part : this.file.getModelList()) {
            data = this.file.getModel(part);
            for (String key : data.getAnimations().keySet()) {
                try {
                    this.animations.add(new CemAnimation(this.findChild(key.substring(0, key.indexOf(".")), this.findChild(part)), (String)data.getAnimations().get((Object)key), key.substring(key.indexOf(".") + 1), this));
                }
                catch (Exception e) {
                    CemFairy.getLogger().error("Error applying animation \"" + (String)data.getAnimations().get((Object)key) + "\" in \"" + file.getPath() + "\":");
                    CemFairy.getLogger().error(e.getMessage());
                }
            }
        }
    }

    public CemModelEntry.CemModelPart prepRootPart(CemRootPartParams params) {
        for (String parent : params.familyTree().keySet()) {
            for (String child : params.familyTree().get(parent)) {
                this.prepChild(parent, child);
            }
        }
        CemModelEntry.CemModelPart newRoot = new CemModelEntry.CemModelPart();
        LinkedHashSet<String> partList = new LinkedHashSet<String>();
        for (int i = params.familyTree().keySet().size() - 1; i >= 0; --i) {
            partList.add((String)params.familyTree().keySet().toArray()[i]);
        }
        partList.addAll(this.partNameRefs.keySet());
        for (String partName : partList) {
            CemModelEntry entry = this.getEntryByPartName(partName);
            if (entry == null) continue;
            this.getParent(params.partNameMap(), params.familyTree(), newRoot, partName).addChild(params.partNameMap().getOrDefault(partName, partName), entry.getModel());
        }
        if (params.inflate() != null) {
            newRoot.inflate(params.inflate().floatValue());
        }
        if (CemConfigFairy.getConfig().useTransparentParts()) {
            HashMap<String, class_5603> newFixes = new HashMap<String, class_5603>();
            if (params.fixes() != null) {
                params.fixes().forEach((key, modelTransform) -> newFixes.put(params.partNameMap().getOrDefault(key, (String)key), (class_5603)modelTransform));
            }
            this.makePartTransparent(newRoot, params.vanillaReferenceModelFactory().get(), newFixes);
        }
        return newRoot;
    }

    private CemModelEntry.CemModelPart getParent(Map<String, String> partNameMap, Map<String, List<String>> familyTree, class_630 root, String name) {
        ArrayList<String> names = new ArrayList<String>();
        while ((name = this.findParent(familyTree, name)) != null) {
            names.add(name);
        }
        if (names.size() == 0) {
            return (CemModelEntry.CemModelPart)root;
        }
        class_630 part = root;
        for (int i = names.size() - 1; i >= 0; --i) {
            part = part.method_32086(partNameMap.getOrDefault(names.get(i), (String)names.get(i)));
        }
        return (CemModelEntry.CemModelPart)part;
    }

    private String findParent(Map<String, List<String>> familyTree, String name) {
        for (String key : familyTree.keySet()) {
            if (!familyTree.get(key).contains(name)) continue;
            return key;
        }
        return null;
    }

    private void makePartTransparent(CemModelEntry.CemModelPart target, class_630 vanillaModel, @Nullable Map<String, class_5603> fixes) {
        HashSet iterator = new HashSet();
        iterator.addAll(target.field_3661.keySet());
        iterator.addAll(vanillaModel.field_3661.keySet());
        for (String key : iterator) {
            try {
                CemModelEntry.TransparentCemModelPart replacement;
                if (!target.field_3661.containsKey(key) || !vanillaModel.field_3661.containsKey(key)) continue;
                if (fixes != null && fixes.containsKey(key)) {
                    class_5603 correctTransform = class_5603.method_32091((float)fixes.get((Object)key).field_27702, (float)fixes.get((Object)key).field_27703, (float)fixes.get((Object)key).field_27704, (float)vanillaModel.method_32086((String)key).method_32084().field_27705, (float)vanillaModel.method_32086((String)key).method_32084().field_27706, (float)vanillaModel.method_32086((String)key).method_32084().field_27707);
                    replacement = new CemModelEntry.TransparentCemModelPart(target.method_32086(key), correctTransform, vanillaModel.method_32086(key).method_32084());
                } else {
                    replacement = new CemModelEntry.TransparentCemModelPart(target.method_32086(key), vanillaModel.method_32086(key).method_32084(), vanillaModel.method_32086(key).method_32084());
                }
                this.makePartTransparent((CemModelEntry.CemModelPart)target.method_32086(key), vanillaModel.method_32086(key), fixes);
                target.addChild(key, replacement);
            }
            catch (Exception exception) {
                CemFairy.getLogger().warn((Object)exception);
            }
        }
    }

    private void prepChild(String parentPart, String childPart) {
        CemModelEntry parent = this.getEntryByPartName(parentPart);
        CemModelEntry child = this.getEntryByPartName(childPart);
        if (parent == null || child == null) {
            return;
        }
        CemModelEntry.CemModelPart parentPart1 = parent.getModel();
        CemModelEntry.CemModelPart childPart1 = child.getModel();
        childPart1.field_3657 -= parentPart1.field_3657;
        childPart1.field_3656 -= parentPart1.field_3656;
        childPart1.field_3655 -= parentPart1.field_3655;
    }

    public CemModelEntry getEntryByPartName(String key) {
        if (this.partNameRefs.containsKey(key)) {
            return this.partNameRefs.get(key);
        }
        CemFairy.getLogger().warn("Model part " + key + " isn't specified in " + this.file.getPath());
        return null;
    }

    private void addEntry(CemModelEntry entry, ArrayList<String> parentRefmap) {
        ArrayList refmap;
        if (parentRefmap != null && parentRefmap.size() > 0) {
            ArrayList temp;
            refmap = temp = (ArrayList)parentRefmap.clone();
        } else {
            refmap = new ArrayList();
            if (entry.getPart() != null) {
                this.partNameRefs.put(entry.getPart(), entry);
            }
        }
        refmap.add(entry.getId() == null ? entry.getPart() : entry.getId());
        this.database.put(refmap, entry);
        for (CemModelEntry child : entry.getChildren().values()) {
            this.addEntry(child, refmap);
        }
    }

    public boolean hasTexture() {
        return this.file.getTexture() != null;
    }

    public class_2960 getTexture() {
        if (this.file.getTexture() == null) {
            throw new NullPointerException("Trying to retrieve a null texture");
        }
        return this.file.getTexture();
    }

    public boolean hasShadowRadius() {
        return this.file.getShadowsize() != null;
    }

    public float getShadowRadius() {
        return this.file.getShadowsize().floatValue();
    }

    public void applyAnimations(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity) {
        for (CemAnimation anim : this.animations) {
            anim.apply(limbAngle, limbDistance, age, head_yaw, head_pitch, entity);
        }
    }

    public CemModelEntry findChild(String target, CemModelEntry parent) {
        CemModelEntry victim = null;
        ArrayList<String> hit = null;
        ArrayList<String> refmap = new ArrayList<String>(Arrays.asList(target.split(":")));
        if (refmap.size() == 1 && this.partNameRefs.containsKey(refmap.get(0))) {
            victim = this.partNameRefs.get(refmap.get(0));
            return victim;
        }
        if (parent != null && (refmap.get(0).equals("this") || refmap.get(0).equals("part"))) {
            if (refmap.size() == 1) {
                return parent;
            }
            StringBuilder newTarget = new StringBuilder();
            newTarget.append(parent.getId() == null ? parent.getPart() : parent.getId());
            for (int d = 1; d < refmap.size(); ++d) {
                newTarget.append(":").append(refmap.get(d));
            }
            return this.findChild(newTarget.toString(), parent);
        }
        for (ArrayList<String> part : this.database.keySet()) {
            ArrayList<Integer> hello = new ArrayList<Integer>();
            for (String ref : refmap) {
                hello.add(part.indexOf(ref));
            }
            boolean hi = hello.size() != 1 || (Integer)hello.get(0) > -1;
            for (int i = 0; i < hello.size() - 1; ++i) {
                hi = hi && (Integer)hello.get(i) < (Integer)hello.get(i + 1) && (Integer)hello.get(i) > -1;
            }
            if (hi && (hit == null || part.size() < hit.size())) {
                hit = part;
            }
            victim = this.database.get(hit);
        }
        if (victim == null) {
            throw new NullPointerException("Model part " + target + " isn't specified in " + this.file.getPath());
        }
        return victim;
    }

    private CemModelEntry findChild(String target) {
        return this.findChild(target, null);
    }

    private static class CemAnimation {
        private final CemModelRegistry registry;
        private final CemModelEntry target;
        private final CemStringParser.ParsedExpression expression;
        private final char operation;
        private final char axis;

        CemAnimation(CemModelEntry target, String expr, String var, CemModelRegistry registry) {
            this.target = target;
            this.registry = registry;
            this.expression = CemStringParser.parse(expr, this.registry, this.target);
            this.operation = var.charAt(0);
            this.axis = var.charAt(1);
        }

        void apply(float limbAngle, float limbDistance, float age, float head_yaw, float head_pitch, class_1297 entity) {
            block6: {
                block5: {
                    float val = this.expression.eval(limbAngle, limbDistance, age, head_yaw, head_pitch, entity, this.registry);
                    if (Float.isNaN(val)) break block5;
                    switch (this.operation) {
                        case 't': {
                            this.target.setTranslate(this.axis, val);
                            break block6;
                        }
                        case 'r': {
                            this.target.setRotate(this.axis, val);
                            break block6;
                        }
                        case 's': {
                            this.target.getModel().setScale(this.axis, val);
                            break block6;
                        }
                        default: {
                            throw new IllegalStateException("Unknown operation \"" + this.operation + "\"");
                        }
                    }
                }
                this.target.setTranslate(this.axis, Float.MAX_VALUE);
            }
        }
    }

    public static class CemRootPartParams {
        private final Map<String, String> partNameMap;
        private final Map<String, List<String>> familyTree;
        private final CemModel.VanillaReferenceModelFactory vanillaReferenceModelFactory;
        @Nullable
        private final Map<String, class_5603> fixes;
        @Nullable
        private final Float inflate;

        private CemRootPartParams(Map<String, String> partNameMap, Map<String, List<String>> familyTree, CemModel.VanillaReferenceModelFactory vanillaReferenceModelFactory, @Nullable Map<String, class_5603> fixes, @Nullable Float inflate) {
            this.partNameMap = partNameMap;
            this.familyTree = familyTree;
            this.vanillaReferenceModelFactory = vanillaReferenceModelFactory;
            this.fixes = fixes;
            this.inflate = inflate;
        }

        public Map<String, String> partNameMap() {
            return this.partNameMap;
        }

        public Map<String, List<String>> familyTree() {
            return this.familyTree;
        }

        public CemModel.VanillaReferenceModelFactory vanillaReferenceModelFactory() {
            return this.vanillaReferenceModelFactory;
        }

        public Map<String, class_5603> fixes() {
            return this.fixes;
        }

        public Float inflate() {
            return this.inflate;
        }
    }

    public static class CemPrepRootPartParamsBuilder {
        private Map<String, String> partNameMap = new HashMap<String, String>();
        private Map<String, List<String>> familyTree = new HashMap<String, List<String>>();
        private CemModel.VanillaReferenceModelFactory vanillaReferenceModelFactory;
        @Nullable
        private Map<String, class_5603> fixes = null;
        @Nullable
        private Float inflate = null;

        public CemPrepRootPartParamsBuilder setPartNameMap(Map<String, String> partNameMap) {
            this.partNameMap = partNameMap;
            return this;
        }

        public CemPrepRootPartParamsBuilder setFamilyTree(Map<String, List<String>> familyTree) {
            this.familyTree = familyTree;
            return this;
        }

        public CemPrepRootPartParamsBuilder setVanillaReferenceModelFactory(CemModel.VanillaReferenceModelFactory vanillaReferenceModelFactory) {
            this.vanillaReferenceModelFactory = vanillaReferenceModelFactory;
            return this;
        }

        public CemPrepRootPartParamsBuilder setFixes(@Nullable Map<String, class_5603> fixes) {
            this.fixes = fixes;
            return this;
        }

        public CemPrepRootPartParamsBuilder setInflate(@Nullable Float inflate) {
            this.inflate = inflate;
            return this;
        }

        public CemRootPartParams create() {
            return new CemRootPartParams(this.partNameMap, this.familyTree, this.vanillaReferenceModelFactory, this.fixes, this.inflate);
        }
    }
}

