/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.file;

import com.google.gson.internal.LinkedTreeMap;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import net.dorianpb.cem.internal.file.JpmFile;
import net.dorianpb.cem.internal.util.CemFairy;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class JemFile {
    public static final Pattern allowTextureChars = Pattern.compile("^[a-z0-9/._\\-]+$");
    private final class_2960 texture;
    private final ArrayList<Double> textureSize;
    private final Float shadowsize;
    private final HashMap<String, JemModel> models;
    private final class_2960 path;

    public JemFile(LinkedTreeMap<String, Object> json, class_2960 path, class_3300 resourceManager) throws Exception {
        this.textureSize = CemFairy.JSONparseDoubleList(json.get((Object)"textureSize"));
        this.shadowsize = CemFairy.JSONparseFloat(json.get((Object)"shadowSize"));
        this.path = path;
        String texturepath = CemFairy.JSONparseString(json.get((Object)"texture"));
        if (texturepath == null || texturepath.isEmpty()) {
            class_2960 jankTexture = CemFairy.transformPath(path.method_12832().substring(path.method_12832().lastIndexOf(47) + 1, path.method_12832().lastIndexOf(46)) + ".png", this.path);
            boolean jankExists = false;
            try {
                resourceManager.method_14486(jankTexture).close();
                jankExists = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.texture = jankExists ? jankTexture : null;
        } else {
            this.texture = CemFairy.transformPath(texturepath, this.path);
        }
        this.models = new HashMap();
        for (LinkedTreeMap model : (ArrayList)json.get((Object)"models")) {
            JemModel newmodel = new JemModel(model, this.path, resourceManager);
            this.models.put(newmodel.getPart(), newmodel);
        }
        this.validate();
    }

    private void validate() {
        if (this.models == null) {
            throw new InvalidParameterException("Element \"models\" is required");
        }
        if (this.textureSize == null) {
            throw new InvalidParameterException("Element \"textureSize\" is required");
        }
        if (this.texture != null && !allowTextureChars.matcher(this.texture.method_12832()).find()) {
            throw new InvalidParameterException("Non [a-z0-9/._-] character in path of location: " + this.texture);
        }
    }

    private JemFile(class_2960 texture, ArrayList<Double> textureSize, Float shadowsize, HashMap<String, JemModel> models, class_2960 path) {
        this.texture = texture;
        this.textureSize = textureSize;
        this.shadowsize = shadowsize;
        this.models = models;
        this.path = path;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public ArrayList<Double> getTextureSize() {
        return this.textureSize;
    }

    public Set<String> getModelList() {
        return this.models.keySet();
    }

    public JemModel getModel(String key) {
        return this.models.get(key);
    }

    public String getPath() {
        return this.path.method_12832();
    }

    public Float getShadowsize() {
        return this.shadowsize;
    }

    public JemFile getArmorVarient() {
        return new JemFile(this.texture, new ArrayList<Double>(Arrays.asList(64.0, 32.0)), this.shadowsize, this.models, this.path);
    }

    public static class JemModel {
        private final String baseId;
        private final String model;
        private final String part;
        private final Boolean attach;
        private final Double scale;
        private final LinkedTreeMap<String, String> animations;
        private final JpmFile modelDef;

        JemModel(LinkedTreeMap json, class_2960 path, class_3300 resourceManager) throws Exception {
            JpmFile temp;
            this.baseId = CemFairy.JSONparseString(json.get((Object)"baseId"));
            this.model = CemFairy.JSONparseString(json.get((Object)"model"));
            this.part = CemFairy.JSONparseString(json.get((Object)"part"));
            this.attach = CemFairy.JSONparseBool(json.get((Object)"attach"));
            this.scale = CemFairy.JSONparseDouble(json.getOrDefault((Object)"scale", (Object)1.0));
            ArrayList yeah = (ArrayList)json.getOrDefault((Object)"animations", new ArrayList<LinkedTreeMap>(Collections.singletonList(new LinkedTreeMap())));
            this.animations = new LinkedTreeMap();
            yeah.forEach(value -> value.forEach((key, value1) -> this.animations.put(key, (Object)value1.toString())));
            if (this.model != null) {
                class_2960 id = CemFairy.transformPath(this.model, path);
                try (InputStream stream = resourceManager.method_14486(id).method_14482();){
                    LinkedTreeMap file = (LinkedTreeMap)CemFairy.getGson().fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), LinkedTreeMap.class);
                    if (file == null) {
                        throw new Exception("Invalid File");
                    }
                    temp = new JpmFile(file);
                }
                catch (FileNotFoundException exception) {
                    CemFairy.postReadError(exception, id);
                    CemFairy.getLogger().warn(" Falling back on reading model definition from " + path.toString() + "!");
                    temp = new JpmFile(json);
                }
                catch (Exception exception) {
                    CemFairy.postReadError(exception, id);
                    throw new Exception("Error loading dependent file: " + id);
                }
            } else {
                temp = new JpmFile(json);
            }
            this.modelDef = temp;
            this.validate();
        }

        private void validate() {
            if (this.part == null) {
                throw new InvalidParameterException("Element \"part\" is required");
            }
        }

        public String getPart() {
            return this.part;
        }

        public Double getScale() {
            return this.scale;
        }

        String getModel() {
            return this.model;
        }

        String getId() {
            return this.getModelDef().getId();
        }

        public JpmFile getModelDef() {
            return this.modelDef;
        }

        public LinkedTreeMap<String, String> getAnimations() {
            return this.animations;
        }
    }
}

