/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_4638;
import net.minecraft.class_4643;
import net.minecraft.class_4646;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_5140;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5458;
import net.minecraft.class_6005;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6792;
import net.minecraft.class_6796;
import net.minecraft.class_6799;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import techreborn.blocks.misc.BlockRubberLog;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;
import techreborn.world.OreFeature;
import techreborn.world.RubberTreeSpikeDecorator;

public class WorldGenerator {
    public static class_2975<class_4643, ?> RUBBER_TREE_FEATURE;
    public static class_6796 RUBBER_TREE_PLACED_FEATURE;
    public static class_2975<class_4638, ?> RUBBER_TREE_PATCH_FEATURE;
    public static class_6796 RUBBER_TREE_PATCH_PLACED_FEATURE;
    public static final List<OreFeature> ORE_FEATURES;

    public static void initWorldGen() {
        WorldGenerator.registerTreeDecorators();
        if (!TechRebornConfig.enableOreGeneration && !TechRebornConfig.enableRubberTreeGeneration) {
            return;
        }
        BiomeModifications.create((class_2960)new class_2960("techreborn", "features")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), WorldGenerator.oreModifier()).add(ModificationPhase.ADDITIONS, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9370, class_1959.class_1961.field_9361, class_1959.class_1961.field_9364}), WorldGenerator.rubberTreeModifier());
    }

    private static BiConsumer<BiomeSelectionContext, BiomeModificationContext> oreModifier() {
        return (biomeSelectionContext, biomeModificationContext) -> {
            if (!TechRebornConfig.enableOreGeneration) {
                return;
            }
            for (OreFeature feature : ORE_FEATURES) {
                if (!feature.getBiomeSelector().test((BiomeSelectionContext)biomeSelectionContext)) continue;
                biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_13176, feature.getPlacedFeatureRegistryKey());
            }
        };
    }

    private static List<OreFeature> getOreFeatures() {
        return Arrays.stream(TRContent.Ores.values()).filter(ores -> ores.distribution != null).map(OreFeature::new).toList();
    }

    private static void registerTreeDecorators() {
        class_2960 treeId = new class_2960("techreborn", "rubber_tree");
        class_2960 patchId = new class_2960("techreborn", "rubber_tree_patch");
        RUBBER_TREE_FEATURE = (class_2975)class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)treeId, (Object)new class_2975(class_3031.field_24134, (class_3037)WorldGenerator.rubber().method_23445()));
        RUBBER_TREE_PLACED_FEATURE = (class_6796)class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)treeId, (Object)new class_6796(WorldGenerator.getEntry(class_5458.field_25929, RUBBER_TREE_FEATURE), List.of(class_6817.method_40365((class_2248)TRContent.RUBBER_SAPLING))));
        RUBBER_TREE_PATCH_FEATURE = (class_2975)class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)patchId, (Object)new class_2975(class_3031.field_21220, (class_3037)class_6803.method_39703((int)6, WorldGenerator.getEntry(class_5458.field_35761, RUBBER_TREE_PLACED_FEATURE))));
        RUBBER_TREE_PATCH_PLACED_FEATURE = (class_6796)class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)patchId, (Object)new class_6796(WorldGenerator.getEntry(class_5458.field_25929, RUBBER_TREE_PATCH_FEATURE), List.of(class_6799.method_39659((int)3), class_5450.method_39639(), class_6817.field_36078, class_6792.method_39614())));
    }

    private static BiConsumer<BiomeSelectionContext, BiomeModificationContext> rubberTreeModifier() {
        if (!TechRebornConfig.enableRubberTreeGeneration) {
            return (biomeSelectionContext, biomeModificationContext) -> {};
        }
        class_5321 registryKey = (class_5321)class_5458.field_35761.method_29113((Object)RUBBER_TREE_PATCH_PLACED_FEATURE).orElseThrow();
        return (biomeSelectionContext, biomeModificationContext) -> biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, registryKey);
    }

    private static class_4643.class_4644 rubber() {
        class_6005.class_6006 logDataPool = class_6005.method_34971().method_34975((Object)TRContent.RUBBER_LOG.method_9564(), 6);
        Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166().method_10179()).map(direction -> (class_2680)((class_2680)TRContent.RUBBER_LOG.method_9564().method_11657((class_2769)BlockRubberLog.HAS_SAP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BlockRubberLog.SAP_SIDE, (Comparable)direction)).forEach(state -> logDataPool.method_34975(state, 1));
        return new class_4643.class_4644((class_4651)new class_4657(logDataPool), (class_5141)new class_5140(6, 3, 0), (class_4651)class_4651.method_38433((class_2680)TRContent.RUBBER_LEAVES.method_9564()), (class_4647)new class_4646((class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)0), 3), (class_5201)new class_5204(1, 0, 1)).method_27376(List.of(new RubberTreeSpikeDecorator(4, (class_4651)class_4651.method_38433((class_2680)TRContent.RUBBER_LEAVES.method_9564()))));
    }

    public static <T> class_6880<T> getEntry(class_2378<T> registry, T value) {
        return (class_6880)registry.method_40264((class_5321)registry.method_29113(value).orElseThrow()).orElseThrow();
    }

    static {
        ORE_FEATURES = WorldGenerator.getOreFeatures();
    }
}

