/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5868;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import techreborn.init.TRContent;
import techreborn.world.TargetDimension;

public record OreDepth(class_2960 identifier, int minY, int maxY, TargetDimension dimension) {
    public static final Codec<OreDepth> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)class_2960.field_25139.fieldOf("identifier").forGetter(OreDepth::identifier), (App)Codec.INT.fieldOf("minY").forGetter(OreDepth::minY), (App)Codec.INT.fieldOf("maxY").forGetter(OreDepth::maxY), (App)TargetDimension.CODEC.fieldOf("dimension").forGetter(OreDepth::dimension)).apply((Applicative)instance, OreDepth::new));
    public static Codec<List<OreDepth>> LIST_CODEC = Codec.list(CODEC);

    public static List<OreDepth> create(MinecraftServer server) {
        ArrayList<OreDepth> depths = new ArrayList<OreDepth>();
        for (TRContent.Ores ore : TRContent.Ores.values()) {
            if (ore.isDeepslate() || ore.distribution == null) continue;
            class_2960 blockId = class_2378.field_11146.method_10221((Object)ore.block);
            class_5868 heightContext = OreDepth.getHeightContext(server, ore.distribution.dimension);
            if (heightContext == null) continue;
            int minY = ore.distribution.minOffset.method_33844(heightContext);
            int maxY = ore.distribution.maxY;
            depths.add(new OreDepth(blockId, minY, maxY, ore.distribution.dimension));
            TRContent.Ores deepslate = ore.getDeepslate();
            if (deepslate == null) continue;
            class_2960 deepSlateBlockId = class_2378.field_11146.method_10221((Object)deepslate.block);
            depths.add(new OreDepth(deepSlateBlockId, minY, maxY, ore.distribution.dimension));
        }
        return Collections.unmodifiableList(depths);
    }

    @Nullable
    private static class_5868 getHeightContext(MinecraftServer server, TargetDimension dimension) {
        class_5321 key = switch (dimension) {
            default -> throw new IncompatibleClassChangeError();
            case TargetDimension.OVERWORLD -> class_1937.field_25179;
            case TargetDimension.NETHER -> class_1937.field_25180;
            case TargetDimension.END -> class_1937.field_25181;
        };
        class_3218 world = server.method_3847(key);
        if (world == null) {
            return null;
        }
        return new class_5868(world.method_14178().method_12129(), (class_5539)world);
    }
}

