/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2266;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2421;
import net.minecraft.class_2511;
import net.minecraft.class_2523;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3830;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.blocks.lighting.LampBlock;
import techreborn.blocks.misc.BlockRubberLog;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class GreenhouseControllerBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    private final RebornInventory<GreenhouseControllerBlockEntity> inventory = new RebornInventory(7, "GreenhouseControllerBlockEntity", 64, (MachineBaseBlockEntity)this);
    private class_2338 multiblockCenter;
    private int ticksToNextMultiblockCheck = 0;
    private boolean growthBoost = false;
    private int workingIndex = 0;
    private final int range = 4;

    public GreenhouseControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.GREENHOUSE_CONTROLLER, pos, state);
    }

    private void workCycle() {
        block11: {
            class_2248 block;
            class_2680 blockState;
            class_2338 blockPos;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block10: {
                                if (this.field_11863 == null) {
                                    return;
                                }
                                int size = 9;
                                int offsetX = this.workingIndex % size;
                                int offsetZ = this.workingIndex / size;
                                class_2338 corner = this.multiblockCenter.method_10069(-4, 0, -4);
                                blockPos = corner.method_10069(offsetX, 0, offsetZ);
                                this.workingIndex = (this.workingIndex + 1) % (size * size);
                                blockState = this.field_11863.method_8320(blockPos);
                                block = blockState.method_26204();
                                if (this.growthBoost && (block instanceof class_2256 || block instanceof class_2261 || block instanceof class_2523 || block instanceof class_2266) && this.getStored() > (long)TechRebornConfig.greenhouseControllerEnergyPerBonemeal) {
                                    this.useEnergy(TechRebornConfig.greenhouseControllerEnergyPerBonemeal);
                                    blockState.method_26199((class_3218)this.field_11863, blockPos, this.field_11863.field_9229);
                                }
                                if (!(block instanceof class_2302)) break block10;
                                this.processAgedCrop(blockState, blockPos, ((class_2302)block).method_9824(), ((class_2302)block).method_9827(), 0);
                                break block11;
                            }
                            if (!(block instanceof class_2421)) break block12;
                            this.processAgedCrop(blockState, blockPos, class_2421.field_11306, 3, 0);
                            break block11;
                        }
                        if (!(block instanceof class_3830)) break block13;
                        this.processAgedCrop(blockState, blockPos, class_3830.field_17000, 3, 1);
                        break block11;
                    }
                    if (!(block instanceof class_2282)) break block14;
                    this.processAgedCrop(blockState, blockPos, class_2282.field_10779, 2, 0);
                    break block11;
                }
                if (!(block instanceof class_2511)) break block15;
                if (!this.tryHarvestBlock(blockState, blockPos)) break block11;
                this.field_11863.method_22352(blockPos, false);
                break block11;
            }
            if (block instanceof class_2523 || block instanceof class_2266 || block instanceof class_2211) {
                boolean breakBlocks = false;
                int y = 1;
                while ((blockState = this.field_11863.method_8320(blockPos.method_10086(y))).method_26204() == block) {
                    if (y == 1) {
                        breakBlocks = this.tryHarvestBlock(blockState, blockPos.method_10086(y));
                    } else {
                        this.tryHarvestBlock(blockState, blockPos.method_10086(y));
                    }
                    if (breakBlocks) {
                        this.field_11863.method_22352(blockPos.method_10086(y), false);
                    }
                    ++y;
                }
            } else if (block instanceof BlockRubberLog) {
                for (int y = 0; (blockState = this.field_11863.method_8320(blockPos.method_10086(y))).method_26204() == block && y < 10; ++y) {
                    if (!((Boolean)blockState.method_11654((class_2769)BlockRubberLog.HAS_SAP)).booleanValue() || this.getStored() <= (long)TechRebornConfig.greenhouseControllerEnergyPerHarvest || !this.insertIntoInv(Collections.singletonList(TRContent.Parts.SAP.getStack()))) continue;
                    this.useEnergy(TechRebornConfig.greenhouseControllerEnergyPerHarvest);
                    this.field_11863.method_8501(blockPos.method_10086(y), (class_2680)((class_2680)blockState.method_11657((class_2769)BlockRubberLog.HAS_SAP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BlockRubberLog.SAP_SIDE, (Comparable)class_2350.method_10139((int)0)));
                }
            }
        }
    }

    private void processAgedCrop(class_2680 blockState, class_2338 blockPos, class_2758 ageProperty, int maxAge, int newAge) {
        if (this.field_11863 == null) {
            return;
        }
        if ((Integer)blockState.method_11654((class_2769)ageProperty) < maxAge) {
            return;
        }
        if (this.tryHarvestBlock(blockState, blockPos)) {
            this.field_11863.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)ageProperty, (Comparable)Integer.valueOf(newAge)), 2);
        }
    }

    private boolean tryHarvestBlock(class_2680 blockState, class_2338 blockPos) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.getStored() < (long)TechRebornConfig.greenhouseControllerEnergyPerHarvest) {
            return false;
        }
        if (this.insertIntoInv(class_2248.method_9562((class_2680)blockState, (class_3218)((class_3218)this.field_11863), (class_2338)blockPos, null))) {
            this.useEnergy(TechRebornConfig.greenhouseControllerEnergyPerHarvest);
            return true;
        }
        return false;
    }

    private boolean insertIntoInv(List<class_1799> stacks) {
        boolean result = false;
        block0: for (class_1799 stack : stacks) {
            for (int i = 0; i < 6; ++i) {
                if (this.insertIntoInv(i, stack)) {
                    result = true;
                }
                if (stack.method_7960()) continue block0;
            }
        }
        return result;
    }

    private boolean insertIntoInv(int slot, class_1799 stack) {
        int freeStackSpace;
        class_1799 targetStack = this.inventory.method_5438(slot);
        if (targetStack.method_7960()) {
            this.inventory.method_5447(slot, stack.method_7972());
            stack.method_7934(stack.method_7947());
            return true;
        }
        if (ItemUtils.isItemEqual((class_1799)stack, (class_1799)targetStack, (boolean)true, (boolean)false) && (freeStackSpace = targetStack.method_7914() - targetStack.method_7947()) > 0) {
            int transferAmount = Math.min(freeStackSpace, stack.method_7947());
            targetStack.method_7933(transferAmount);
            stack.method_7934(transferAmount);
            return true;
        }
        return false;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        if (this.multiblockCenter == null) {
            this.multiblockCenter = pos.method_10079(this.getFacing().method_10153(), 5);
        }
        this.charge(6);
        if (this.getStored() < this.getEuPerTick(TechRebornConfig.greenhouseControllerEnergyPerTick)) {
            return;
        }
        if (--this.ticksToNextMultiblockCheck < 0) {
            this.growthBoost = this.isMultiblockValid();
            this.ticksToNextMultiblockCheck = 200;
        }
        if (world.method_8510() % 20L == 0L) {
            double cyclesLimit = this.getSpeedMultiplier() * 4.0 + 1.0;
            while (true) {
                double d = cyclesLimit;
                cyclesLimit = d - 1.0;
                if (!(d > 0.0)) break;
                this.workCycle();
            }
        }
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.greenhouseControllerMaxEnergy;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.greenhouseControllerMaxInput;
    }

    public void writeMultiblock(MultiblockWriter writer) {
        int j;
        int i;
        class_2680 lamp = (class_2680)TRContent.Machine.LAMP_INCANDESCENT.block.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11033);
        class_2680 crop = class_2246.field_10029.method_9564();
        for (i = 0; i < 3; ++i) {
            for (j = -1; j < 2; ++j) {
                writer.add(i * 3 + 2, 3, j * 3, (world, pos) -> LampBlock.isActive(world.method_8320(pos)), lamp);
            }
        }
        for (i = 1; i <= 9; ++i) {
            for (j = -4; j <= 4; ++j) {
                writer.add(i, 0, j, (world, pos) -> true, crop);
            }
        }
    }

    public boolean canBeUpgraded() {
        return true;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return TRContent.Machine.GREENHOUSE_CONTROLLER.getStack();
    }

    public RebornInventory<GreenhouseControllerBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("greenhousecontroller").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).outputSlot(0, 30, 22).outputSlot(1, 48, 22).outputSlot(2, 30, 40).outputSlot(3, 48, 40).outputSlot(4, 30, 58).outputSlot(5, 48, 58).energySlot(6, 8, 72).syncEnergyValue().addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

