/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.generator.basic;

import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class SolidFuelGeneratorBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public RebornInventory<SolidFuelGeneratorBlockEntity> inventory = new RebornInventory(2, "SolidFuelGeneratorBlockEntity", 64, (MachineBaseBlockEntity)this);
    public int fuelSlot = 0;
    public int burnTime;
    public int totalBurnTime = 0;
    public boolean isBurning;
    public boolean lastTickBurning;
    class_1799 burnItem;

    public SolidFuelGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.SOLID_FUEL_GENERATOR, pos, state);
    }

    public static int getItemBurnTime(@NotNull class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        Map burnMap = class_2609.method_11196();
        if (burnMap.containsKey(stack.method_7909())) {
            return (Integer)burnMap.get(stack.method_7909()) / 4;
        }
        return 0;
    }

    private void updateState() {
        assert (this.field_11863 != null);
        class_2680 BlockStateContainer = this.field_11863.method_8320(this.field_11867);
        class_2248 class_22482 = BlockStateContainer.method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            boolean active;
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            boolean bl = active = this.burnTime > 0 && (float)this.getFreeSpace() > 0.0f;
            if ((Boolean)BlockStateContainer.method_11654((class_2769)BlockMachineBase.ACTIVE) != active) {
                blockMachineBase.setActive(Boolean.valueOf(active), this.field_11863, this.field_11867);
            }
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        this.discharge(1);
        if (this.getFreeSpace() >= (long)TechRebornConfig.solidFuelGeneratorOutputAmount) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.addEnergy(TechRebornConfig.solidFuelGeneratorOutputAmount);
                this.isBurning = true;
            }
        } else {
            this.isBurning = false;
            this.updateState();
        }
        if (this.burnTime == 0) {
            this.updateState();
            this.burnTime = this.totalBurnTime = SolidFuelGeneratorBlockEntity.getItemBurnTime(this.inventory.method_5438(this.fuelSlot));
            if (this.burnTime > 0) {
                this.updateState();
                this.burnItem = this.inventory.method_5438(this.fuelSlot);
                if (this.inventory.method_5438(this.fuelSlot).method_7947() == 1) {
                    if (this.inventory.method_5438(this.fuelSlot).method_7909() == class_1802.field_8187 || this.inventory.method_5438(this.fuelSlot).method_7909() instanceof class_1755) {
                        this.inventory.method_5447(this.fuelSlot, new class_1799((class_1935)class_1802.field_8550));
                    } else {
                        this.inventory.method_5447(this.fuelSlot, class_1799.field_8037);
                    }
                } else {
                    this.inventory.shrinkSlot(this.fuelSlot, 1);
                }
            }
        }
        this.lastTickBurning = this.isBurning;
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.solidFuelGeneratorMaxEnergy;
    }

    public boolean canAcceptEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return TechRebornConfig.solidFuelGeneratorMaxOutput;
    }

    public long getBaseMaxInput() {
        return 0L;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.burnTime = tag.method_10550("BurnTime");
        this.totalBurnTime = tag.method_10550("TotalBurnTime");
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("BurnTime", this.burnTime);
        tag.method_10569("TotalBurnTime", this.totalBurnTime);
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return TRContent.Machine.SOLID_FUEL_GENERATOR.getStack();
    }

    public RebornInventory<SolidFuelGeneratorBlockEntity> getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getTotalBurnTime() {
        return this.totalBurnTime;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.totalBurnTime = totalBurnTime;
    }

    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("generator").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).fuelSlot(0, 80, 54).energySlot(1, 8, 72).syncEnergyValue().sync(this::getBurnTime, this::setBurnTime).sync(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

