/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.cable;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import team.reborn.energy.api.EnergyStorage;
import techreborn.blockentity.cable.CableBlockEntity;
import techreborn.blockentity.cable.OfferedEnergyStorage;
import techreborn.init.TRContent;

class CableTickManager {
    private static long tickCounter = 0L;
    private static final List<CableBlockEntity> cableList = new ArrayList<CableBlockEntity>();
    private static final List<OfferedEnergyStorage> targetStorages = new ArrayList<OfferedEnergyStorage>();
    private static final Deque<CableBlockEntity> bfsQueue = new ArrayDeque<CableBlockEntity>();

    CableTickManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleCableTick(CableBlockEntity startingCable) {
        if (!(startingCable.method_10997() instanceof class_3218)) {
            throw new IllegalStateException();
        }
        try {
            CableTickManager.gatherCables(startingCable);
            if (cableList.size() == 0) {
                return;
            }
            long networkCapacity = 0L;
            long networkAmount = 0L;
            for (CableBlockEntity cable : cableList) {
                networkAmount += cable.energyContainer.amount;
                networkCapacity += cable.energyContainer.getCapacity();
                cable.appendTargets(targetStorages);
                cable.ioBlocked = true;
            }
            if (networkAmount > networkCapacity) {
                networkAmount = networkCapacity;
            }
            networkAmount += CableTickManager.dispatchTransfer(startingCable.getCableType(), EnergyStorage::extract, networkCapacity - networkAmount);
            networkAmount -= CableTickManager.dispatchTransfer(startingCable.getCableType(), EnergyStorage::insert, networkAmount);
            int cableCount = cableList.size();
            for (CableBlockEntity cable : cableList) {
                cable.energyContainer.amount = networkAmount / (long)cableCount;
                networkAmount -= cable.energyContainer.amount;
                --cableCount;
                cable.method_5431();
                cable.ioBlocked = false;
            }
        }
        finally {
            cableList.clear();
            targetStorages.clear();
            bfsQueue.clear();
        }
    }

    private static boolean shouldTickCable(CableBlockEntity current) {
        class_3218 sw;
        if (current.lastTick == tickCounter) {
            return false;
        }
        class_1937 class_19372 = current.method_10997();
        return class_19372 instanceof class_3218 && (sw = (class_3218)class_19372).method_22340(current.method_11016());
    }

    private static void gatherCables(CableBlockEntity start) {
        if (!CableTickManager.shouldTickCable(start)) {
            return;
        }
        bfsQueue.add(start);
        start.lastTick = tickCounter;
        cableList.add(start);
        while (!bfsQueue.isEmpty()) {
            CableBlockEntity current = bfsQueue.removeFirst();
            for (class_2350 direction : class_2350.values()) {
                class_2586 class_25862 = current.getAdjacentBlockEntity(direction);
                if (!(class_25862 instanceof CableBlockEntity)) continue;
                CableBlockEntity adjCable = (CableBlockEntity)class_25862;
                if (current.getCableType() != adjCable.getCableType() || !CableTickManager.shouldTickCable(adjCable)) continue;
                bfsQueue.add(adjCable);
                adjCable.lastTick = tickCounter;
                cableList.add(adjCable);
            }
        }
    }

    private static long dispatchTransfer(TRContent.Cables cableType, TransferOperation operation, long maxAmount) {
        ArrayList<SortableStorage> sortedTargets = new ArrayList<SortableStorage>();
        for (OfferedEnergyStorage storage : targetStorages) {
            sortedTargets.add(new SortableStorage(operation, storage));
        }
        Collections.shuffle(sortedTargets);
        sortedTargets.sort(Comparator.comparingLong(sortableStorage -> sortableStorage.simulationResult));
        try (Transaction transaction = Transaction.openOuter();){
            long transferredAmount = 0L;
            for (int i = 0; i < sortedTargets.size(); ++i) {
                SortableStorage target = (SortableStorage)sortedTargets.get(i);
                long remainingAmount = maxAmount - transferredAmount;
                int remainingTargets = sortedTargets.size() - i;
                long targetMaxAmount = Math.min(remainingAmount / (long)remainingTargets, (long)cableType.transferRate);
                long localTransferred = operation.transfer(target.storage.storage, targetMaxAmount, transaction);
                if (localTransferred <= 0L) continue;
                transferredAmount += localTransferred;
                target.storage.afterTransfer();
            }
            transaction.commit();
            long l = transferredAmount;
            return l;
        }
    }

    static {
        ServerTickEvents.START_SERVER_TICK.register(server -> ++tickCounter);
    }

    private static interface TransferOperation {
        public long transfer(EnergyStorage var1, long var2, Transaction var4);
    }

    private static class SortableStorage {
        private final OfferedEnergyStorage storage;
        private final long simulationResult;

        SortableStorage(TransferOperation operation, OfferedEnergyStorage storage) {
            this.storage = storage;
            try (Transaction tx = Transaction.openOuter();){
                this.simulationResult = operation.transfer(storage.storage, Long.MAX_VALUE, tx);
            }
        }
    }
}

