/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.generator;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_3611;
import reborncore.common.fluid.FluidUtils;
import techreborn.api.generator.FluidGeneratorRecipe;

public class FluidGeneratorRecipeList {
    private HashSet<FluidGeneratorRecipe> recipes;

    public FluidGeneratorRecipeList(FluidGeneratorRecipe ... recipes) {
        this.recipes = Sets.newHashSet((Object[])recipes);
    }

    public boolean addRecipe(FluidGeneratorRecipe fluidGeneratorRecipe) {
        if (!this.getRecipeForFluid(fluidGeneratorRecipe.fluid()).isPresent()) {
            return this.getRecipes().add(fluidGeneratorRecipe);
        }
        return false;
    }

    public boolean removeRecipe(FluidGeneratorRecipe fluidGeneratorRecipe) {
        return this.getRecipes().remove(fluidGeneratorRecipe);
    }

    public Optional<FluidGeneratorRecipe> getRecipeForFluid(class_3611 fluid) {
        return this.recipes.stream().filter(recipe -> FluidUtils.fluidEquals((class_3611)recipe.fluid(), (class_3611)fluid)).findAny();
    }

    public HashSet<FluidGeneratorRecipe> getRecipes() {
        return this.recipes;
    }

    public void setRecipes(HashSet<FluidGeneratorRecipe> recipes) {
        this.recipes = recipes;
    }

    public String toString() {
        return "FluidGeneratorRecipeList [recipes=" + this.recipes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.recipes == null ? 0 : this.recipes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FluidGeneratorRecipeList other = (FluidGeneratorRecipeList)obj;
        if (this.recipes == null) {
            return other.recipes == null;
        }
        return this.recipes.equals(other.recipes);
    }
}

