/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.text;

import java.util.ArrayList;
import java.util.Optional;
import me.lortseam.completeconfig.data.Config;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public final class TranslationKey {
    private static final char DELIMITER = '.';
    private final String modKey;
    private final String subKey;

    public static TranslationKey from(Config config) {
        return new TranslationKey("config." + config.getMod().getId(), null);
    }

    @Environment(value=EnvType.CLIENT)
    private TranslationKey(String modKey, String subKey) {
        this.modKey = modKey;
        this.subKey = subKey;
    }

    private String getKey() {
        if (this.subKey == null) {
            return this.modKey;
        }
        return this.modKey + this.subKey;
    }

    public TranslationKey root() {
        return new TranslationKey(this.modKey, null);
    }

    public boolean exists() {
        return class_1074.method_4663((String)this.getKey());
    }

    public class_2561 toText(Object ... args) {
        return new class_2588(this.getKey(), args);
    }

    public TranslationKey append(String ... subKeys) {
        StringBuilder subKeyBuilder = new StringBuilder();
        if (this.subKey != null) {
            subKeyBuilder.append(this.subKey);
        }
        for (String subKey : subKeys) {
            subKeyBuilder.append('.').append(subKey);
        }
        return new TranslationKey(this.modKey, subKeyBuilder.toString());
    }

    public Optional<TranslationKey[]> appendTooltip() {
        TranslationKey baseTranslation = this.append("tooltip");
        if (baseTranslation.exists()) {
            return Optional.of(new TranslationKey[]{baseTranslation});
        }
        ArrayList<TranslationKey> multiLineTranslation = new ArrayList<TranslationKey>();
        int i = 0;
        while (true) {
            TranslationKey key;
            if (!(key = baseTranslation.append(Integer.toString(i))).exists()) {
                if (multiLineTranslation.isEmpty()) break;
                return Optional.of(multiLineTranslation.toArray(new TranslationKey[0]));
            }
            multiLineTranslation.add(key);
            ++i;
        }
        return Optional.empty();
    }

    public String toString() {
        return this.getKey();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationKey)) {
            return false;
        }
        TranslationKey other = (TranslationKey)o;
        String this$modKey = this.modKey;
        String other$modKey = other.modKey;
        if (this$modKey == null ? other$modKey != null : !this$modKey.equals(other$modKey)) {
            return false;
        }
        String this$subKey = this.subKey;
        String other$subKey = other.subKey;
        return !(this$subKey == null ? other$subKey != null : !this$subKey.equals(other$subKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modKey = this.modKey;
        result = result * 59 + ($modKey == null ? 43 : $modKey.hashCode());
        String $subKey = this.subKey;
        result = result * 59 + ($subKey == null ? 43 : $subKey.hashCode());
        return result;
    }
}

