/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import me.lortseam.completeconfig.CompleteConfig;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.ConfigRegistry;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.data.Parent;
import me.lortseam.completeconfig.data.extension.BaseExtension;
import me.lortseam.completeconfig.data.structure.Identifiable;
import me.lortseam.completeconfig.data.structure.StructurePart;
import me.lortseam.completeconfig.data.structure.client.TooltipSupplier;
import me.lortseam.completeconfig.data.structure.client.Translatable;
import me.lortseam.completeconfig.data.transform.Transformation;
import me.lortseam.completeconfig.data.transform.Transformer;
import me.lortseam.completeconfig.text.TranslationKey;
import me.lortseam.completeconfig.util.ReflectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class Entry<T>
implements StructurePart,
Identifiable,
Translatable,
TooltipSupplier {
    private static final Logger logger = LoggerFactory.getLogger((String)"CompleteConfig");
    private static final Transformer DEFAULT_TRANSFORMER = Entry::new;
    protected final EntryOrigin origin;
    private final Class<T> typeClass;
    private final String id;
    private final T defaultValue;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey translation;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey[] tooltipTranslation;
    private final boolean requiresRestart;
    private final String comment;
    private final UnaryOperator<T> valueModifier;
    private final Setter<T> setter;

    static Entry<?> of(Config root, Parent parent, Field field, ConfigContainer container) {
        EntryOrigin origin = new EntryOrigin(root, parent, field, container);
        return ConfigRegistry.getTransformations().stream().filter(transformation -> transformation.test(origin)).findFirst().map(Transformation::getTransformer).orElse(DEFAULT_TRANSFORMER).transform(origin);
    }

    protected Entry(EntryOrigin origin, UnaryOperator<T> valueModifier) {
        ConfigRegistry.register(origin);
        this.origin = origin;
        if (!origin.getField().canAccess(origin.getObject())) {
            origin.getField().setAccessible(true);
        }
        this.typeClass = ReflectionUtils.getTypeClass(this.getType());
        this.valueModifier = valueModifier;
        this.defaultValue = this.getValue();
        Optional<ConfigEntry> annotation = origin.getOptionalAnnotation(ConfigEntry.class);
        this.id = annotation.isPresent() && !annotation.get().value().isBlank() ? annotation.get().value() : origin.getField().getName();
        this.requiresRestart = annotation.isPresent() && annotation.get().requiresRestart();
        this.comment = annotation.isPresent() && !annotation.get().comment().isBlank() ? annotation.get().comment() : null;
        this.setter = ReflectionUtils.getSetterMethod(origin.getField(), origin.getObject()).map(method -> (x$0, xva$1) -> method.invoke(x$0, xva$1)).orElse((object, value) -> origin.getField().set(object, value));
    }

    protected Entry(EntryOrigin origin) {
        this(origin, null);
    }

    public Type getType() {
        return this.origin.getType();
    }

    public T getValue() {
        if (this.update()) {
            return this.getValue();
        }
        return this.getFieldValue();
    }

    private T getFieldValue() {
        try {
            return (T)Objects.requireNonNull(this.origin.getField().get(this.origin.getObject()), this.origin.getField().toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get entry value", e);
        }
    }

    public void setValue(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.update(value);
    }

    private boolean update() {
        return this.update(this.getFieldValue());
    }

    private boolean update(T value) {
        if (this.valueModifier != null) {
            value = this.valueModifier.apply(value);
        }
        if (value.equals(this.getFieldValue())) {
            return false;
        }
        this.set(value);
        this.origin.getContainer().onUpdate();
        this.origin.getRoot().onChildUpdate();
        return true;
    }

    private void set(T value) {
        try {
            this.setter.set(this.origin.getObject(), value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to set entry value", e);
        }
    }

    @Override
    public TranslationKey getTranslation() {
        if (this.translation == null) {
            Optional<ConfigEntry> annotation = this.origin.getOptionalAnnotation(ConfigEntry.class);
            this.translation = annotation.isPresent() && !annotation.get().translationKey().isBlank() ? this.origin.getParent().getTranslation().root().append(annotation.get().translationKey()) : this.origin.getParent().getTranslation().append(this.id);
        }
        return this.translation;
    }

    @Override
    public TranslationKey[] getTooltipTranslation() {
        if (this.tooltipTranslation == null) {
            Optional<ConfigEntry> annotation = this.origin.getOptionalAnnotation(ConfigEntry.class);
            this.tooltipTranslation = annotation.isPresent() && annotation.get().tooltipTranslationKeys().length > 0 ? (TranslationKey[])Arrays.stream(annotation.get().tooltipTranslationKeys()).map(key -> {
                if (key.isBlank()) {
                    throw new AssertionError((Object)("Tooltip translation key of entry " + this.origin.getField() + " may not be blank"));
                }
                return this.getTranslation().root().append((String)key);
            }).toArray(TranslationKey[]::new) : this.getTranslation().appendTooltip().orElse(new TranslationKey[0]);
        }
        return this.tooltipTranslation;
    }

    @Override
    public void apply(CommentedConfigurationNode node) {
        try {
            Object value = node.get(this.getType());
            if (value == null) {
                throw new SerializationException((ConfigurationNode)node, this.getType(), "Unable to deserialize value of this type");
            }
            this.setValue(value);
        }
        catch (SerializationException e) {
            logger.error("Failed to apply value to entry", (Throwable)e);
        }
    }

    @Override
    public void fetch(CommentedConfigurationNode node) {
        try {
            node.set(ReflectionUtils.boxType(this.getType()), this.getValue());
            if (this.comment != null) {
                node.comment(this.comment);
            }
        }
        catch (SerializationException e) {
            logger.error("Failed to fetch value from entry", (Throwable)e);
        }
    }

    public String toString() {
        return this.origin.getField().toString();
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean requiresRestart() {
        return this.requiresRestart;
    }

    static {
        for (Transformation[] transformations : CompleteConfig.collectExtensions(BaseExtension.class, BaseExtension::getTransformations)) {
            ConfigRegistry.register(transformations);
        }
    }

    @FunctionalInterface
    private static interface Setter<T> {
        public void set(Object var1, T var2) throws IllegalAccessException, InvocationTargetException;
    }
}

