/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.data.transform.Transformation;

public final class ConfigRegistry {
    private static final Set<Config> configs = new HashSet<Config>();
    private static final Map<String, Config> mainConfigs = new HashMap<String, Config>();
    private static final Set<EntryOrigin> origins = new HashSet<EntryOrigin>();
    private static final List<Transformation> transformations = Lists.newArrayList((Object[])Transformation.DEFAULTS);

    static void register(Config config) {
        if (!configs.add(config)) {
            throw new UnsupportedOperationException(config + " already exists");
        }
        String modId = config.getMod().getId();
        if (!mainConfigs.containsKey(modId)) {
            mainConfigs.put(modId, config);
        } else {
            mainConfigs.put(modId, null);
        }
    }

    static void register(EntryOrigin origin) {
        if (origins.contains(origin)) {
            throw new UnsupportedOperationException(origin.getField() + " was already resolved");
        }
        origins.add(origin);
    }

    static void register(Transformation ... transformations) {
        ConfigRegistry.transformations.addAll(Arrays.asList(transformations));
    }

    public static void setMainConfig(@NonNull Config config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        mainConfigs.put(config.getMod().getId(), config);
    }

    public static Map<String, Config> getMainConfigs() {
        return Collections.unmodifiableMap(mainConfigs);
    }

    static Collection<Transformation> getTransformations() {
        return Collections.unmodifiableCollection(transformations);
    }

    private ConfigRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

