/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.math.BigDecimal;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.data.EntryOrigin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedEntry<T extends Number>
extends Entry<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"CompleteConfig");
    private final T min;
    private final T max;

    public BoundedEntry(EntryOrigin origin, T min, T max) {
        super(origin, value -> {
            if (new BigDecimal(value.toString()).compareTo(new BigDecimal(min.toString())) < 0) {
                logger.warn("Tried to set value of field " + origin.getField() + " to a value less than lower bound, setting to minimum now");
                return min;
            }
            if (new BigDecimal(value.toString()).compareTo(new BigDecimal(max.toString())) > 0) {
                logger.warn("Tried to set value of field " + origin.getField() + " to a value greater than upper bound, setting to maximum now");
                return max;
            }
            return value;
        });
        this.min = min;
        this.max = max;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }
}

