/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.text.TranslationKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

public class BooleanEntry
extends Entry<Boolean> {
    @Environment(value=EnvType.CLIENT)
    private Map<Boolean, TranslationKey> valueTranslations;

    public BooleanEntry(EntryOrigin origin) {
        super(origin);
    }

    @Environment(value=EnvType.CLIENT)
    private Map<Boolean, TranslationKey> getValueTranslations() {
        if (this.valueTranslations == null) {
            TranslationKey defaultFalseTranslation;
            TranslationKey defaultTrueTranslation;
            this.valueTranslations = new HashMap<Boolean, TranslationKey>();
            Optional<ConfigEntry.Boolean> annotation = this.origin.getOptionalAnnotation(ConfigEntry.Boolean.class);
            if (annotation.isPresent()) {
                if (!annotation.get().trueTranslationKey().isBlank()) {
                    this.valueTranslations.put(true, this.getTranslation().root().append(annotation.get().trueTranslationKey()));
                }
                if (!annotation.get().falseTranslationKey().isBlank()) {
                    this.valueTranslations.put(false, this.getTranslation().root().append(annotation.get().falseTranslationKey()));
                }
            }
            if ((defaultTrueTranslation = this.getTranslation().append("true")).exists()) {
                this.valueTranslations.putIfAbsent(true, defaultTrueTranslation);
            }
            if ((defaultFalseTranslation = this.getTranslation().append("false")).exists()) {
                this.valueTranslations.putIfAbsent(false, defaultFalseTranslation);
            }
        }
        return this.valueTranslations;
    }

    @Environment(value=EnvType.CLIENT)
    public Function<Boolean, class_2561> getValueTextSupplier() {
        if (this.getValueTranslations().isEmpty()) {
            return null;
        }
        return value -> this.getValueTranslations().get(value).toText(new Object[0]);
    }
}

