/*
 * Decompiled with CFR 0.152.
 */
package definedentity.xenon.vec;

import definedentity.xenon.vec.Matrix4;
import definedentity.xenon.vec.Transformation;
import definedentity.xenon.vec.Vector3;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.class_2382;

public class Translation
extends Transformation {
    public static final Translation CENTER = new Translation(Vector3.CENTER);
    public Vector3 vec;

    public Translation(Vector3 vec) {
        this.vec = vec;
    }

    public Translation(class_2382 vec) {
        this.vec = Vector3.fromVec3i(vec);
    }

    public Translation(double x, double y, double z) {
        this(new Vector3(x, y, z));
    }

    public Translation(Translation trans) {
        this(trans.vec.copy());
    }

    @Override
    public void apply(Vector3 vec) {
        vec.add(this.vec);
    }

    @Override
    public void applyN(Vector3 normal) {
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.translate(this.vec);
    }

    @Override
    public Transformation at(Vector3 point) {
        return this;
    }

    @Override
    public Transformation inverse() {
        return new Translation(-this.vec.x, -this.vec.y, -this.vec.z);
    }

    @Override
    public Transformation merge(Transformation next) {
        if (next instanceof Translation) {
            Translation t = (Translation)next;
            return new Translation(this.vec.copy().add(t.vec));
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return this.vec.equalsT(Vector3.ZERO);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Translation(" + String.valueOf(new BigDecimal(this.vec.x, cont)) + ", " + String.valueOf(new BigDecimal(this.vec.y, cont)) + ", " + String.valueOf(new BigDecimal(this.vec.z, cont)) + ")";
    }

    @Override
    public Translation copy() {
        return new Translation(this);
    }
}

