/*
 * Decompiled with CFR 0.152.
 */
package definedentity.xenon.render;

import definedentity.xenon.render.buffer.TransformingVertexConsumer;
import definedentity.xenon.vec.Cuboid6;
import definedentity.xenon.vec.Matrix4;
import definedentity.xenon.vec.Rotation;
import definedentity.xenon.vec.Vector3;
import definedentity.xenon.vec.Vertex5;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class RenderUtils {
    private static final Vector3[] vectors = new Vector3[8];

    public static void makeFluidCuboid(List<Vertex5> vertices, Cuboid6 bound, class_1058 tex, double res) {
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void makeFluidQuadVertices(List<Vertex5> vertices, Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, class_1058 icon, double res) {
        RenderUtils.makeFluidQuadVertices(vertices, point2, vectors[0].set(point4).subtract(point1), vectors[1].set(point1).subtract(point2), icon, res);
    }

    public static void makeFluidQuadVertices(List<Vertex5> vertices, Vector3 base, Vector3 wide, Vector3 high, class_1058 icon, double res) {
        double rx;
        Vector3 a = new Vector3();
        Vector3 b = new Vector3();
        Vector3 c = new Vector3();
        Vector3 d = new Vector3();
        double u1 = icon.method_4594();
        double du = icon.method_4577() - icon.method_4594();
        double v2 = icon.method_4575();
        double dv = icon.method_4575() - icon.method_4593();
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = a.set(wide).multiply(x / wlen);
                Vector3 dx2 = b.set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = c.set(high).multiply(y / hlen);
                Vector3 dy2 = d.set(high).multiply((y + ry) / hlen);
                vertices.add(new Vertex5(base.x + dx1.x + dy2.x, base.y + dx1.y + dy2.y, base.z + dx1.z + dy2.z, u1, v2 - ry / res * dv));
                vertices.add(new Vertex5(base.x + dx1.x + dy1.x, base.y + dx1.y + dy1.y, base.z + dx1.z + dy1.z, u1, v2));
                vertices.add(new Vertex5(base.x + dx2.x + dy1.x, base.y + dx2.y + dy1.y, base.z + dx2.z + dy1.z, u1 + rx / res * du, v2));
                vertices.add(new Vertex5(base.x + dx2.x + dy2.x, base.y + dx2.y + dy2.y, base.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv));
            }
        }
    }

    public static void bufferCuboidSolid(class_4588 builder, Cuboid6 c, float r, float g, float b, float a) {
        builder.method_22912(c.min.x, c.max.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.max.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.min.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.min.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.min.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.min.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.max.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.max.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.min.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.min.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.min.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.min.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.max.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.max.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.max.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.max.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.min.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.max.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.max.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.min.x, c.min.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.min.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.max.y, c.min.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.max.y, c.max.z).method_22915(r, g, b, a).method_1344();
        builder.method_22912(c.max.x, c.min.y, c.max.z).method_22915(r, g, b, a).method_1344();
    }

    public static void bufferHitbox(Matrix4 mat, class_4597 getter, class_4184 renderInfo, Cuboid6 cuboid) {
        class_243 projectedView = renderInfo.method_19326();
        RenderUtils.bufferHitBox(mat.copy().translate(-projectedView.field_1352, -projectedView.field_1351, -projectedView.field_1350), getter, cuboid);
    }

    public static void bufferHitBox(Matrix4 mat, class_4597 getter, Cuboid6 cuboid) {
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.getBuffer(class_1921.method_23594()), mat);
        RenderUtils.bufferCuboidOutline(builder, cuboid.copy().expand(0.002f), 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void bufferCuboidOutline(class_4588 builder, Cuboid6 c, float r, float g, float b, float a) {
        RenderUtils.bufferLinePair(builder, c.min.x, c.min.y, c.min.z, c.max.x, c.min.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.min.y, c.min.z, c.max.x, c.min.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.min.y, c.max.z, c.min.x, c.min.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.min.y, c.max.z, c.min.x, c.min.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.max.y, c.min.z, c.max.x, c.max.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.max.y, c.min.z, c.max.x, c.max.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.max.y, c.max.z, c.min.x, c.max.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.max.y, c.max.z, c.min.x, c.max.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.min.y, c.min.z, c.min.x, c.max.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.min.y, c.min.z, c.max.x, c.max.y, c.min.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.max.x, c.min.y, c.max.z, c.max.x, c.max.y, c.max.z, r, g, b, a);
        RenderUtils.bufferLinePair(builder, c.min.x, c.min.y, c.max.z, c.min.x, c.max.y, c.max.z, r, g, b, a);
    }

    public static void bufferShapeHitBox(Matrix4 mat, class_4597 buffers, class_4184 renderInfo, class_265 shape) {
        class_243 projectedView = renderInfo.method_19326();
        RenderUtils.bufferShapeHitBox(mat.copy().translate(-projectedView.field_1352, -projectedView.field_1351, -projectedView.field_1350), buffers, shape);
    }

    public static void bufferShapeHitBox(Matrix4 mat, class_4597 buffers, class_265 shape) {
        TransformingVertexConsumer builder = new TransformingVertexConsumer(buffers.getBuffer(class_1921.method_23594()), mat);
        RenderUtils.bufferShapeOutline(builder, shape, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void bufferShapeOutline(class_4588 builder, class_265 shape, float r, float g, float b, float a) {
        shape.method_1104((x1, y1, z1, x2, y2, z2) -> RenderUtils.bufferLinePair(builder, x1, y1, z1, x2, y2, z2, r, g, b, a));
    }

    private static void bufferLinePair(class_4588 builder, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        Vector3 v1 = vectors[0].set(x1, y1, z1).subtract(x2, y2, z2);
        double d = v1.mag();
        v1.divide(d);
        builder.method_22912(x1, y1, z1).method_22915(r, g, b, a).method_22914((float)v1.x, (float)v1.y, (float)v1.z).method_1344();
        builder.method_22912(x2, y2, z2).method_22915(r, g, b, a).method_22914((float)v1.x, (float)v1.y, (float)v1.z).method_1344();
    }

    public static Matrix4 getMatrix(Matrix4 in, Vector3 translation, Rotation rotation, double scale) {
        return in.translate(translation).scale(scale).rotate(rotation);
    }

    @Deprecated
    public static Matrix4 getMatrix(Vector3 translation, Rotation rotation, double scale) {
        return RenderUtils.getMatrix(new Matrix4(), translation, rotation, scale);
    }

    public static float getPearlBob(double time) {
        return (float)Math.sin(time / 25.0 * 3.141593) * 0.1f;
    }

    public static int getTimeOffset(class_2338 pos) {
        return RenderUtils.getTimeOffset(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static int getTimeOffset(int x, int y, int z) {
        return x * 3 + y * 5 + z * 9;
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
    }
}

