/*
 * Decompiled with CFR 0.152.
 */
package definedentity.xenon.render;

import com.google.common.collect.ImmutableList;
import definedentity.xenon.colour.Colour;
import definedentity.xenon.colour.ColourRGBA;
import definedentity.xenon.model.CachedFormat;
import definedentity.xenon.render.buffer.ISpriteAwareVertexConsumer;
import definedentity.xenon.render.buffer.TransformingVertexConsumer;
import definedentity.xenon.render.lighting.LC;
import definedentity.xenon.render.lighting.LightMatrix;
import definedentity.xenon.render.pipeline.CCRenderPipeline;
import definedentity.xenon.render.pipeline.IVertexOperation;
import definedentity.xenon.render.pipeline.IVertexSource;
import definedentity.xenon.render.pipeline.VertexAttribute;
import definedentity.xenon.render.pipeline.attribute.ColourAttribute;
import definedentity.xenon.render.pipeline.attribute.LightCoordAttribute;
import definedentity.xenon.render.pipeline.attribute.LightingAttribute;
import definedentity.xenon.render.pipeline.attribute.NormalAttribute;
import definedentity.xenon.render.pipeline.attribute.SideAttribute;
import definedentity.xenon.vec.Matrix4;
import definedentity.xenon.vec.Vector3;
import definedentity.xenon.vec.Vertex5;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;

public class CCRenderState {
    private static final ThreadLocal<CCRenderState> instances = ThreadLocal.withInitial(CCRenderState::new);
    public final VertexAttribute<Vector3[]> normalAttrib = new NormalAttribute();
    public final VertexAttribute<int[]> colourAttrib = new ColourAttribute();
    public final VertexAttribute<int[]> lightingAttrib = new LightingAttribute();
    public final VertexAttribute<int[]> sideAttrib = new SideAttribute();
    public final VertexAttribute<LC[]> lightCoordAttrib = new LightCoordAttribute();
    public IVertexSource model;
    public int firstVertexIndex;
    public int lastVertexIndex;
    public int vertexIndex;
    public CCRenderPipeline pipeline;
    public class_4588 r;
    public class_293 fmt;
    public CachedFormat cFmt;
    public int baseColour;
    public int alphaOverride;
    public boolean computeLighting;
    public LightMatrix lightMatrix = new LightMatrix();
    public final Vertex5 vert = new Vertex5();
    public final Vector3 normal = new Vector3();
    public int colour;
    public int brightness;
    public int overlay;
    public int side;
    public LC lc = new LC();
    public class_1058 sprite;

    private CCRenderState() {
        this.pipeline = new CCRenderPipeline(this);
    }

    public static CCRenderState instance() {
        return instances.get();
    }

    public class_287 startDrawing(class_293.class_5596 mode, class_293 format) {
        class_287 r = class_289.method_1348().method_1349();
        r.method_1328(mode, format);
        this.bind(r);
        return r;
    }

    public class_287 startDrawing(class_293.class_5596 mode, class_293 format, class_287 buffer) {
        buffer.method_1328(mode, format);
        this.bind(buffer);
        return buffer;
    }

    public void bind(class_287 r) {
        this.bind((class_4588)r, r.field_1565);
    }

    public void bind(class_4588 consumer, class_293 format) {
        this.r = consumer;
        this.fmt = format;
        this.cFmt = CachedFormat.lookup(format);
    }

    public void bind(class_1921 renderType, class_4597 source) {
        this.bind(source.getBuffer(renderType), renderType.method_23031());
    }

    public void bind(class_1921 renderType, class_4597 source, class_4587 mStack) {
        this.bind(new TransformingVertexConsumer(source.getBuffer(renderType), mStack), renderType.method_23031());
    }

    public void bind(class_1921 renderType, class_4597 getter, Matrix4 mat) {
        this.bind(new TransformingVertexConsumer(getter.getBuffer(renderType), mat), renderType.method_23031());
    }

    public void reset() {
        this.model = null;
        this.pipeline.reset();
        this.computeLighting = true;
        this.alphaOverride = -1;
        this.baseColour = -1;
        this.colour = -1;
    }

    public void preRenderWorld(class_1920 world, class_2338 pos) {
        this.reset();
        this.colour = -1;
        this.setBrightness(world, pos);
    }

    public void setPipeline(IVertexOperation ... ops) {
        this.pipeline.setPipeline(ops);
    }

    public void setPipeline(IVertexSource model, int start, int end, IVertexOperation ... ops) {
        this.pipeline.reset();
        this.setModel(model, start, end);
        this.pipeline.setPipeline(ops);
    }

    public void bindModel(IVertexSource model) {
        if (this.model != model) {
            this.model = model;
            this.pipeline.rebuild();
        }
    }

    public void setModel(IVertexSource source) {
        this.setModel(source, 0, source.getVertexCount());
    }

    public void setModel(IVertexSource source, int start, int end) {
        this.bindModel(source);
        this.setVertexRange(start, end);
    }

    public void setVertexRange(int start, int end) {
        this.firstVertexIndex = start;
        this.lastVertexIndex = end;
    }

    public void render(IVertexOperation ... ops) {
        this.setPipeline(ops);
        this.render();
    }

    public void render() {
        Vertex5[] verts = this.model.getVertices();
        this.vertexIndex = this.firstVertexIndex;
        while (this.vertexIndex < this.lastVertexIndex) {
            this.model.prepareVertex(this);
            this.vert.set(verts[this.vertexIndex]);
            this.runPipeline();
            this.writeVert();
            ++this.vertexIndex;
        }
    }

    public void runPipeline() {
        this.pipeline.operate();
    }

    public void writeVert() {
        if (this.r instanceof ISpriteAwareVertexConsumer) {
            ((ISpriteAwareVertexConsumer)this.r).sprite(this.sprite);
        }
        ImmutableList elements = this.fmt.method_1357();
        block12: for (int e = 0; e < elements.size(); ++e) {
            class_296 fmte = (class_296)elements.get(e);
            switch (fmte.method_1382()) {
                case field_1633: {
                    this.r.method_22912(this.vert.vec.x, this.vert.vec.y, this.vert.vec.z);
                    continue block12;
                }
                case field_1636: {
                    int idx = fmte.method_1385();
                    switch (idx) {
                        case 0: {
                            this.r.method_22913((float)this.vert.uv.u, (float)this.vert.uv.v);
                            break;
                        }
                        case 1: {
                            this.r.method_22922(this.overlay);
                            break;
                        }
                        case 2: {
                            this.r.method_22916(this.brightness);
                        }
                    }
                    continue block12;
                }
                case field_1632: {
                    if (this.r instanceof class_287 && ((class_287)this.r).field_20889) {
                        ((class_287)this.r).method_1325();
                        continue block12;
                    }
                    this.r.method_1336(this.colour >>> 24, this.colour >> 16 & 0xFF, this.colour >> 8 & 0xFF, this.alphaOverride >= 0 ? this.alphaOverride : this.colour & 0xFF);
                    continue block12;
                }
                case field_1635: {
                    this.r.method_22914((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
                    continue block12;
                }
                case field_1629: {
                    continue block12;
                }
                default: {
                    throw new UnsupportedOperationException("Generic vertex format element");
                }
            }
        }
        this.r.method_1344();
    }

    public void setBrightness(class_1920 world, class_2338 pos) {
        this.brightness = class_761.method_23793((class_1920)world, (class_2680)world.method_8320(pos), (class_2338)pos);
    }

    public void setBrightness(class_1297 entity, float frameDelta) {
        this.brightness = class_310.method_1551().method_1561().method_23839(entity, frameDelta);
    }

    public void setColour(Colour colour) {
        this.colour = colour.rgba();
    }

    public ColourRGBA getColour() {
        return new ColourRGBA(this.colour);
    }

    public class_4588 getConsumer() {
        return this.r;
    }

    public class_293 getVertexFormat() {
        return this.fmt;
    }

    public void draw() {
        class_289.method_1348().method_1350();
    }
}

