/*
 * Decompiled with CFR 0.152.
 */
package definedentity.xenon.raytracer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import definedentity.xenon.vec.Cuboid6;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class VoxelShapeCache {
    private static final Cache<class_238, class_265> bbToShapeCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();
    private static final Cache<Cuboid6, class_265> cuboidToShapeCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();
    private static final Cache<ImmutableSet<class_265>, class_265> mergeShapeCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();

    public static class_265 getShape(class_238 aabb) {
        class_265 shape = (class_265)bbToShapeCache.getIfPresent((Object)aabb);
        if (shape == null) {
            shape = class_259.method_1078((class_238)aabb);
            bbToShapeCache.put((Object)aabb, (Object)shape);
        }
        return shape;
    }

    public static class_265 getShape(Cuboid6 cuboid) {
        class_265 shape = (class_265)cuboidToShapeCache.getIfPresent((Object)cuboid);
        if (shape == null) {
            shape = class_259.method_1081((double)cuboid.min.x, (double)cuboid.min.y, (double)cuboid.min.z, (double)cuboid.max.x, (double)cuboid.max.y, (double)cuboid.max.z);
            cuboidToShapeCache.put((Object)cuboid, (Object)shape);
        }
        return shape;
    }

    public static class_265 merge(ImmutableSet<class_265> shapes) {
        class_265 shape = (class_265)mergeShapeCache.getIfPresent(shapes);
        if (shape == null) {
            shape = shapes.stream().reduce(class_259.method_1073(), class_259::method_1084);
            mergeShapeCache.put(shapes, (Object)shape);
        }
        return shape;
    }
}

