/*
 * Decompiled with CFR 0.152.
 */
package definedentity.xenon.math;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;

public class MathHelper {
    public static final double phi = 1.618033988749894;
    public static final double pi = Math.PI;
    public static final double todeg = 57.29577951308232;
    public static final double torad = 0.017453292519943;
    public static final double sqrt2 = 1.414213562373095;
    public static double[] SIN_TABLE = new double[65536];

    public static double sin(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f) & 0xFFFF];
    }

    public static double cos(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float approachLinear(float a, float b, float max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public static double approachLinear(double a, double b, double max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public static float interpolate(float a, float b, float d) {
        return a + (b - a) * d;
    }

    public static double interpolate(double a, double b, double d) {
        return a + (b - a) * d;
    }

    public static double approachExp(double a, double b, double ratio) {
        return a + (b - a) * ratio;
    }

    public static double approachExp(double a, double b, double ratio, double cap) {
        double d = (b - a) * ratio;
        if (Math.abs(d) > cap) {
            d = Math.signum(d) * cap;
        }
        return a + d;
    }

    public static double retreatExp(double a, double b, double c, double ratio, double kick) {
        double d = (Math.abs(c - a) + kick) * ratio;
        if (d > Math.abs(b - a)) {
            return b;
        }
        return a + Math.signum(b - a) * d;
    }

    public static double clip(double value, double min, double max) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static float clip(float value, float min, float max) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static int clip(int value, int min, int max) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static double map(double valueIn, double inMin, double inMax, double outMin, double outMax) {
        return (valueIn - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static float map(float valueIn, float inMin, float inMax, float outMin, float outMax) {
        return (valueIn - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static double round(double number, double multiplier) {
        return (double)Math.round(number * multiplier) / multiplier;
    }

    public static float round(float number, float multiplier) {
        return (float)Math.round(number * multiplier) / multiplier;
    }

    public static boolean between(double min, double value, double max) {
        return min <= value && value <= max;
    }

    public static int approachExpI(int a, int b, double ratio) {
        int r = (int)Math.round(MathHelper.approachExp(a, b, ratio));
        return r == a ? b : r;
    }

    public static int retreatExpI(int a, int b, int c, double ratio, int kick) {
        int r = (int)Math.round(MathHelper.retreatExp(a, b, c, ratio, kick));
        return r == a ? b : r;
    }

    public static int floor(double d) {
        int i = (int)d;
        return d < (double)i ? i - 1 : i;
    }

    public static int floor(float f) {
        int i = (int)f;
        return f < (float)i ? i - 1 : i;
    }

    public static int ceil(double d) {
        int i = (int)d;
        return d > (double)i ? i + 1 : i;
    }

    public static int ceil(float f) {
        int i = (int)f;
        return f > (float)i ? i + 1 : i;
    }

    public static float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static float sqrt(double f) {
        return (float)Math.sqrt(f);
    }

    public static int roundAway(double d) {
        return (int)(d < 0.0 ? Math.floor(d) : Math.ceil(d));
    }

    public static int compare(int a, int b) {
        return Integer.compare(a, b);
    }

    public static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    public static class_2338 min(class_2382 pos1, class_2382 pos2) {
        return new class_2338(Math.min(pos1.method_10263(), pos2.method_10263()), Math.min(pos1.method_10264(), pos2.method_10264()), Math.min(pos1.method_10260(), pos2.method_10260()));
    }

    public static class_2338 max(class_2382 pos1, class_2382 pos2) {
        return new class_2338(Math.max(pos1.method_10263(), pos2.method_10263()), Math.max(pos1.method_10264(), pos2.method_10264()), Math.max(pos1.method_10260(), pos2.method_10260()));
    }

    public static int absSum(class_2338 pos) {
        return Math.abs(pos.method_10263()) + Math.abs(pos.method_10264()) + Math.abs(pos.method_10260());
    }

    public static boolean isAxial(class_2338 pos) {
        return pos.method_10263() == 0 ? pos.method_10264() == 0 || pos.method_10260() == 0 : pos.method_10264() == 0 && pos.method_10260() == 0;
    }

    public static int toSide(class_2338 pos) {
        class_2350 side = MathHelper.getSide(pos);
        return side == null ? -1 : side.method_10146();
    }

    public static class_2350 getSide(class_2338 pos) {
        if (!MathHelper.isAxial(pos)) {
            return null;
        }
        if (pos.method_10264() < 0) {
            return class_2350.field_11033;
        }
        if (pos.method_10264() > 0) {
            return class_2350.field_11036;
        }
        if (pos.method_10260() < 0) {
            return class_2350.field_11043;
        }
        if (pos.method_10260() > 0) {
            return class_2350.field_11035;
        }
        if (pos.method_10263() < 0) {
            return class_2350.field_11039;
        }
        if (pos.method_10263() > 0) {
            return class_2350.field_11034;
        }
        return null;
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = Math.sin((double)i / 65536.0 * 2.0 * Math.PI);
        }
    }
}

