/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YTags;
import com.unascribed.yttr.world.SimpleStructureProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2515;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2776;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5431;
import net.minecraft.class_5819;
import net.minecraft.class_6677;

public class WastelandPopulator {
    private static final int FLAGS = 50;

    public static boolean isEligible(class_3218 world, class_2818 chunk) {
        if (world.method_23753(chunk.method_12004().method_8323()).method_40230().map(k -> k.method_29177().toString().equals("yttr:wasteland")).orElse(false).booleanValue()) {
            return chunk.method_8320(class_2338.field_10980).method_26204() != YBlocks.SPECIALTY_BEDROCK;
        }
        return false;
    }

    public static void populate(long worldSeed, class_3218 world, class_1923 chunk) {
        class_2338 chunkStart = chunk.method_8323().method_33096(world.method_31607());
        if (world.method_23753(chunkStart).method_40230().map(k -> k.method_29177().toString().equals("yttr:wasteland")).orElse(false).booleanValue()) {
            class_2350 d;
            if (world.method_8320(chunkStart).method_26204() == YBlocks.SPECIALTY_BEDROCK) {
                return;
            }
            world.method_30092(chunkStart, YBlocks.SPECIALTY_BEDROCK.method_9564(), 0, 0);
            class_2919 rand = new class_2919((class_5819)new class_6677(worldSeed));
            rand.method_12661(worldSeed, chunk.method_8326(), chunk.method_8328());
            class_2338.class_2339 mut = new class_2338.class_2339();
            class_2338.class_2339 mut2 = new class_2338.class_2339();
            class_2338.class_2339 mut3 = new class_2338.class_2339();
            if (rand.nextInt(100) < 5) {
                d = class_2350.class_2353.field_11062.method_10183((Random)rand);
                int x = chunkStart.method_10263();
                int z = chunkStart.method_10260();
                mut.method_10103(x += rand.nextInt(16), world.method_8624(class_2902.class_2903.field_13202, x, z += rand.nextInt(16)) + 2, z);
                int distanceSinceTorch = 0;
                int stripMineY = -1;
                if (rand.nextInt(100) < 60) {
                    stripMineY = 11 + rand.nextInt(6);
                }
                for (int i = 0; i < 1000 && WastelandPopulator.didYouKnowWeHaveVeinMiner((class_1936)world, (class_2338)mut, (Random)rand); ++i) {
                    if (rand.nextInt(10) < distanceSinceTorch && !world.method_8320(mut.method_10093(d.method_10160())).method_26215()) {
                        world.method_30092((class_2338)mut, (class_2680)YBlocks.RUINED_WALL_TORCH.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)d.method_10170()), 50, 0);
                        distanceSinceTorch = 0;
                    }
                    mut.method_10098(class_2350.field_11033);
                    if (!WastelandPopulator.didYouKnowWeHaveVeinMiner((class_1936)world, (class_2338)mut, (Random)rand)) break;
                    mut.method_10098(class_2350.field_11033);
                    if (!WastelandPopulator.didYouKnowWeHaveVeinMiner((class_1936)world, (class_2338)mut, (Random)rand)) break;
                    mut.method_10098(class_2350.field_11033);
                    if (world.method_8320((class_2338)mut).method_26215()) {
                        world.method_30092((class_2338)mut, mut.method_10264() > 50 ? YBlocks.RUINED_COBBLESTONE.method_9564() : class_2246.field_10445.method_9564(), 50, 0);
                    }
                    mut.method_10098(class_2350.field_11036);
                    if (mut.method_10264() == stripMineY) {
                        mut2.method_10101((class_2382)mut);
                        int distanceSinceTorch2 = 0;
                        class_2350 d2 = rand.nextBoolean() ? d.method_10170() : d.method_10160();
                        for (int j = 0; j < 40 + rand.nextInt(80); ++j) {
                            mut2.method_10098(d2);
                            if (!WastelandPopulator.didYouKnowWeHaveVeinMiner((class_1936)world, (class_2338)mut2, (Random)rand)) break;
                            mut2.method_10098(class_2350.field_11033);
                            if (world.method_8320((class_2338)mut2).method_26215()) {
                                world.method_30092((class_2338)mut2, class_2246.field_10445.method_9564(), 50, 0);
                            }
                            mut2.method_10098(class_2350.field_11036);
                            mut2.method_10098(class_2350.field_11036);
                            if (!WastelandPopulator.didYouKnowWeHaveVeinMiner((class_1936)world, (class_2338)mut2, (Random)rand)) break;
                            if (rand.nextInt(10) < distanceSinceTorch2 && !world.method_8320(mut2.method_10093(d2.method_10160())).method_26215()) {
                                world.method_30092((class_2338)mut2, (class_2680)YBlocks.RUINED_WALL_TORCH.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)d2.method_10170()), 50, 0);
                                distanceSinceTorch2 = 0;
                            }
                            mut2.method_10098(class_2350.field_11033);
                            if (j % 3 != 0) continue;
                            class_2350 d3 = d;
                            block2: for (int p = 0; p < 2; ++p) {
                                int distanceSinceTorch3 = 0;
                                if (p == 1) {
                                    d3 = d3.method_10153();
                                }
                                mut3.method_10101((class_2382)mut2);
                                for (int k2 = 0; k2 < rand.nextInt(50) + 20; ++k2) {
                                    mut3.method_10098(d3);
                                    if (!WastelandPopulator.didYouKnowWeHaveVeinMiner((class_1936)world, (class_2338)mut3, (Random)rand)) continue block2;
                                    mut3.method_10098(class_2350.field_11033);
                                    if (world.method_8320((class_2338)mut3).method_26215()) {
                                        world.method_30092((class_2338)mut3, class_2246.field_10445.method_9564(), 50, 0);
                                    }
                                    mut3.method_10098(class_2350.field_11036);
                                    mut3.method_10098(class_2350.field_11036);
                                    if (!WastelandPopulator.didYouKnowWeHaveVeinMiner((class_1936)world, (class_2338)mut3, (Random)rand)) continue block2;
                                    if (rand.nextInt(10) < distanceSinceTorch3 && !world.method_8320(mut3.method_10093(d3.method_10160())).method_26215()) {
                                        world.method_30092((class_2338)mut3, (class_2680)YBlocks.RUINED_WALL_TORCH.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)d3.method_10170()), 50, 0);
                                        distanceSinceTorch3 = 0;
                                    }
                                    mut3.method_10098(class_2350.field_11033);
                                    ++distanceSinceTorch3;
                                }
                            }
                        }
                    }
                    mut.method_10098(class_2350.field_11036);
                    mut.method_10098(d);
                    ++distanceSinceTorch;
                }
            }
            if (rand.nextInt(200) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_10100(rand.nextInt(16), 0, rand.nextInt(16));
                mut.method_33098(world.method_8624(class_2902.class_2903.field_13202, mut.method_10263(), mut.method_10260()));
                int w = rand.nextInt(20) + 3;
                int h = rand.nextInt(10) + 2;
                int d2 = rand.nextInt(20) + 3;
                for (int y = -4; y <= h + 1; ++y) {
                    for (int x = -2; x <= w + 1; ++x) {
                        for (int z = -2; z <= d2 + 1; ++z) {
                            mut2.method_10101((class_2382)mut).method_10100(x, -y, z);
                            if (x < 0 || x >= w || y >= h || z < 0 || z >= d2) {
                                class_2680 bs = world.method_8320((class_2338)mut2);
                                if (!bs.method_26164(class_3481.field_25806) && !bs.method_26164(YTags.Block.ORES) && !bs.method_27852(class_2246.field_10255) && !bs.method_27852(class_2246.field_10566) || (x == -2 || z == -2 || y == h + 1 || x == w + 1 || z == d2 + 1) && !rand.nextBoolean()) continue;
                                world.method_30092((class_2338)mut2, bs.method_27852(class_2246.field_10566) ? YBlocks.WASTELAND_DIRT.method_9564() : YBlocks.WASTELAND_STONE.method_9564(), 50, 0);
                                continue;
                            }
                            world.method_30092((class_2338)mut2, class_2246.field_10124.method_9564(), 50, 0);
                        }
                    }
                }
            }
            if (rand.nextInt(20) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_33098(-1);
                WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/twilight_portal", -2, true, false);
            }
            if (rand.nextInt(400) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_33098(-1);
                WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/laundromat", 0, true, true);
            }
            if (rand.nextInt(100) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_33098(-1);
                WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/sulfur_goo_farm", 1, true, true);
            }
            if (rand.nextInt(100) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_33098(-1);
                d = class_2350.class_2353.field_11062.method_10183((Random)rand);
                for (int i = 0; i < 1 + rand.nextInt(8) && WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/coke_oven", 0, false, true); ++i) {
                    mut.method_10104(d, 4);
                    mut.method_33098(world.method_8624(class_2902.class_2903.field_13202, mut.method_10263() - 1, mut.method_10260() - 1));
                }
            }
            if (rand.nextInt(100) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_33098(-1);
                WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/blast_furnace", 0, false, true);
            }
            if (rand.nextInt(200) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_33098(-1);
                WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/quarry", 0, false, true);
            }
            if (rand.nextInt(200) == 0) {
                mut.method_10101((class_2382)chunkStart);
                if (rand.nextInt(4) == 0) {
                    mut.method_33098(-1);
                    WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/9x9_rare", -2, true, true);
                } else {
                    mut.method_33098(-1);
                    WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/9x9", -1, true, true);
                }
            }
            if (rand.nextInt(300) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_33098(-1);
                WastelandPopulator.tryPlaceSchematic(rand, world, (class_2338)mut, "yttr:ruined/arboretum", -1, true, true);
            }
            while (rand.nextInt(3) == 0) {
                mut.method_10101((class_2382)chunkStart);
                mut.method_10100(rand.nextInt(16), 0, rand.nextInt(16));
                mut.method_33098(world.method_8624(class_2902.class_2903.field_13202, mut.method_10263(), mut.method_10260()));
                class_2680 bs = world.method_8320((class_2338)mut);
                if (!bs.method_26215() && !bs.method_27852(YBlocks.WASTELAND_DIRT) || !world.method_8320(mut.method_10074()).method_27852(YBlocks.WASTELAND_DIRT)) continue;
                world.method_30092((class_2338)mut, YBlocks.RUINED_TORCH.method_9564(), 50, 0);
            }
            if (rand.nextInt(40) == 0) {
                double x = (double)chunkStart.method_10263() + rand.nextDouble() * 16.0;
                double z = (double)chunkStart.method_10260() + rand.nextDouble() * 16.0;
                double y = (double)world.method_8624(class_2902.class_2903.field_13202, (int)x, (int)z) + rand.nextGaussian();
                WastelandPopulator.explode(world, x, y, z, 4.0f + rand.nextFloat() * 3.0f);
            }
            if (rand.nextInt(500) == 0) {
                double x = (double)chunkStart.method_10263() + rand.nextDouble() * 16.0;
                double z = (double)chunkStart.method_10260() + rand.nextDouble() * 16.0;
                double y = (double)world.method_8624(class_2902.class_2903.field_13202, (int)x, (int)z) + rand.nextGaussian();
                for (int i = 0; i < 30 + rand.nextInt(50); ++i) {
                    WastelandPopulator.explode(world, x + rand.nextGaussian() * 20.0, y, z + rand.nextGaussian() * 20.0, 6.0f);
                }
            }
        }
    }

    private static void explode(class_3218 world, double x, double y, double z, float power) {
        class_1927 e = new class_1927((class_1937)world, null, class_1282.field_5849, null, x, y, z, power, false, class_1927.class_4179.field_18687);
        e.method_8348();
        for (class_2338 bp : e.method_8346()) {
            world.method_30092(bp, class_2246.field_10124.method_9564(), 50, 0);
        }
        for (class_2338 bp : e.method_8346()) {
            for (class_2350 d : class_2350.values()) {
                class_2338 o = bp.method_10093(d);
                class_2680 bs = world.method_8320(o);
                if (!bs.method_26164(class_3481.field_25806) && !bs.method_26164(YTags.Block.ORES) && !bs.method_27852(class_2246.field_10255) && !bs.method_27852(class_2246.field_10566)) continue;
                world.method_30092(o, bs.method_27852(class_2246.field_10566) ? YBlocks.WASTELAND_DIRT.method_9564() : YBlocks.WASTELAND_STONE.method_9564(), 50, 0);
            }
        }
    }

    public static boolean didYouKnowWeHaveVeinMiner(class_1936 world, class_2338 pos, Random rand) {
        if (pos.method_10264() <= 0) {
            return false;
        }
        HashSet seen = Sets.newHashSet();
        HashSet scan = Sets.newHashSet();
        HashSet nextScan = Sets.newHashSet();
        class_2350[] directions = class_2350.values();
        int i = 0;
        scan.clear();
        nextScan.clear();
        class_2338 start = pos.method_10062();
        scan.add(start);
        boolean hitUnbreakable = false;
        while (!scan.isEmpty() && i++ <= 32) {
            for (class_2338 bp : scan) {
                class_2338 c;
                class_2680 bs2;
                class_2680 bs = world.method_8320(bp);
                if (bs.method_26164(YTags.Block.ORES) || bp.equals((Object)start)) {
                    for (class_2350 d : directions) {
                        class_2338 c2 = bp.method_10093(d);
                        class_2680 bs22 = world.method_8320(c2);
                        if (!bs22.method_26164(YTags.Block.ORES) && (d != class_2350.field_11036 || !(bs22.method_26204() instanceof class_2346)) || !seen.add(c2)) continue;
                        if (!bs22.method_26164(YTags.Block.LESSER_ORES) || rand.nextInt(40) >= seen.size() + 2) {
                            nextScan.add(c2);
                            continue;
                        }
                        break;
                    }
                } else if (bs.method_26204() instanceof class_2346 && ((bs2 = world.method_8320(c = bp.method_10084())).method_26164(YTags.Block.ORES) || bs2.method_26204() instanceof class_2346) && seen.add(c)) {
                    nextScan.add(c);
                }
                if (bs.method_26164(YTags.Block.ORES) || bs.method_27852(YBlocks.WASTELAND_DIRT) || bs.method_26164(class_3481.field_25806) || bs.method_26204() instanceof class_2346) {
                    world.method_30092(bp, class_2246.field_10124.method_9564(), 50, 0);
                    continue;
                }
                if (bs.method_26215() || bs.method_26207().method_15800() || bs.method_27852(YBlocks.RUINED_WALL_TORCH)) continue;
                hitUnbreakable = true;
            }
            scan.clear();
            scan.addAll(nextScan);
            nextScan.clear();
        }
        return !hitUnbreakable;
    }

    private static boolean tryPlaceSchematic(class_2919 rand, class_3218 world, class_2338 pos, String id, int yOffset, boolean eatDirt, boolean fill) {
        Optional opt = world.method_14183().method_15094(new class_2960(id));
        if (!opt.isPresent()) {
            return false;
        }
        class_3499 s = (class_3499)opt.get();
        class_2470 rot = class_2470.method_16548((Random)rand);
        class_3492 spd = new class_3492();
        spd.method_15123(rot);
        spd.method_15131(false);
        class_2338 size = new class_2338(s.method_15166(rot));
        class_2338 origin = pos.method_10069(-size.method_10263() / 2, 0, -size.method_10260() / 2);
        if (origin.method_10264() == -1) {
            origin = new class_2338(origin.method_10263(), world.method_8624(class_2902.class_2903.field_13202, origin.method_10263(), origin.method_10260()), origin.method_10260());
        }
        origin = origin.method_10086(yOffset);
        int originY = origin.method_10264();
        for (class_2338 bpp : class_2338.method_10097((class_2338)origin, (class_2338)origin.method_10081(s.method_15166(rot)))) {
            class_2680 bs = world.method_8320(bpp);
            if (bs.method_26215() || bs.method_26207().method_15800() || eatDirt && bs.method_27852(YBlocks.WASTELAND_DIRT)) continue;
            return false;
        }
        ArrayList fillIn = Lists.newArrayList();
        if (fill) {
            spd.method_16184((class_3491)SimpleStructureProcessor.of(block -> {
                if (block.field_15597.method_10264() == originY && block.field_15596.method_30368((class_1922)world, block.field_15597, class_2350.field_11033, class_5431.field_25822) && (block.field_15595 == null || !"yttr:quarry_hole".equals(block.field_15595.method_10558("metadata")))) {
                    fillIn.add(block.field_15597);
                }
                return block;
            }));
        }
        s.method_15172((class_5425)world, origin, origin, spd, (Random)rand, 3);
        block1: for (class_3499.class_3501 info : s.method_15165(origin, spd, class_2246.field_10465, true)) {
            class_2338.class_2339 bp;
            if (info == null || info.field_15596.method_11654((class_2769)class_2515.field_11586) != class_2776.field_12696 || info.field_15595 == null) continue;
            if ("yttr:quarry_hole".equals(info.field_15595.method_10558("metadata"))) {
                bp = info.field_15597.method_25503();
                for (int y = info.field_15597.method_10264(); y >= world.method_31607(); --y) {
                    bp.method_33098(y);
                    class_2680 bs = world.method_8320((class_2338)bp);
                    if (bs.method_27852(class_2246.field_9987)) continue block1;
                    world.method_8501((class_2338)bp, class_2246.field_10124.method_9564());
                }
                continue;
            }
            if (!"yttr:maybe_tree".equals(info.field_15595.method_10558("metadata"))) continue;
            bp = info.field_15597.method_25503();
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(7) + 1; ++i) {
                    world.method_8501((class_2338)bp, YBlocks.WASTELAND_LOG.method_9564());
                    bp.method_10098(class_2350.field_11036);
                }
                continue;
            }
            if (rand.nextBoolean()) {
                world.method_8501((class_2338)bp, YBlocks.WASTELAND_GRASS.method_9564());
                continue;
            }
            world.method_8501((class_2338)bp, class_2246.field_10124.method_9564());
        }
        for (class_2338 b : fillIn) {
            class_2338.class_2339 scan = b.method_25503();
            scan.method_10098(class_2350.field_11033);
            while (world.method_8320((class_2338)scan).method_26215() || world.method_8320((class_2338)scan).method_26207().method_15800()) {
                world.method_30092((class_2338)scan, YBlocks.WASTELAND_DIRT.method_9564(), 50, 0);
                scan.method_10098(class_2350.field_11033);
            }
        }
        return true;
    }
}

