/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.world;

import com.google.common.collect.Lists;
import com.unascribed.yttr.YConfig;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YTags;
import com.unascribed.yttr.world.LootTableFromPaperStructureProcessor;
import com.unascribed.yttr.world.NetherWoodSwapStructureProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2515;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2776;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3481;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3543;
import net.minecraft.class_5138;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6677;

public class ScorchedGenerator {
    public static void generateTerminus(long worldSeed, class_3233 region, class_5138 accessor) {
        if (!YConfig.WorldGen.scorched) {
            return;
        }
        if (region.method_8410().method_27983().method_29177().equals((Object)class_2874.field_26753)) {
            class_2338.class_2339 bp = new class_2338.class_2339(0, 0, 0);
            class_2791 chunk = region.method_8392(region.method_33561().field_9181, region.method_33561().field_9180);
            class_2919 rand = new class_2919((class_5819)new class_6677(worldSeed));
            class_3543 fireNoise = new class_3543((class_5819)rand, Arrays.asList(0, 2, 10));
            class_3543 terminusBNoise = new class_3543((class_5819)rand, Arrays.asList(0, 3, 6));
            class_3543 terminusTNoise = new class_3543((class_5819)rand, Arrays.asList(0, 2, 4));
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    double noise;
                    int by;
                    int bZ;
                    int bX = chunk.method_12004().method_8326() + x;
                    double bh = terminusBNoise.method_16451((double)bX / 100.0, (double)(bZ = chunk.method_12004().method_8328() + z) / 100.0, true) * 12.0;
                    if (!(bh > 0.0)) continue;
                    double th = terminusTNoise.method_16451((double)bX / 200.0, (double)bZ / 200.0, true) * 6.0;
                    int lastYH = 0;
                    int y = by = (int)(220.0 - bh);
                    while ((double)y < 220.0 + th) {
                        bp.method_10103(x, y, z);
                        chunk.method_12010((class_2338)bp, YBlocks.NETHERTUFF.method_9564(), false);
                        lastYH = y++;
                    }
                    if (lastYH <= 0) continue;
                    boolean flameoMyGoodHotman = false;
                    double d = rand.nextDouble();
                    if (d < (noise = fireNoise.method_16451((double)bX / 30.0, (double)bZ / 30.0, false) + 0.2)) {
                        bp.method_10103(bX, lastYH, bZ);
                        if (!region.method_8320((class_2338)bp).method_26215()) {
                            bp.method_10103(bX, lastYH + 1, bZ);
                            region.method_8652((class_2338)bp, class_2246.field_10036.method_9564(), 3);
                            flameoMyGoodHotman = true;
                        }
                    }
                    if (flameoMyGoodHotman || !(d - 0.2 > noise)) continue;
                    bp.method_10103(bX, lastYH - 1, bZ);
                    if (region.method_8320((class_2338)bp).method_26215()) continue;
                    bp.method_10103(bX, lastYH, bZ);
                    region.method_8652((class_2338)bp, YBlocks.ASH.method_9564(), 3);
                }
            }
            rand.method_12661(31L * worldSeed, chunk.method_12004().method_8326(), chunk.method_12004().method_8328());
            if (accessor.method_27834()) {
                if (rand.nextInt(40) == 0) {
                    ScorchedGenerator.generateTerminusHouse(region, bp, chunk, rand);
                }
                if (rand.nextInt(30) == 0) {
                    ScorchedGenerator.generateTerminusTotems(region, bp, chunk, rand);
                }
            }
        }
    }

    private static void generateTerminusTotems(class_3233 region, class_2338.class_2339 bp, class_2791 chunk, class_2919 rand) {
        Optional opt = region.method_8410().method_14183().method_15094(Yttr.id("terminus_totems"));
        if (opt.isPresent()) {
            class_2680 bs;
            class_3499 s = (class_3499)opt.get();
            class_3492 spd = new class_3492();
            int y = chunk.method_12032(class_2902.class_2903.field_13202).method_12603(8, 8) - 1 + rand.nextInt(3);
            if (y < 200) {
                return;
            }
            class_2338 origin = new class_2338(chunk.method_12004().method_8326(), y, chunk.method_12004().method_8328());
            class_2382 size = s.method_15160();
            for (class_2338 bpp : class_2338.method_10097((class_2338)origin.method_10069(0, -1, 0), (class_2338)origin.method_10069(size.method_10263(), -1, size.method_10260()))) {
                bs = region.method_8320(bpp);
                if (!bs.method_26215()) continue;
                return;
            }
            for (class_2338 bpp : class_2338.method_10097((class_2338)origin.method_10069(-1, 0, -1), (class_2338)origin.method_10069(size.method_10263(), 1, size.method_10260()))) {
                bs = region.method_8320(bpp);
                if (!bs.method_27852(class_2246.field_10036)) continue;
                region.method_8652(bpp, class_2246.field_10124.method_9564(), 3);
            }
            s.method_15172((class_5425)region, origin, origin.method_10069(size.method_10263() / 2, 0, size.method_10260() / 2), spd, (Random)rand, 3);
            for (class_3499.class_3501 info : s.method_15165(origin, spd, class_2246.field_10465, true)) {
                if (info == null || info.field_15596.method_11654((class_2769)class_2515.field_11586) != class_2776.field_12696 || info.field_15595 == null) continue;
                class_2680 cap = null;
                int height = 0;
                if ("yttr:totem".equals(info.field_15595.method_10558("metadata"))) {
                    height = rand.nextInt(4);
                    cap = YBlocks.POLISHED_SCORCHED_OBSIDIAN_CAPSTONE.method_9564();
                } else if ("yttr:holster".equals(info.field_15595.method_10558("metadata"))) {
                    height = rand.nextInt(4) + 4;
                    cap = YBlocks.POLISHED_SCORCHED_OBSIDIAN_HOLSTER.method_9564();
                }
                if (cap == null) continue;
                bp.method_10101((class_2382)info.field_15597);
                for (int i = 0; i < height; ++i) {
                    region.method_8652((class_2338)bp, YBlocks.POLISHED_SCORCHED_OBSIDIAN.method_9564(), 3);
                    bp.method_10098(class_2350.field_11036);
                }
                region.method_8652((class_2338)bp, cap, 3);
            }
        }
    }

    private static void generateTerminusHouse(class_3233 region, class_2338.class_2339 bp, class_2791 chunk, class_2919 rand) {
        Optional opt = region.method_8410().method_14183().method_15094(Yttr.id("terminus_house"));
        if (opt.isPresent()) {
            int i;
            class_3499 s = (class_3499)opt.get();
            class_2470 rot = class_2470.method_16548((Random)rand);
            ArrayList chains = Lists.newArrayList();
            class_3492 spd = new class_3492();
            spd.method_15123(rot);
            class_2338 origin = new class_2338(chunk.method_12004().method_8326(), 190 + rand.nextInt(30) - s.method_15160().method_10264(), chunk.method_12004().method_8328());
            boolean success = true;
            for (int i2 = 0; i2 < 3; ++i2) {
                success = true;
                for (class_2338 bpp : class_2338.method_10097((class_2338)origin, (class_2338)origin.method_10081(s.method_15166(rot)))) {
                    class_2680 bs = region.method_8320(bpp);
                    if (bs.method_26215()) continue;
                    if (!bs.method_27852(YBlocks.NETHERTUFF)) {
                        return;
                    }
                    success = false;
                    origin = origin.method_10087(bpp.method_10264() - origin.method_10264());
                    break;
                }
                if (success) break;
            }
            if (!success) {
                return;
            }
            boolean foundAllAnchors = true;
            for (Object info : s.method_15165(origin, spd, class_2246.field_10465, true)) {
                if (info == null || ((class_3499.class_3501)info).field_15596.method_11654((class_2769)class_2515.field_11586) != class_2776.field_12696 || ((class_3499.class_3501)info).field_15595 == null || !"yttr:chain".equals(((class_3499.class_3501)info).field_15595.method_10558("metadata"))) continue;
                bp.method_10101((class_2382)((class_3499.class_3501)info).field_15597);
                boolean foundAnchor = false;
                for (i = 0; i < 10; ++i) {
                    bp.method_10098(class_2350.field_11036);
                    if (region.method_8320((class_2338)bp).method_26215()) continue;
                    foundAnchor = true;
                    break;
                }
                if (!foundAnchor) {
                    foundAllAnchors = false;
                    break;
                }
                chains.add(((class_3499.class_3501)info).field_15597.method_10062());
            }
            if (foundAllAnchors) {
                boolean warped = rand.nextBoolean();
                spd.method_16184((class_3491)new NetherWoodSwapStructureProcessor(warped));
                spd.method_16184((class_3491)new LootTableFromPaperStructureProcessor());
                s.method_15172((class_5425)region, origin, origin, spd, (Random)rand, 3);
                for (class_2338 chain : chains) {
                    bp.method_10101((class_2382)chain);
                    for (i = 0; i < 10 && (region.method_8320((class_2338)bp).method_26215() || region.method_8320((class_2338)bp).method_27852(class_2246.field_10465)); ++i) {
                        region.method_8652((class_2338)bp, class_2246.field_23985.method_9564(), 3);
                        bp.method_10098(class_2350.field_11036);
                    }
                }
                bp.method_10101((class_2382)origin);
                bp.method_10098(class_2350.field_11033);
                for (int i3 = 0; i3 < 100 && (region.method_8320((class_2338)bp).method_26215() || region.method_8320((class_2338)bp).method_26164(class_3481.field_21952)); ++i3) {
                    bp.method_10098(class_2350.field_11033);
                }
                region.method_8652((class_2338)bp, class_2246.field_22122.method_9564(), 3);
                bp.method_10098(class_2350.field_11036);
                region.method_8652((class_2338)bp, (warped ? class_2246.field_22131 : class_2246.field_22130).method_9564(), 3);
                bp.method_10104(class_2350.field_11033, 2);
                region.method_8652((class_2338)bp, (class_2680)class_2246.field_10200.method_9564().method_11657((class_2769)class_2315.field_10918, (Comparable)class_2350.field_11036), 3);
                class_2586 be = region.method_8321((class_2338)bp);
                if (be instanceof class_2601) {
                    class_1799 potion = new class_1799((class_1935)class_1802.field_8436);
                    potion.method_7977((class_2561)new class_2588("item.yttr.levitation_splash_potion").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
                    class_1844.method_8056((class_1799)potion, Arrays.asList(new class_1293(class_1294.field_5902, 500, 5)));
                    potion.method_7969().method_10569("CustomPotionColor", class_1294.field_5902.method_5556());
                    ((class_2601)be).method_5447(4, potion);
                }
            }
        }
    }

    public static void generateSummit(class_3233 region, class_2791 chunk) {
        if (region.method_8410().method_27983().method_29177().equals((Object)class_2874.field_26753)) {
            class_2338.class_2339 bp = new class_2338.class_2339(0, 0, 0);
            boolean scorch = ScorchedGenerator.replaceBedrocks(bp, region, chunk, false);
            bp.method_10103(0, 127, 0);
            if (scorch) {
                class_2919 rand = new class_2919((class_5819)new class_6677(region.method_8412()));
                class_3543 noise = new class_3543((class_5819)rand, Arrays.asList(1, 4, 8));
                class_3543 fireNoise = new class_3543((class_5819)rand, Arrays.asList(0, 2, 10));
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int bX = chunk.method_12004().method_8326() + x;
                        int bZ = chunk.method_12004().method_8328() + z;
                        double height = (noise.method_16451((double)bX / 200.0, (double)bZ / 200.0, true) + 0.2) * 6.0;
                        int lastY = 128;
                        if (height < 0.0) {
                            y = 128;
                            while ((double)y > 128.0 + height * 8.0) {
                                bp.method_10103(x, y, z);
                                chunk.method_12010((class_2338)bp, class_2246.field_10124.method_9564(), false);
                                lastY = y - 1;
                                --y;
                            }
                        } else {
                            if (height > 3.0) {
                                height = 3.0 + (height - 3.0) * 10.0;
                            }
                            y = 128;
                            while ((double)y < 128.0 + height) {
                                bp.method_10103(x, y, z);
                                chunk.method_12010((class_2338)bp, YBlocks.NETHERTUFF.method_9564(), false);
                                lastY = y++;
                            }
                        }
                        if (!(rand.nextDouble() * 2.0 < fireNoise.method_16451((double)bX / 20.0, (double)bZ / 20.0, true) - 0.2)) continue;
                        bp.method_10103(bX, lastY, bZ);
                        if (region.method_8320((class_2338)bp).method_26215()) continue;
                        bp.method_10103(bX, lastY + 1, bZ);
                        region.method_8652((class_2338)bp, class_2246.field_10036.method_9564(), 3);
                    }
                }
            }
        }
    }

    private static boolean replaceBedrocks(class_2338.class_2339 bp, class_3233 region, class_2791 chunk, boolean careful) {
        int y;
        int z;
        int x;
        bp.method_10103(0, 0, 0);
        if (YConfig.WorldGen.coreLava && chunk.method_8320((class_2338)bp).method_27852(class_2246.field_9987)) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    bp.method_10103(x, 0, z);
                    if (!careful || ScorchedGenerator.canClobber(chunk.method_8320((class_2338)bp))) {
                        chunk.method_12010((class_2338)bp, class_2246.field_10499.method_9564(), false);
                    }
                    for (y = 1; y < 4; ++y) {
                        bp.method_10103(x, y, z);
                        if (careful && !ScorchedGenerator.canClobber(chunk.method_8320((class_2338)bp))) continue;
                        chunk.method_12010((class_2338)bp, YBlocks.CORE_LAVA.method_9564(), false);
                    }
                    bp.method_10103(x, 4, z);
                    if (!careful || ScorchedGenerator.canClobber(chunk.method_8320((class_2338)bp))) {
                        chunk.method_12010((class_2338)bp, class_2246.field_10124.method_9564(), false);
                    }
                    bp.method_10103(x, 5, z);
                    if (careful && !ScorchedGenerator.canClobber(chunk.method_8320((class_2338)bp))) continue;
                    chunk.method_12010((class_2338)bp, YBlocks.NETHERTUFF.method_9564(), false);
                }
            }
        }
        bp.method_33098(127);
        if (YConfig.WorldGen.scorched && chunk.method_8320((class_2338)bp).method_27852(class_2246.field_9987)) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 120; y < 128; ++y) {
                        bp.method_10103(x, y, z);
                        if (!chunk.method_8320((class_2338)bp).method_27852(class_2246.field_9987)) continue;
                        chunk.method_12010((class_2338)bp, YBlocks.NETHERTUFF.method_9564(), false);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static boolean canClobber(class_2680 bs) {
        return bs.method_26215() || bs.method_26164(YTags.Block.SCORCHED_RETROGEN_IGNORABLE);
    }

    public static boolean isEligibleForRetrogen(class_3218 world, class_2818 chunk) {
        return YConfig.WorldGen.scorchedRetrogen && world.method_27983().method_29177().equals((Object)class_2874.field_26753) && chunk.method_8320(new class_2338(0, 127, 0)).method_27852(class_2246.field_9987);
    }

    public static void retrogen(long seed, class_3218 world, class_1923 pos) {
        class_2818 c = world.method_8497(pos.field_9181, pos.field_9180);
        boolean fullRetrogen = true;
        boolean terminusRetrogen = true;
        for (class_2338 bp : class_2338.method_10097((class_2338)new class_2338(0, 120, 0), (class_2338)new class_2338(15, 160, 15))) {
            if (ScorchedGenerator.canClobber(c.method_8320(bp))) continue;
            fullRetrogen = false;
            break;
        }
        for (class_2338 bp : class_2338.method_10097((class_2338)new class_2338(0, 192, 0), (class_2338)new class_2338(15, world.method_31600(), 15))) {
            if (ScorchedGenerator.canClobber(c.method_8320(bp))) continue;
            terminusRetrogen = false;
            break;
        }
        int r = terminusRetrogen ? 2 : 0;
        ArrayList<class_2791> chunks = new ArrayList<class_2791>();
        for (int x = pos.field_9181 - r; x <= pos.field_9181 + r; ++x) {
            for (int z = pos.field_9180 - r; z <= pos.field_9180 + r; ++z) {
                chunks.add(world.method_22342(x, z, class_2806.field_12798));
            }
        }
        class_3233 region = new class_3233(world, chunks, class_2806.field_12803, 1);
        if (fullRetrogen) {
            ScorchedGenerator.generateSummit(region, (class_2791)c);
        } else {
            ScorchedGenerator.replaceBedrocks(new class_2338.class_2339(), region, (class_2791)c, true);
        }
        if (terminusRetrogen) {
            ScorchedGenerator.generateTerminus(seed, region, world.method_27056());
        }
    }
}

