/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.world;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.unascribed.yttr.util.math.Vec2i;
import com.unascribed.yttr.world.Geyser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class GeysersState
extends class_18 {
    private final Set<Geyser> geysers = Sets.newHashSet();
    private final Map<UUID, Geyser> geysersById = Maps.newHashMap();
    private final Map<class_2338, Geyser> geysersByPos = Maps.newHashMap();
    private final Multimap<class_1923, Geyser> geysersByChunk = HashMultimap.create();
    private final Multimap<Vec2i, Geyser> geysersByRegion = HashMultimap.create();

    public static GeysersState get(class_3218 world) {
        return (GeysersState)world.method_17983().method_17924(GeysersState::readNbt, GeysersState::new, "yttr_geysers_v2");
    }

    public void addGeyser(Geyser g) {
        this.geysers.add(g);
        this.geysersById.put(g.id, g);
        this.geysersByPos.put(g.pos, g);
        this.geysersByChunk.put((Object)g.chunkPos, (Object)g);
        this.geysersByRegion.put((Object)g.regionPos, (Object)g);
        this.method_80();
    }

    @Nullable
    public Geyser getGeyser(UUID id) {
        return this.geysersById.get(id);
    }

    @Nullable
    public Geyser getGeyser(class_2338 pos) {
        return this.geysersByPos.get(pos);
    }

    public Collection<Geyser> getGeysersInChunk(class_1923 pos) {
        return this.geysersByChunk.get((Object)pos);
    }

    public Collection<Geyser> getGeysersInRegion(int x, int z) {
        return this.geysersByRegion.get((Object)new Vec2i(x, z));
    }

    public Collection<Geyser> getGeysersInRange(int x, int z, int range) {
        if (range <= 0) {
            return Collections.emptyList();
        }
        int rangeSq = range * range;
        int chunkRadius = (range + 15) / 16 + 1;
        if (chunkRadius > 16) {
            ArrayList out = Collections.emptyList();
            int regionRadius = (range + 511) / 512 + 1;
            int rX = x / 512;
            int rZ = z / 512;
            for (int rXo = -regionRadius; rXo <= regionRadius; ++rXo) {
                for (int rZo = -regionRadius; rZo <= regionRadius; ++rZo) {
                    for (Geyser g : this.getGeysersInRegion(rX + rXo, rZ + rZo)) {
                        if (!(g.pos.method_40081((double)x, (double)g.pos.method_10264(), (double)z) < (double)rangeSq)) continue;
                        if (out.isEmpty()) {
                            out = Lists.newArrayList();
                        }
                        out.add(g);
                    }
                }
            }
            return out;
        }
        ArrayList out = Collections.emptyList();
        int cX = x / 16;
        int cZ = z / 16;
        for (int cXo = -chunkRadius; cXo <= chunkRadius; ++cXo) {
            for (int cZo = -chunkRadius; cZo <= chunkRadius; ++cZo) {
                for (Geyser g : this.getGeysersInChunk(new class_1923(cX + cXo, cZ + cZo))) {
                    if (!(g.pos.method_40081((double)x, (double)g.pos.method_10264(), (double)z) < (double)rangeSq)) continue;
                    if (out.isEmpty()) {
                        out = Lists.newArrayList();
                    }
                    out.add(g);
                }
            }
        }
        return out;
    }

    public void removeGeyser(UUID id) {
        Geyser g = this.geysersById.remove(id);
        if (g != null) {
            this.geysers.remove(g);
            this.geysersByPos.remove(g.pos, g);
            this.geysersByChunk.remove((Object)g.chunkPos, (Object)g);
            this.geysersByRegion.remove((Object)g.regionPos, (Object)g);
        }
    }

    public void removeGeyser(class_2338 pos) {
        Geyser g = this.geysersByPos.remove(pos);
        if (g != null) {
            this.geysers.remove(g);
            this.geysersById.remove(g.id, g);
            this.geysersByChunk.remove((Object)g.chunkPos, (Object)g);
            this.geysersByRegion.remove((Object)g.regionPos, (Object)g);
        }
    }

    public static GeysersState readNbt(class_2487 tag) {
        GeysersState ret = new GeysersState();
        class_2499 li = tag.method_10554("Geysers", 10);
        for (int i = 0; i < li.size(); ++i) {
            ret.addGeyser(Geyser.fromTag(li.method_10602(i)));
        }
        return ret;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 li = new class_2499();
        for (Geyser g : this.geysers) {
            li.add((Object)g.toTag());
        }
        tag.method_10566("Geysers", (class_2520)li);
        return tag;
    }
}

