/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.world;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.unascribed.yttr.util.YLog;
import com.unascribed.yttr.world.FilterNetwork;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class FilterNetworks
extends class_18 {
    protected class_3218 world;
    private final Map<UUID, FilterNetwork> networks = Maps.newHashMap();
    protected final Map<class_2338, FilterNetwork> networksByPos = Maps.newHashMap();
    private static final ImmutableList<class_2350> DIRECTIONS = ImmutableList.copyOf((Object[])class_2350.values());

    public static FilterNetworks get(class_3218 world) {
        FilterNetworks fn = (FilterNetworks)world.method_17983().method_17924(FilterNetworks::readNbt, FilterNetworks::new, "yttr_filter_networks");
        fn.world = world;
        return fn;
    }

    public static FilterNetworks readNbt(class_2487 tag) {
        FilterNetworks ret = new FilterNetworks();
        class_2487 networks = tag.method_10562("Networks");
        for (String k : networks.method_10541()) {
            UUID id = UUID.fromString(k);
            FilterNetwork fn = new FilterNetwork(ret, id);
            fn.readNbt(networks.method_10562(k));
            ret.addNetworkDirectly(fn);
        }
        return ret;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2487 networks = new class_2487();
        for (FilterNetwork fn : this.networks.values()) {
            class_2487 en = new class_2487();
            fn.writeNbt(en);
            networks.method_10566(fn.getId().toString(), (class_2520)en);
        }
        nbt.method_10566("Networks", (class_2520)networks);
        return nbt;
    }

    public void tick() {
        for (FilterNetwork fn : this.networks.values()) {
            fn.tick();
        }
    }

    public Optional<FilterNetwork> getNetworkAt(class_2338 pos) {
        return Optional.ofNullable(this.networksByPos.get(pos));
    }

    public void addNetwork(FilterNetwork network) {
        this.addNetworkDirectly(network);
        this.method_80();
    }

    private void addNetworkDirectly(FilterNetwork network) {
        if (network.getOwner() != this) {
            throw new IllegalArgumentException("Network does not belong to this world");
        }
        this.networks.put(network.getId(), network);
        network.onAdded();
    }

    public void removeNetwork(FilterNetwork network) {
        this.removeNetworkDirectly(network);
        this.method_80();
    }

    private void removeNetworkDirectly(FilterNetwork network) {
        if (network.getOwner() != this) {
            throw new IllegalArgumentException("Network does not belong to this world");
        }
        this.networks.remove(network.getId(), network);
        network.onRemoved();
    }

    public void introduce(class_2338 pos, FilterNetwork.NodeType type) {
        FilterNetwork.Node n = new FilterNetwork.Node(pos, type);
        if (this.networksByPos.containsKey(pos)) {
            this.networksByPos.get(pos).addNode(n);
            return;
        }
        for (class_2338 neighbor : FilterNetworks.neighbors(pos)) {
            if (!this.networksByPos.containsKey(neighbor)) continue;
            this.networksByPos.get(neighbor).addNode(n);
            return;
        }
        FilterNetwork net = new FilterNetwork(this, UUID.randomUUID());
        YLog.debug("Creating new network {} for orphan at {}, {}, {}", net.getId(), pos.method_10263(), pos.method_10264(), pos.method_10260());
        net.addNode(n);
        this.addNetwork(net);
    }

    public void destroy(class_2338 pos) {
        if (this.networksByPos.containsKey(pos)) {
            this.networksByPos.get(pos).removeNodeAt(pos);
        }
    }

    public static Set<class_2338> neighbors(class_2338 pos) {
        final class_2338 fpos = pos.method_10062();
        return new AbstractSet<class_2338>(){

            @Override
            public Iterator<class_2338> iterator() {
                return new AbstractIterator<class_2338>(){
                    private final class_2338.class_2339 mut = new class_2338.class_2339();
                    private final Iterator<class_2350> dirIter = DIRECTIONS.iterator();

                    protected class_2338 computeNext() {
                        if (!this.dirIter.hasNext()) {
                            return (class_2338)this.endOfData();
                        }
                        return this.mut.method_10101((class_2382)fpos).method_10098(this.dirIter.next());
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof class_2338 && fpos.method_19455((class_2382)((class_2338)o)) == 1;
            }

            @Override
            public int size() {
                return DIRECTIONS.size();
            }
        };
    }
}

