/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.world;

import com.google.common.base.Ascii;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.unascribed.yttr.content.block.device.VoidFilterBlock;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.util.NBTUtils;
import com.unascribed.yttr.util.YLog;
import com.unascribed.yttr.world.FilterNetworks;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class FilterNetwork {
    private final FilterNetworks owner;
    private UUID id;
    private final MutableGraph<Node> members = GraphBuilder.undirected().allowsSelfLoops(true).nodeOrder(ElementOrder.unordered()).build();
    private final Map<class_2338, Node> membersByPos = Maps.newHashMap();
    private final Multimap<NodeType, Node> membersByType = HashMultimap.create();
    private int totalFluidCapacity;
    private int fluidProductionPerTick;
    private int fluidContent;

    public FilterNetwork(FilterNetworks owner) {
        this.owner = owner;
    }

    public FilterNetwork(FilterNetworks owner, UUID id) {
        this(owner);
        this.id = id;
    }

    private void removeNodeDirectly(Node n) {
        this.members.removeNode((Object)n);
        this.membersByPos.remove(n.pos, n);
        this.membersByType.remove((Object)n.type, (Object)n);
        this.owner.networksByPos.remove(n.pos, this);
    }

    private void addNodeDirectly(Node n) {
        if (this.membersByPos.containsKey(n.pos)) {
            this.removeNodeDirectly(this.membersByPos.get(n.pos));
        }
        this.members.addNode((Object)n);
        this.membersByPos.put(n.pos, n);
        this.membersByType.put((Object)n.type, (Object)n);
        this.owner.networksByPos.put(n.pos, this);
    }

    public void removeNodeAt(class_2338 pos) {
        YLog.trace("Removing {} from network {}", (Object)pos, (Object)this.id);
        if (this.membersByPos.containsKey(pos)) {
            Node node = this.membersByPos.get(pos);
            HashSet neighbors = Sets.newHashSet((Iterable)this.members.adjacentNodes((Object)node));
            this.removeNodeDirectly(node);
            if (neighbors.size() > 1) {
                for (Node a : neighbors) {
                    if (!this.members.nodes().contains(a)) continue;
                    for (Node b : neighbors) {
                        if (!this.members.nodes().contains(b) || a == b || this.isReachable(a, b)) continue;
                        FilterNetwork other = new FilterNetwork(this.owner, UUID.randomUUID());
                        YLog.debug("Splitting network {} of size {} off into {}", this.id, this.size(), other.id);
                        Set reachable = Graphs.reachableNodes(this.members, (Object)b);
                        for (int p = 0; p < 3; ++p) {
                            for (Node n : reachable) {
                                if (p == 0) {
                                    other.addNodeDirectly(n);
                                    continue;
                                }
                                if (p == 1) {
                                    for (Node n2 : this.members.adjacentNodes((Object)n)) {
                                        other.members.putEdge((Object)n, (Object)n2);
                                    }
                                    continue;
                                }
                                if (p != 2) continue;
                                this.removeNodeDirectly(n);
                            }
                        }
                        other.update();
                        YLog.debug("Network {} is now of size {}, and {} is of size {}", this.id, this.size(), other.id, other.size());
                        this.owner.addNetwork(other);
                    }
                }
            }
            this.update();
            this.owner.method_80();
            if (this.isEmpty()) {
                YLog.debug("Destroying empty network {}", (Object)this.id);
                this.owner.removeNetwork(this);
            }
        }
    }

    public void addNode(Node node) {
        Node cur = this.membersByPos.get(node.pos);
        if (cur != null && cur.type == node.type) {
            return;
        }
        Set<class_2338> neighbors = FilterNetworks.neighbors(node.pos);
        if (cur != null && !this.isEmpty()) {
            if (neighbors.stream().noneMatch(this.membersByPos::containsKey)) {
                throw new IllegalArgumentException("Cannot add orphan node at " + node.pos + " to non-empty network");
            }
        }
        this.addNodeDirectly(node);
        YLog.debug("Adding {}, {}, {} to network {}", node.pos.method_10263(), node.pos.method_10264(), node.pos.method_10260(), this.id);
        for (class_2338 neighbor : neighbors) {
            Node originator;
            Node n = this.membersByPos.get(neighbor);
            if (n != null) {
                this.members.putEdge((Object)node, (Object)n);
                continue;
            }
            FilterNetwork other = this.owner.networksByPos.get(neighbor);
            if (other == null || (originator = other.membersByPos.get(neighbor)) == null) continue;
            YLog.debug("Joining network {} of size {} and network {} of size {}", this.id, this.size(), other.id, other.size());
            for (int p = 0; p < 2; ++p) {
                for (Node no : other.members.nodes()) {
                    if (p == 0) {
                        this.addNodeDirectly(no);
                        continue;
                    }
                    if (p != 1) continue;
                    for (Node no2 : other.members.adjacentNodes((Object)no)) {
                        this.members.putEdge((Object)no, (Object)no2);
                    }
                }
            }
            this.members.putEdge((Object)node, (Object)originator);
            YLog.debug("Network {} is now of size {}. Destroying {}", this.id, this.size(), other.id);
            this.owner.removeNetwork(other);
        }
        this.update();
        this.owner.method_80();
    }

    public void tick() {
    }

    private void update() {
        boolean complete = this.isComplete();
        for (Node n : this.membersByType.get((Object)NodeType.FILTER)) {
            class_2680 bs = this.owner.world.method_8320(n.pos);
            if (!bs.method_27852((class_2248)YBlocks.VOID_FILTER)) continue;
            this.owner.world.method_8501(n.pos, (class_2680)bs.method_11657((class_2769)VoidFilterBlock.INDEPENDENT, (Comparable)Boolean.valueOf(!complete)));
        }
        this.totalFluidCapacity = this.membersByType.get((Object)NodeType.PIPE).size() * 100 + this.membersByType.get((Object)NodeType.TANK).size() * 64000;
        this.fluidProductionPerTick = this.membersByType.get((Object)NodeType.FILTER).size() * 2;
    }

    public void clear() {
        for (class_2338 bp : this.membersByPos.keySet()) {
            this.owner.networksByPos.remove(bp, this);
        }
        this.members.nodes().clear();
        this.membersByPos.clear();
        this.membersByType.clear();
        this.totalFluidCapacity = 0;
    }

    public FilterNetworks getOwner() {
        return this.owner;
    }

    public UUID getId() {
        return this.id;
    }

    private boolean isReachable(Node from, Node to) {
        return Graphs.reachableNodes(this.members, (Object)from).contains(to);
    }

    public int size() {
        return this.members.nodes().size();
    }

    public boolean isEmpty() {
        return this.members.nodes().isEmpty();
    }

    public boolean isComplete() {
        return this.membersByType.containsKey((Object)NodeType.TANK) && this.membersByType.containsKey((Object)NodeType.DSU) && this.membersByType.containsKey((Object)NodeType.FILTER);
    }

    public void onAdded() {
        for (class_2338 bp : this.membersByPos.keySet()) {
            this.owner.networksByPos.put(bp, this);
        }
    }

    public void onRemoved() {
        for (class_2338 bp : this.membersByPos.keySet()) {
            this.owner.networksByPos.remove(bp, this);
        }
    }

    public void readNbt(class_2487 compound) {
        class_2499 li = compound.method_10554("Nodes", 10);
        ArrayList nodes = Lists.newArrayList();
        ArrayList conns = Lists.newArrayList();
        this.clear();
        for (int i = 0; i < li.size(); ++i) {
            Object en = li.method_10602(i);
            class_2338 pos = NBTUtils.listToBlockPos(en.method_10554("Pos", 3));
            NodeType type = NodeType.valueOf(Ascii.toUpperCase((String)en.method_10558("Type")));
            Node n = new Node(pos, type);
            nodes.add(n);
            conns.add(Maps.immutableEntry((Object)n, (Object)en.method_10561("Conn")));
            this.addNodeDirectly(n);
        }
        for (Object en : conns) {
            int[] conn;
            Node n = (Node)en.getKey();
            for (int c : conn = (int[])en.getValue()) {
                Node cn = (Node)nodes.get(c);
                this.members.putEdge((Object)n, (Object)cn);
            }
        }
        compound.method_10569("FluidContent", this.fluidContent);
    }

    public void writeNbt(class_2487 compound) {
        ArrayList nodes = Lists.newArrayList((Iterable)this.members.nodes());
        class_2499 li = new class_2499();
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = (Node)nodes.get(i);
            class_2487 en = new class_2487();
            en.method_10566("Pos", (class_2520)NBTUtils.blockPosToList(n.pos));
            en.method_10582("Type", Ascii.toLowerCase((String)n.type.name()));
            IntArrayList conn = new IntArrayList();
            for (Node ne : this.members.adjacentNodes((Object)n)) {
                conn.add(nodes.indexOf(ne));
            }
            en.method_10566("Conn", (class_2520)new class_2495(conn.toIntArray()));
            li.add((Object)en);
        }
        compound.method_10566("Nodes", (class_2520)li);
        this.fluidContent = compound.method_10550("FluidContent");
        this.update();
    }

    public int getPressure() {
        return 0;
    }

    public static class Node {
        private final class_2338 pos;
        private final NodeType type;

        public Node(class_2338 pos, NodeType type) {
            this.pos = pos.method_10062();
            this.type = type;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public NodeType getType() {
            return this.type;
        }

        public String toString() {
            return this.type + "@" + this.pos.method_10263() + "," + this.pos.method_10264() + "," + this.pos.method_10260();
        }
    }

    public static enum NodeType {
        PIPE,
        FILTER,
        DEAD_FILTER,
        DSU,
        TANK;

    }
}

