/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.util.math.partitioner;

import com.google.common.collect.Lists;
import com.unascribed.yttr.util.math.partitioner.DEdge;
import com.unascribed.yttr.util.math.partitioner.Plane;
import com.unascribed.yttr.util.math.partitioner.Where;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_243;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Polygon
implements Iterable<DEdge> {
    private Plane supportPlane;
    private int nDEdges;
    private DEdge anchor;
    static DEdge useSrc = null;

    public Polygon copy() {
        DEdge first = null;
        DEdge last = null;
        for (DEdge de : this) {
            if (first == null) {
                first = last = new DEdge(de.sP);
                continue;
            }
            last = new DEdge(de.sP, last);
        }
        DEdge.closeCycle(first, last);
        return new Polygon(first, this.supportPlane);
    }

    public int nPoints() {
        return this.nDEdges;
    }

    public Plane plane() {
        return this.supportPlane;
    }

    public DEdge first() {
        return this.anchor;
    }

    public void forEachDEdge(Consumer<DEdge> cb) {
        DEdge last = null;
        for (DEdge d = this.first(); d != this.first() || last == null; d = d.next()) {
            cb.accept(d);
            last = d;
        }
    }

    public static void forEachDEdgeOfPoly(Polygon g, Consumer<DEdge> cb) {
        DEdge last = null;
        for (DEdge d = g.first(); d != g.first() || last == null; d = d.next()) {
            cb.accept(d);
            last = d;
        }
    }

    public Polygon(class_243 ... pts) {
        this(Arrays.asList(pts));
    }

    public Polygon(List<class_243> pts) {
        this.supportPlane = new Plane(pts);
        DEdge last = this.anchor = new DEdge(pts.get(0));
        for (int i = 1; i < pts.size(); ++i) {
            last = new DEdge(pts.get(i), last);
        }
        DEdge.closeCycle(this.anchor, last);
        this.nDEdges = pts.size();
    }

    public void split(Plane cut, DEdge d) {
        if (cut.sDistance(d.srcPoint()) * cut.sDistance(d.dstPoint()) >= 0.0) {
            throw new IllegalArgumentException();
        }
        class_243 onP = cut.onPoint(d.srcPoint(), d.dstPoint());
        d.split(onP);
        ++this.nDEdges;
    }

    public Where classifyPoints(final Plane cut, final List<DEdge> onDEdges) {
        if (this.first() == null) {
            return Where.NOWHERE;
        }
        this.first().srcWhere(cut.whichSide(this.first().srcPoint()));
        final Where[] polyW = new Where[]{this.first().srcWhere()};
        this.forEachDEdge(new Consumer<DEdge>(){

            @Override
            public void accept(DEdge d) {
                d.dstWhere(cut.whichSide(d.dstPoint()));
                polyW[0] = polyW[0].or(d.dstWhere());
                if (d.where() == Where.ABOVEBELOW) {
                    Polygon.this.split(cut, d);
                    d = d.next();
                    onDEdges.add(d);
                    d.srcWhere(Where.ON);
                } else if (d.srcWhere() == Where.ON) {
                    onDEdges.add(d);
                }
            }
        });
        return polyW[0];
    }

    public Polygon(DEdge start, Plane sPl) {
        this.supportPlane = sPl;
        this.anchor = start;
        this.nDEdges = 0;
        this.forEachDEdge(d -> {
            d.srcWhere(Where.NOWHERE);
            ++this.nDEdges;
        });
    }

    public void maximize(DEdge d) {
        DEdge dN = d.next();
        if (d.srcWhere() == Where.ON && dN.srcWhere() == Where.ON && dN.dstWhere() == Where.ON) {
            DEdge.closeCycle(dN.next(), d);
            this.anchor = d;
            --this.nDEdges;
        }
    }

    void addBridge(DEdge leftBelow, DEdge rghtAbove) {
        assert (leftBelow.srcWhere() == Where.ON);
        assert (rghtAbove.srcWhere() == Where.ON);
        assert (leftBelow != rghtAbove);
        DEdge leftAbove = leftBelow.prev();
        DEdge rghtBelow = rghtAbove.prev();
        DEdge onAbove = new DEdge(leftBelow.srcPoint(), leftAbove);
        DEdge onBelow = new DEdge(rghtAbove.srcPoint(), rghtBelow);
        DEdge.closeCycle(rghtAbove, onAbove);
        DEdge.closeCycle(leftBelow, onBelow);
        onAbove.srcWhere(onBelow.srcWhere(Where.ON));
        this.maximize(onAbove.prev());
        this.maximize(onBelow);
    }

    private static <T> void swap(List<T> li, int i, int j) {
        li.set(j, li.set(i, li.get(j)));
    }

    void sortDEdges(List<DEdge> onDs, class_243 cutDir) {
        int i;
        if (onDs.size() < 2) {
            return;
        }
        class_243 refP = onDs.get(0).srcPoint();
        for (i = 0; i < onDs.size(); ++i) {
            onDs.get(i).distFromRefP(cutDir.method_1026(onDs.get(i).srcPoint().method_1020(refP)));
        }
        for (i = onDs.size() - 1; i > 0; --i) {
            int j = 0;
            int k = 1;
            while (k <= i) {
                if (onDs.get(j).distFromRefP() > onDs.get(k).distFromRefP() || onDs.get(j).distFromRefP() == onDs.get(k).distFromRefP() && onDs.get(j).dstWhere() == Where.ABOVE) {
                    Polygon.swap(onDs, j, k);
                }
                j = k++;
            }
        }
    }

    static DEdge getSrcD(List<DEdge> onDs, int start) {
        if (useSrc != null) {
            DEdge gotIt = useSrc;
            useSrc = null;
            return gotIt;
        }
        while (start < onDs.size()) {
            Where prevW = onDs.get(start).prev().srcWhere();
            Where nextW = onDs.get(start).dstWhere();
            if (prevW == Where.ABOVE && nextW == Where.BELOW || prevW == Where.ABOVE && nextW == Where.ON && onDs.get(start).next().distFromRefP() < onDs.get(start).distFromRefP() || prevW == Where.ON && nextW == Where.BELOW && onDs.get(start).prev().distFromRefP() < onDs.get(start).distFromRefP()) {
                return onDs.get(start++);
            }
            ++start;
        }
        return null;
    }

    static DEdge getDstD(List<DEdge> onDs, int start) {
        while (start < onDs.size()) {
            Where prevW = onDs.get(start).prev().srcWhere();
            Where nextW = onDs.get(start).dstWhere();
            if (prevW == Where.BELOW && nextW == Where.ABOVE || prevW == Where.BELOW && nextW == Where.BELOW || prevW == Where.ABOVE && nextW == Where.ABOVE || prevW == Where.BELOW && nextW == Where.ON && onDs.get(start).distFromRefP() < onDs.get(start).next().distFromRefP() || prevW == Where.ON && nextW == Where.ABOVE && onDs.get(start).distFromRefP() < onDs.get(start).prev().distFromRefP()) {
                return onDs.get(start++);
            }
            ++start;
        }
        return null;
    }

    void complexCut(Plane cut, List<DEdge> onDs, List<Polygon> above, List<Polygon> below) {
        this.sortDEdges(onDs, cut.normal().method_1036(this.plane().normal()));
        int startOnD = 0;
        DEdge srcD = null;
        while ((srcD = Polygon.getSrcD(onDs, startOnD)) != null) {
            DEdge dstD = Polygon.getDstD(onDs, startOnD);
            assert (dstD != null);
            this.addBridge(srcD, dstD);
            if (srcD.prev().prev().srcWhere() == Where.ABOVE) {
                useSrc = srcD.prev();
                continue;
            }
            if (dstD.dstWhere() != Where.BELOW) continue;
            useSrc = dstD;
        }
        for (int i = 0; i < onDs.size(); ++i) {
            if (onDs.get(i).srcWhere() != Where.ON) continue;
            if (onDs.get(i).dstWhere() == Where.ABOVE) {
                above.add(new Polygon(onDs.get(i), this.plane()));
                continue;
            }
            if (onDs.get(i).dstWhere() != Where.BELOW) continue;
            below.add(new Polygon(onDs.get(i), this.plane()));
        }
    }

    public static void split(Polygon g, Plane cut, List<Polygon> above, List<Polygon> on, List<Polygon> below) {
        ArrayList onDEdges = Lists.newArrayListWithCapacity((int)g.nPoints());
        switch (g.classifyPoints(cut, onDEdges)) {
            case ONABOVE: 
            case ABOVE: {
                above.add(g);
                break;
            }
            case ON: {
                on.add(g);
                break;
            }
            case ONBELOW: 
            case BELOW: {
                on.add(g);
                break;
            }
            default: {
                g.complexCut(cut, onDEdges, above, below);
                g.anchor = null;
                g.nDEdges = 0;
            }
        }
        g = null;
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        this.forEachDEdge(de -> b.append((Object)de.srcPoint()));
        return b.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon that = (Polygon)obj;
        if (this.nDEdges != that.nDEdges) {
            return false;
        }
        ArrayList ours = Lists.newArrayList();
        ArrayList theirs = Lists.newArrayList();
        this.forEachDEdge(de -> ours.add(de.srcPoint()));
        that.forEachDEdge(de -> theirs.add(de.srcPoint()));
        return ours.equals(theirs);
    }

    public String toString() {
        ArrayList li = Lists.newArrayList();
        this.forEachDEdge(de -> li.add(de.srcPoint()));
        return ((Object)li).toString();
    }

    @Override
    public Iterator<DEdge> iterator() {
        return new Iterator<DEdge>(){
            DEdge first;
            DEdge last;
            DEdge cur;
            {
                this.first = Polygon.this.first();
                this.last = null;
                this.cur = Polygon.this.first();
            }

            @Override
            public boolean hasNext() {
                return this.cur != this.first || this.last == null;
            }

            @Override
            public DEdge next() {
                this.last = this.cur;
                this.cur = this.cur.next();
                return this.cur;
            }
        };
    }
}

