/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.util.math.partitioner;

import com.unascribed.yttr.util.math.partitioner.DEdge;
import com.unascribed.yttr.util.math.partitioner.Where;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_243;

public class Plane {
    private class_243 n;
    private double d;
    private double eps;

    public Plane(class_243 ... points) {
        this(Arrays.asList(points));
    }

    public Plane(Iterable<DEdge> edges) {
        this.n = new class_243(0.0, 0.0, 0.0);
        class_243 avrPnt = new class_243(0.0, 0.0, 0.0);
        int count = 0;
        for (DEdge de : edges) {
            avrPnt = avrPnt.method_1019(de.srcPoint());
            this.n = this.n.method_1019(de.srcPoint().method_1036(de.dstPoint()));
            ++count;
        }
        this.n = this.n.method_1029();
        this.d = this.normal().method_1026(avrPnt.method_1021(-1.0 / (double)count));
        for (DEdge de : edges) {
            this.updateEpsilon(de.srcPoint());
        }
    }

    public Plane(List<class_243> points) {
        int i;
        if (points.size() <= 2) {
            throw new IllegalArgumentException();
        }
        this.n = new class_243(0.0, 0.0, 0.0);
        class_243 avrPnt = new class_243(0.0, 0.0, 0.0);
        for (i = 0; i < points.size(); ++i) {
            avrPnt = avrPnt.method_1019(points.get(i));
            this.n = this.n.method_1019(points.get(i).method_1036(points.get((i + 1) % points.size())));
        }
        this.n = this.n.method_1029();
        this.d = this.normal().method_1026(avrPnt.method_1021(-1.0 / (double)points.size()));
        for (i = 0; i < points.size(); ++i) {
            this.updateEpsilon(points.get(i));
        }
    }

    class_243 onPoint(class_243 p, class_243 q) {
        class_243 v = q.method_1020(p);
        double c = this.normal().method_1026(v);
        if (c == 0.0) {
            throw new IllegalArgumentException();
        }
        double t = -this.sDistance(p) / c;
        return p.method_1019(v.method_1021(t));
    }

    void updateEpsilon(class_243 p) {
        double d = this.sDistance(p);
        if (d < 0.0) {
            d = -d;
        }
        if (d > this.eps) {
            this.eps = d;
        }
    }

    public Plane(class_243 v, double d) {
        this.n = v;
        this.d = d;
        this.eps = 0.0;
    }

    public Plane(class_243 v, double d, double eps) {
        this.n = v;
        this.d = d;
        this.eps = eps;
    }

    public Plane(Plane p) {
        this.n = p.n;
        this.d = p.d;
        this.eps = p.eps;
    }

    public class_243 normal() {
        return this.n;
    }

    public double distance() {
        return this.d;
    }

    public double epsilon() {
        return this.eps;
    }

    public double sDistance(class_243 p) {
        return p.method_1026(this.n) + this.d;
    }

    public Where whichSide(class_243 p) {
        double d = this.sDistance(p);
        return d < -this.eps ? Where.BELOW : (d > this.eps ? Where.ABOVE : Where.ON);
    }
}

