/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.util.math.colorthief;

import com.unascribed.yttr.util.math.colorthief.MMCQ;
import java.util.Arrays;
import net.minecraft.class_1011;

public class ColorThiefMC {
    private static final int DEFAULT_QUALITY = 10;
    private static final boolean DEFAULT_IGNORE_WHITE = true;

    public static int[] getColor(class_1011 sourceImage) {
        int[][] palette = ColorThiefMC.getPalette(sourceImage, 5);
        if (palette == null) {
            return null;
        }
        int[] dominantColor = palette[0];
        return dominantColor;
    }

    public static int[] getColor(class_1011 sourceImage, int quality, boolean ignoreWhite) {
        int[][] palette = ColorThiefMC.getPalette(sourceImage, 5, quality, ignoreWhite);
        if (palette == null) {
            return null;
        }
        int[] dominantColor = palette[0];
        return dominantColor;
    }

    public static int[][] getPalette(class_1011 sourceImage, int colorCount) {
        MMCQ.CMap cmap = ColorThiefMC.getColorMap(sourceImage, colorCount);
        if (cmap == null) {
            return null;
        }
        return cmap.palette();
    }

    public static int[][] getPalette(class_1011 sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        MMCQ.CMap cmap = ColorThiefMC.getColorMap(sourceImage, colorCount, quality, ignoreWhite);
        if (cmap == null) {
            return null;
        }
        return cmap.palette();
    }

    public static MMCQ.CMap getColorMap(class_1011 sourceImage, int colorCount) {
        return ColorThiefMC.getColorMap(sourceImage, colorCount, 10, true);
    }

    public static MMCQ.CMap getColorMap(class_1011 sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        if (colorCount < 2 || colorCount > 256) {
            throw new IllegalArgumentException("Specified colorCount must be between 2 and 256.");
        }
        if (quality < 1) {
            throw new IllegalArgumentException("Specified quality should be greater then 0.");
        }
        int[][] pixelArray = ColorThiefMC.getPixels(sourceImage, quality, ignoreWhite);
        MMCQ.CMap cmap = MMCQ.quantize(pixelArray, colorCount);
        return cmap;
    }

    private static int[][] getPixels(class_1011 sourceImage, int quality, boolean ignoreWhite) {
        int[] pixels = sourceImage.method_4322();
        int pixelCount = sourceImage.method_4307() * sourceImage.method_4323();
        int expectedDataLength = pixelCount;
        if (expectedDataLength != pixels.length) {
            throw new IllegalArgumentException("(expectedDataLength = " + expectedDataLength + ") != (pixels.length = " + pixels.length + ")");
        }
        int numRegardedPixels = (pixelCount + quality - 1) / quality;
        int numUsedPixels = 0;
        int[][] pixelArray = new int[numRegardedPixels][];
        for (int i = 0; i < pixelCount; i += quality) {
            int offset = i;
            int a = class_1011.method_24030((int)pixels[offset]);
            int b = class_1011.method_24035((int)pixels[offset]);
            int g = class_1011.method_24034((int)pixels[offset]);
            int r = class_1011.method_24033((int)pixels[offset]);
            if (a < 125 || ignoreWhite && r > 250 && g > 250 && b > 250) continue;
            pixelArray[numUsedPixels] = new int[]{r, g, b};
            ++numUsedPixels;
        }
        return (int[][])Arrays.copyOfRange(pixelArray, 0, numUsedPixels);
    }
}

