/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SantaList<T>
extends ArrayList<T> {
    private final List<StackTraceElement> who = new ArrayList<StackTraceElement>();

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.who.add(index, this.whodunit());
    }

    public StackTraceElement getBlame(int idx) {
        if (idx < 0 || idx >= this.who.size()) {
            return null;
        }
        return this.who.get(idx);
    }

    public void setBlame(int idx, StackTraceElement ste) {
        this.who.set(idx, ste);
    }

    private StackTraceElement whodunit() {
        for (StackTraceElement ste : new Throwable().getStackTrace()) {
            if (ste.getClassName().equals(SantaList.class.getName()) || ste.getClassName().startsWith("java.")) continue;
            if (ste.getMethodName().startsWith("handler$")) {
                String m = ste.getMethodName();
                m = m.substring(m.indexOf(36, 8) + 1);
                ste = new StackTraceElement(ste.getClassLoaderName(), "mixin", ste.getModuleVersion(), ste.getClassName(), m, ste.getFileName(), ste.getLineNumber());
            }
            return ste;
        }
        return new StackTraceElement("unknown", "unknown", null, -1);
    }

    @Override
    public boolean add(T e) {
        boolean worked = super.add(e);
        if (worked) {
            this.who.add(this.whodunit());
        }
        return worked;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    @Override
    public T set(int index, T element) {
        this.who.set(index, this.whodunit());
        return super.set(index, element);
    }
}

