/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.util;

import com.google.common.collect.Lists;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class DelayingChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final Timer TIMER = new HashedWheelTimer();
    private final int baseDelay;
    private final int extraDelay;
    private final List<Packet> packets = Lists.newArrayList();

    public DelayingChannelInboundHandler(int baseDelay, int extraDelay) {
        this.baseDelay = baseDelay;
        this.extraDelay = extraDelay;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        int delay = this.baseDelay + ThreadLocalRandom.current().nextInt(this.extraDelay);
        this.packets.add(new Packet(ctx, msg));
        TIMER.newTimeout(this::forward, (long)delay, TimeUnit.MILLISECONDS);
    }

    private void forward(Timeout timeout) {
        Packet packet = this.packets.remove(0);
        packet.context.fireChannelRead(packet.message);
    }

    private static final class Packet {
        public final ChannelHandlerContext context;
        public final Object message;

        public Packet(ChannelHandlerContext context, Object message) {
            this.context = context;
            this.message = message;
        }
    }
}

