/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.repackage.ibxm2;

import com.unascribed.yttr.repackage.ibxm2.Module;
import com.unascribed.yttr.repackage.ibxm2.Note;
import com.unascribed.yttr.repackage.ibxm2.Pattern;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;

public class PatternDisplay
extends Canvas {
    public static final int CHANNEL_WIDTH = 88;
    private int pan;
    private int channels = 0;
    private Image charset;
    private Image image;
    private boolean[] muted;
    private short[][] buffer;
    private int[] fxclr = new int[]{1, 1, 1, 1, 1, 7, 7, 5, 5, 4, 0, 0, 0, 0, 0, 0, 0, 5, 6, 5, 6, 0, 6, 5, 5, 0, 0, 0, 4, 0, 0, 0, 5, 0, 4, 0, 5, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 5, 1, 1, 1, 1, 5, 1, 7, 7, 0, 0, 4, 0, 4, 5, 0, 6, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] exclr = new int[]{0, 1, 1, 1, 1, 1, 6, 5, 0, 4, 0, 0, 0, 0, 0, 0, 0, 5, 5, 4, 4, 4, 4};
    private int[] sxclr = new int[]{5, 4, 1, 1, 5, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 4, 4, 4, 4};
    private int[] vcclr = new int[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 1, 1, 5, 5, 5, 1};

    private synchronized void drawBuffer(int x0, int y0, int x1, int y1) {
        int cols = this.getBufferWidth();
        int rows = this.getBufferHeight();
        if (this.charset == null) {
            this.initCharset();
        }
        if (this.image == null) {
            this.image = this.createImage(cols * 8, rows * 16);
        }
        if (x0 < cols && y0 < rows) {
            if (x0 < 0) {
                x0 = 0;
            }
            if (y0 < 0) {
                y0 = 0;
            }
            if (x1 > cols) {
                x1 = cols;
            }
            if (y1 > rows) {
                y1 = rows;
            }
            Graphics gfx = this.image.getGraphics();
            if (this.buffer == null) {
                gfx.setColor(Color.BLACK);
                gfx.fillRect(x0, y0, x1 * 8, y1 * 16);
            } else {
                for (int y = y0; y < y1; ++y) {
                    for (int x = x0; x < x1; ++x) {
                        short chr = this.buffer[y][x];
                        gfx.setClip(x * 8, y * 16, 8, 16);
                        gfx.drawImage(this.charset, (x - (chr & 0xFF) + 32) * 8, (y - (chr >> 8)) * 16, this);
                    }
                }
            }
            gfx.dispose();
        }
    }

    @Override
    public void paint(Graphics g) {
        int cw = this.getWidth();
        int ch = this.getHeight();
        int bw = this.getBufferWidth() * 8;
        int bh = this.getBufferHeight() * 16;
        this.drawBuffer(this.pan / 8, 0, (this.pan + cw) / 8, ch / 16);
        g.drawImage(this.image, -this.pan, 0, this);
        g.setColor(Color.BLACK);
        if (cw > bw - this.pan) {
            g.fillRect(bw - this.pan, 0, cw - bw + this.pan, bh);
        }
        if (ch > bh) {
            g.fillRect(0, bh, cw, ch - bh);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getBufferWidth() * 8, this.getBufferHeight() * 16);
    }

    private int getBufferWidth() {
        return this.channels * 11 + 4;
    }

    private int getBufferHeight() {
        return 16;
    }

    public void setPan(int x) {
        this.pan = x;
        this.repaint();
    }

    public int getChannel(int x) {
        x = x - 32 + this.pan;
        int channel = x / 88;
        if (x < 0 || channel >= this.channels) {
            channel = -1;
        }
        return channel;
    }

    public void setMuted(int channel, boolean mute) {
        if (channel < 0) {
            for (int idx = 0; idx < this.channels; ++idx) {
                this.muted[idx] = mute;
            }
        } else if (channel < this.channels) {
            this.muted[channel] = mute;
        }
    }

    public boolean isMuted(int channel) {
        return this.muted[channel];
    }

    public synchronized void display(Module module, int pat, int row) {
        Pattern pattern = module.patterns[pat];
        if (this.buffer == null || module.numChannels != this.channels) {
            this.channels = module.numChannels;
            this.muted = new boolean[this.channels];
            this.buffer = new short[this.getBufferHeight()][this.getBufferWidth()];
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
        }
        this.drawInt(pat, 0, 0, 3, 3);
        this.drawChar(32, 0, 3, 0);
        for (int c = 0; c < this.channels; ++c) {
            if (this.muted[c]) {
                this.drawString(" Muted  ", 0, c * 11 + 4, 3);
                this.drawInt(c, 0, c * 11 + 12, 3, 2);
            } else {
                this.drawString("Channel ", 0, c * 11 + 4, 0);
                this.drawInt(c, 0, c * 11 + 12, 0, 2);
            }
            this.drawString(" ", 0, c * 11 + 14, 0);
        }
        Note note = new Note();
        char[] chars = new char[10];
        for (int y = 1; y < 16; ++y) {
            int r = row - 8 + y;
            if (r >= 0 && r < pattern.numRows) {
                int bcol = y == 8 ? 8 : 0;
                this.drawInt(r, y, 0, bcol, 3);
                this.drawChar(32, y, 3, bcol);
                for (int c = 0; c < this.channels; ++c) {
                    int x = 4 + c * 11;
                    pattern.getNote(r * module.numChannels + c, note).toChars(chars);
                    if (this.muted[c]) {
                        for (int idx = 0; idx < 10; ++idx) {
                            this.drawChar(chars[idx], y, x + idx, bcol);
                        }
                    } else {
                        int idx;
                        int clr = chars[0] == '-' ? bcol : bcol + 2;
                        for (idx = 0; idx < 3; ++idx) {
                            this.drawChar(chars[idx], y, x + idx, clr);
                        }
                        for (idx = 3; idx < 5; ++idx) {
                            clr = chars[idx] == '-' ? bcol : bcol + 3;
                            this.drawChar(chars[idx], y, x + idx, clr);
                        }
                        clr = bcol;
                        if (chars[5] >= '0' && chars[5] <= 'F') {
                            clr = bcol + this.vcclr[chars[5] - 48];
                        }
                        this.drawChar(chars[5], y, x + 5, clr);
                        this.drawChar(chars[6], y, x + 6, clr);
                        if (chars[7] == 'E') {
                            clr = bcol;
                            if (chars[8] >= '0' && chars[8] <= 'F') {
                                clr += this.exclr[chars[8] - 48];
                            }
                        } else if (chars[7] == 's') {
                            clr = bcol;
                            if (chars[8] >= '0' && chars[8] <= 'F') {
                                clr += this.sxclr[chars[8] - 48];
                            }
                        } else {
                            clr = bcol;
                            if (chars[7] >= '0' && chars[7] <= '~') {
                                clr += this.fxclr[chars[7] - 48];
                            }
                        }
                        if (chars[7] >= 'a') {
                            chars[7] = (char)(chars[7] - 32);
                        }
                        for (idx = 7; idx < 10; ++idx) {
                            this.drawChar(chars[idx], y, x + idx, clr);
                        }
                    }
                    this.drawChar(32, y, x + 10, 0);
                }
                continue;
            }
            this.drawString("    ", y, 0, 0);
            for (int c = 0; c < this.channels; ++c) {
                this.drawString("           ", y, 4 + c * 11, 0);
            }
        }
        this.repaint();
    }

    private void drawInt(int val, int row, int col, int clr, int len) {
        while (len > 0) {
            this.drawChar(48 + val % 10, row, col + --len, clr);
            val /= 10;
        }
    }

    private void drawString(String str, int row, int col, int clr) {
        int len = str.length();
        for (int idx = 0; idx < len; ++idx) {
            this.drawChar(str.charAt(idx), row, col + idx, clr);
        }
    }

    private void drawChar(int chr, int row, int col, int clr) {
        this.buffer[row][col] = (short)(clr << 8 | chr);
    }

    private void initCharset() {
        int[] pal = new int[]{192, 32768, 32896, 0x800000, 0x800080, 0x806000, 0x808080, 0x608000, 24831, 65280, 65535, 0xFF0000, 0xFF00FF, 0xFFC000, 0xFFFFFF, 0xC0FF00};
        URL png = PatternDisplay.class.getResource("topaz8.png");
        Image mask = Toolkit.getDefaultToolkit().getImage(png);
        this.charset = this.createImage(768, 16 * pal.length);
        Graphics g = this.charset.getGraphics();
        for (int r = 0; r < pal.length; ++r) {
            g.setColor(Color.BLACK);
            g.setClip(0, r * 16, 8, 16);
            g.fillRect(0, r * 16, 8, 16);
            Color clr = new Color(pal[r]);
            for (int c = 1; c < 96; ++c) {
                g.setClip(c * 8, r * 16, 8, 16);
                int x = c - (c - 1 & 0x1F);
                int y = r - (c - 1 >> 5);
                while (!g.drawImage(mask, x * 8, y * 16, clr, null)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        g.dispose();
    }
}

