/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.repackage.ibxm2;

import com.unascribed.yttr.repackage.ibxm2.GlobalVol;
import com.unascribed.yttr.repackage.ibxm2.Instrument;
import com.unascribed.yttr.repackage.ibxm2.Module;
import com.unascribed.yttr.repackage.ibxm2.Note;
import com.unascribed.yttr.repackage.ibxm2.Sample;

public class Channel {
    public static final int NEAREST = 0;
    public static final int LINEAR = 1;
    public static final int SINC = 2;
    private static int[] exp2Table = new int[]{32768, 32946, 33125, 33305, 33486, 33667, 33850, 34034, 34219, 34405, 34591, 34779, 34968, 35158, 35349, 35541, 35734, 35928, 36123, 36319, 36516, 36715, 36914, 37114, 37316, 37518, 37722, 37927, 38133, 38340, 38548, 38757, 38968, 39180, 39392, 39606, 39821, 40037, 40255, 40473, 40693, 40914, 41136, 41360, 41584, 41810, 42037, 42265, 42495, 42726, 42958, 43191, 43425, 43661, 43898, 44137, 44376, 44617, 44859, 45103, 45348, 45594, 45842, 46091, 46341, 46593, 46846, 47100, 47356, 47613, 47871, 48131, 48393, 48655, 48920, 49185, 49452, 49721, 49991, 50262, 50535, 50810, 51085, 51363, 51642, 51922, 52204, 52488, 52773, 53059, 53347, 53637, 53928, 54221, 54515, 54811, 55109, 55408, 55709, 56012, 56316, 56622, 56929, 57238, 57549, 57861, 58176, 58491, 58809, 59128, 59449, 59772, 60097, 60423, 60751, 61081, 61413, 61746, 62081, 62419, 62757, 63098, 63441, 63785, 64132, 64480, 64830, 65182, 65536};
    private static final short[] sineTable = new short[]{0, 24, 49, 74, 97, 120, 141, 161, 180, 197, 212, 224, 235, 244, 250, 253, 255, 253, 250, 244, 235, 224, 212, 197, 180, 161, 141, 120, 97, 74, 49, 24};
    private Module module;
    private GlobalVol globalVol;
    private Instrument instrument;
    private Sample sample;
    private boolean keyOn;
    private int noteKey;
    private int noteIns;
    private int noteVol;
    private int noteEffect;
    private int noteParam;
    private int sampleOffset;
    private int sampleIdx;
    private int sampleFra;
    private int freq;
    private int ampl;
    private int pann;
    private int volume;
    private int panning;
    private int fadeOutVol;
    private int volEnvTick;
    private int panEnvTick;
    private int period;
    private int portaPeriod;
    private int retrigCount;
    private int fxCount;
    private int autoVibratoCount;
    private int portaUpParam;
    private int portaDownParam;
    private int tonePortaParam;
    private int offsetParam;
    private int finePortaUpParam;
    private int finePortaDownParam;
    private int extraFinePortaParam;
    private int arpeggioParam;
    private int vslideParam;
    private int globalVslideParam;
    private int panningSlideParam;
    private int fineVslideUpParam;
    private int fineVslideDownParam;
    private int retrigVolume;
    private int retrigTicks;
    private int tremorOnTicks;
    private int tremorOffTicks;
    private int vibratoType;
    private int vibratoPhase;
    private int vibratoSpeed;
    private int vibratoDepth;
    private int tremoloType;
    private int tremoloPhase;
    private int tremoloSpeed;
    private int tremoloDepth;
    private int tremoloAdd;
    private int vibratoAdd;
    private int arpeggioAdd;
    private int id;
    private int randomSeed;
    public int plRow;

    public Channel(Module module, int id, GlobalVol globalVol) {
        this.module = module;
        this.id = id;
        this.globalVol = globalVol;
        this.panning = module.defaultPanning[id];
        this.instrument = new Instrument();
        this.sample = this.instrument.samples[0];
        this.randomSeed = (id + 1) * 11259375;
    }

    public void resample(int[] outBuf, int offset, int length, int sampleRate, int interpolation) {
        if (this.ampl <= 0) {
            return;
        }
        int lAmpl = this.ampl * (255 - this.pann) >> 8;
        int rAmpl = this.ampl * this.pann >> 8;
        int step = (this.freq << 12) / (sampleRate >> 3);
        switch (interpolation) {
            case 0: {
                this.sample.resampleNearest(this.sampleIdx, this.sampleFra, step, lAmpl, rAmpl, outBuf, offset, length);
                break;
            }
            default: {
                this.sample.resampleLinear(this.sampleIdx, this.sampleFra, step, lAmpl, rAmpl, outBuf, offset, length);
                break;
            }
            case 2: {
                this.sample.resampleSinc(this.sampleIdx, this.sampleFra, step, lAmpl, rAmpl, outBuf, offset, length);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void updateSampleIdx(int length, int sampleRate) {
        int step = (this.freq << 12) / (sampleRate >> 3);
        this.sampleFra += step * length;
        this.sampleIdx = this.sample.normaliseSampleIdx(this.sampleIdx + (this.sampleFra >> 15));
        this.sampleFra &= Short.MAX_VALUE;
    }

    public void row(Note note) {
        this.noteKey = note.key;
        this.noteIns = note.instrument;
        this.noteVol = note.volume;
        this.noteEffect = note.effect;
        this.noteParam = note.param;
        ++this.retrigCount;
        this.fxCount = 0;
        this.arpeggioAdd = 0;
        this.tremoloAdd = 0;
        this.vibratoAdd = 0;
        if (this.noteEffect != 125 && this.noteEffect != 253 || this.noteParam <= 0) {
            this.trigger();
        }
        switch (this.noteEffect) {
            case 1: 
            case 134: {
                if (this.noteParam > 0) {
                    this.portaUpParam = this.noteParam;
                }
                this.portamentoUp(this.portaUpParam);
                break;
            }
            case 2: 
            case 133: {
                if (this.noteParam > 0) {
                    this.portaDownParam = this.noteParam;
                }
                this.portamentoDown(this.portaDownParam);
                break;
            }
            case 3: 
            case 135: {
                if (this.noteParam <= 0) break;
                this.tonePortaParam = this.noteParam;
                break;
            }
            case 4: 
            case 136: {
                if (this.noteParam >> 4 > 0) {
                    this.vibratoSpeed = this.noteParam >> 4;
                }
                if ((this.noteParam & 0xF) > 0) {
                    this.vibratoDepth = this.noteParam & 0xF;
                }
                this.vibrato(false);
                break;
            }
            case 5: 
            case 140: {
                if (this.noteParam > 0) {
                    this.vslideParam = this.noteParam;
                }
                this.volumeSlide();
                break;
            }
            case 6: 
            case 139: {
                if (this.noteParam > 0) {
                    this.vslideParam = this.noteParam;
                }
                this.vibrato(false);
                this.volumeSlide();
                break;
            }
            case 7: 
            case 146: {
                if (this.noteParam >> 4 > 0) {
                    this.tremoloSpeed = this.noteParam >> 4;
                }
                if ((this.noteParam & 0xF) > 0) {
                    this.tremoloDepth = this.noteParam & 0xF;
                }
                this.tremolo();
                break;
            }
            case 8: {
                this.panning = this.noteParam & 0xFF;
                break;
            }
            case 10: 
            case 132: {
                if (this.noteParam > 0) {
                    this.vslideParam = this.noteParam;
                }
                this.volumeSlide();
                break;
            }
            case 12: {
                this.volume = this.noteParam >= 64 ? 64 : this.noteParam & 0x3F;
                break;
            }
            case 16: 
            case 150: {
                this.globalVol.volume = this.noteParam >= 64 ? 64 : this.noteParam & 0x3F;
                break;
            }
            case 17: {
                if (this.noteParam <= 0) break;
                this.globalVslideParam = this.noteParam;
                break;
            }
            case 20: {
                this.keyOn = false;
                break;
            }
            case 21: {
                this.volEnvTick = this.panEnvTick = this.noteParam & 0xFF;
                break;
            }
            case 25: {
                if (this.noteParam <= 0) break;
                this.panningSlideParam = this.noteParam;
                break;
            }
            case 27: 
            case 145: {
                if (this.noteParam >> 4 > 0) {
                    this.retrigVolume = this.noteParam >> 4;
                }
                if ((this.noteParam & 0xF) > 0) {
                    this.retrigTicks = this.noteParam & 0xF;
                }
                this.retrigVolSlide();
                break;
            }
            case 29: 
            case 137: {
                if (this.noteParam >> 4 > 0) {
                    this.tremorOnTicks = this.noteParam >> 4;
                }
                if ((this.noteParam & 0xF) > 0) {
                    this.tremorOffTicks = this.noteParam & 0xF;
                }
                this.tremor();
                break;
            }
            case 33: {
                if (this.noteParam > 0) {
                    this.extraFinePortaParam = this.noteParam;
                }
                switch (this.extraFinePortaParam & 0xF0) {
                    case 16: {
                        this.portamentoUp(0xE0 | this.extraFinePortaParam & 0xF);
                        break;
                    }
                    case 32: {
                        this.portamentoDown(0xE0 | this.extraFinePortaParam & 0xF);
                    }
                }
                break;
            }
            case 113: {
                if (this.noteParam > 0) {
                    this.finePortaUpParam = this.noteParam;
                }
                this.portamentoUp(0xF0 | this.finePortaUpParam & 0xF);
                break;
            }
            case 114: {
                if (this.noteParam > 0) {
                    this.finePortaDownParam = this.noteParam;
                }
                this.portamentoDown(0xF0 | this.finePortaDownParam & 0xF);
                break;
            }
            case 116: 
            case 243: {
                if (this.noteParam >= 8) break;
                this.vibratoType = this.noteParam;
                break;
            }
            case 119: 
            case 244: {
                if (this.noteParam >= 8) break;
                this.tremoloType = this.noteParam;
                break;
            }
            case 122: {
                if (this.noteParam > 0) {
                    this.fineVslideUpParam = this.noteParam;
                }
                this.volume += this.fineVslideUpParam;
                if (this.volume <= 64) break;
                this.volume = 64;
                break;
            }
            case 123: {
                if (this.noteParam > 0) {
                    this.fineVslideDownParam = this.noteParam;
                }
                this.volume -= this.fineVslideDownParam;
                if (this.volume >= 0) break;
                this.volume = 0;
                break;
            }
            case 124: 
            case 252: {
                if (this.noteParam > 0) break;
                this.volume = 0;
                break;
            }
            case 138: {
                if (this.noteParam <= 0) break;
                this.arpeggioParam = this.noteParam;
                break;
            }
            case 149: {
                if (this.noteParam >> 4 > 0) {
                    this.vibratoSpeed = this.noteParam >> 4;
                }
                if ((this.noteParam & 0xF) > 0) {
                    this.vibratoDepth = this.noteParam & 0xF;
                }
                this.vibrato(true);
                break;
            }
            case 248: {
                this.panning = this.noteParam * 17;
            }
        }
        this.autoVibrato();
        this.calculateFrequency();
        this.calculateAmplitude();
        this.updateEnvelopes();
    }

    public void tick() {
        this.vibratoAdd = 0;
        ++this.fxCount;
        ++this.retrigCount;
        if (this.noteEffect != 125 || this.fxCount > this.noteParam) {
            switch (this.noteVol & 0xF0) {
                case 96: {
                    this.volume -= this.noteVol & 0xF;
                    if (this.volume >= 0) break;
                    this.volume = 0;
                    break;
                }
                case 112: {
                    this.volume += this.noteVol & 0xF;
                    if (this.volume <= 64) break;
                    this.volume = 64;
                    break;
                }
                case 176: {
                    this.vibratoPhase += this.vibratoSpeed;
                    this.vibrato(false);
                    break;
                }
                case 208: {
                    this.panning -= this.noteVol & 0xF;
                    if (this.panning >= 0) break;
                    this.panning = 0;
                    break;
                }
                case 224: {
                    this.panning += this.noteVol & 0xF;
                    if (this.panning <= 255) break;
                    this.panning = 255;
                    break;
                }
                case 240: {
                    this.tonePortamento();
                }
            }
        }
        switch (this.noteEffect) {
            case 1: 
            case 134: {
                this.portamentoUp(this.portaUpParam);
                break;
            }
            case 2: 
            case 133: {
                this.portamentoDown(this.portaDownParam);
                break;
            }
            case 3: 
            case 135: {
                this.tonePortamento();
                break;
            }
            case 4: 
            case 136: {
                this.vibratoPhase += this.vibratoSpeed;
                this.vibrato(false);
                break;
            }
            case 5: 
            case 140: {
                this.tonePortamento();
                this.volumeSlide();
                break;
            }
            case 6: 
            case 139: {
                this.vibratoPhase += this.vibratoSpeed;
                this.vibrato(false);
                this.volumeSlide();
                break;
            }
            case 7: 
            case 146: {
                this.tremoloPhase += this.tremoloSpeed;
                this.tremolo();
                break;
            }
            case 10: 
            case 132: {
                this.volumeSlide();
                break;
            }
            case 17: {
                this.globalVol.volume += (this.globalVslideParam >> 4) - (this.globalVslideParam & 0xF);
                if (this.globalVol.volume < 0) {
                    this.globalVol.volume = 0;
                }
                if (this.globalVol.volume <= 64) break;
                this.globalVol.volume = 64;
                break;
            }
            case 25: {
                this.panning += (this.panningSlideParam >> 4) - (this.panningSlideParam & 0xF);
                if (this.panning < 0) {
                    this.panning = 0;
                }
                if (this.panning <= 255) break;
                this.panning = 255;
                break;
            }
            case 27: 
            case 145: {
                this.retrigVolSlide();
                break;
            }
            case 29: 
            case 137: {
                this.tremor();
                break;
            }
            case 121: {
                if (this.fxCount < this.noteParam) break;
                this.fxCount = 0;
                this.sampleFra = 0;
                this.sampleIdx = 0;
                break;
            }
            case 124: 
            case 252: {
                if (this.noteParam != this.fxCount) break;
                this.volume = 0;
                break;
            }
            case 125: 
            case 253: {
                if (this.noteParam != this.fxCount) break;
                this.trigger();
                break;
            }
            case 138: {
                if (this.fxCount > 2) {
                    this.fxCount = 0;
                }
                if (this.fxCount == 0) {
                    this.arpeggioAdd = 0;
                }
                if (this.fxCount == 1) {
                    this.arpeggioAdd = this.arpeggioParam >> 4;
                }
                if (this.fxCount != 2) break;
                this.arpeggioAdd = this.arpeggioParam & 0xF;
                break;
            }
            case 149: {
                this.vibratoPhase += this.vibratoSpeed;
                this.vibrato(true);
            }
        }
        this.autoVibrato();
        this.calculateFrequency();
        this.calculateAmplitude();
        this.updateEnvelopes();
    }

    private void updateEnvelopes() {
        if (this.instrument.volumeEnvelope.enabled) {
            if (!this.keyOn) {
                this.fadeOutVol -= this.instrument.volumeFadeOut;
                if (this.fadeOutVol < 0) {
                    this.fadeOutVol = 0;
                }
            }
            this.volEnvTick = this.instrument.volumeEnvelope.nextTick(this.volEnvTick, this.keyOn);
        }
        if (this.instrument.panningEnvelope.enabled) {
            this.panEnvTick = this.instrument.panningEnvelope.nextTick(this.panEnvTick, this.keyOn);
        }
    }

    private void autoVibrato() {
        int depth = this.instrument.vibratoDepth & 0x7F;
        if (depth > 0) {
            int sweep = this.instrument.vibratoSweep & 0x7F;
            int rate = this.instrument.vibratoRate & 0x7F;
            int type = this.instrument.vibratoType;
            if (this.autoVibratoCount < sweep) {
                depth = depth * this.autoVibratoCount / sweep;
            }
            this.vibratoAdd += this.waveform(this.autoVibratoCount * rate >> 2, type + 4) * depth >> 8;
            ++this.autoVibratoCount;
        }
    }

    private void volumeSlide() {
        int up = this.vslideParam >> 4;
        int down = this.vslideParam & 0xF;
        if (down == 15 && up > 0) {
            if (this.fxCount == 0) {
                this.volume += up;
            }
        } else if (up == 15 && down > 0) {
            if (this.fxCount == 0) {
                this.volume -= down;
            }
        } else if (this.fxCount > 0 || this.module.fastVolSlides) {
            this.volume += up - down;
        }
        if (this.volume > 64) {
            this.volume = 64;
        }
        if (this.volume < 0) {
            this.volume = 0;
        }
    }

    private void portamentoUp(int param) {
        switch (param & 0xF0) {
            case 224: {
                if (this.fxCount != 0) break;
                this.period -= param & 0xF;
                break;
            }
            case 240: {
                if (this.fxCount != 0) break;
                this.period -= (param & 0xF) << 2;
                break;
            }
            default: {
                if (this.fxCount <= 0) break;
                this.period -= param << 2;
            }
        }
        if (this.period < 0) {
            this.period = 0;
        }
    }

    private void portamentoDown(int param) {
        if (this.period > 0) {
            switch (param & 0xF0) {
                case 224: {
                    if (this.fxCount != 0) break;
                    this.period += param & 0xF;
                    break;
                }
                case 240: {
                    if (this.fxCount != 0) break;
                    this.period += (param & 0xF) << 2;
                    break;
                }
                default: {
                    if (this.fxCount <= 0) break;
                    this.period += param << 2;
                }
            }
            if (this.period > 65535) {
                this.period = 65535;
            }
        }
    }

    private void tonePortamento() {
        if (this.period > 0) {
            if (this.period < this.portaPeriod) {
                this.period += this.tonePortaParam << 2;
                if (this.period > this.portaPeriod) {
                    this.period = this.portaPeriod;
                }
            } else {
                this.period -= this.tonePortaParam << 2;
                if (this.period < this.portaPeriod) {
                    this.period = this.portaPeriod;
                }
            }
        }
    }

    private void vibrato(boolean fine) {
        this.vibratoAdd = this.waveform(this.vibratoPhase, this.vibratoType & 3) * this.vibratoDepth >> (fine ? 7 : 5);
    }

    private void tremolo() {
        this.tremoloAdd = this.waveform(this.tremoloPhase, this.tremoloType & 3) * this.tremoloDepth >> 6;
    }

    private int waveform(int phase, int type) {
        int amplitude = 0;
        switch (type) {
            default: {
                amplitude = sineTable[phase & 0x1F];
                if ((phase & 0x20) <= 0) break;
                amplitude = -amplitude;
                break;
            }
            case 6: {
                amplitude = ((phase + 32 & 0x3F) << 3) - 255;
                break;
            }
            case 1: 
            case 7: {
                amplitude = 255 - ((phase + 32 & 0x3F) << 3);
                break;
            }
            case 2: 
            case 5: {
                amplitude = (phase & 0x20) > 0 ? 255 : -255;
                break;
            }
            case 3: 
            case 8: {
                amplitude = (this.randomSeed >> 20) - 255;
                this.randomSeed = this.randomSeed * 65 + 17 & 0x1FFFFFFF;
            }
        }
        return amplitude;
    }

    private void tremor() {
        if (this.retrigCount >= this.tremorOnTicks) {
            this.tremoloAdd = -64;
        }
        if (this.retrigCount >= this.tremorOnTicks + this.tremorOffTicks) {
            this.retrigCount = 0;
            this.tremoloAdd = 0;
        }
    }

    private void retrigVolSlide() {
        if (this.retrigCount >= this.retrigTicks) {
            this.sampleFra = 0;
            this.sampleIdx = 0;
            this.retrigCount = 0;
            switch (this.retrigVolume) {
                case 1: {
                    --this.volume;
                    break;
                }
                case 2: {
                    this.volume -= 2;
                    break;
                }
                case 3: {
                    this.volume -= 4;
                    break;
                }
                case 4: {
                    this.volume -= 8;
                    break;
                }
                case 5: {
                    this.volume -= 16;
                    break;
                }
                case 6: {
                    this.volume = this.volume * 2 / 3;
                    break;
                }
                case 7: {
                    this.volume >>= 1;
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    ++this.volume;
                    break;
                }
                case 10: {
                    this.volume += 2;
                    break;
                }
                case 11: {
                    this.volume += 4;
                    break;
                }
                case 12: {
                    this.volume += 8;
                    break;
                }
                case 13: {
                    this.volume += 16;
                    break;
                }
                case 14: {
                    this.volume = this.volume * 3 / 2;
                    break;
                }
                case 15: {
                    this.volume <<= 1;
                }
            }
            if (this.volume < 0) {
                this.volume = 0;
            }
            if (this.volume > 64) {
                this.volume = 64;
            }
        }
    }

    private void calculateFrequency() {
        int per = this.period + this.vibratoAdd;
        if (this.module.linearPeriods) {
            if ((per -= this.arpeggioAdd << 6) < 28 || per > 7680) {
                per = 7680;
            }
            this.freq = (this.module.c2Rate >> 4) * Channel.exp2((4608 - per << 15) / 768) >> 11;
        } else {
            if (per > 29021) {
                per = 29021;
            }
            if ((per = (per << 15) / Channel.exp2((this.arpeggioAdd << 15) / 12)) < 28) {
                per = 29021;
            }
            this.freq = this.module.c2Rate * 1712 / per;
        }
    }

    private void calculateAmplitude() {
        int vol;
        int envVol;
        int n = envVol = this.keyOn ? 64 : 0;
        if (this.instrument.volumeEnvelope.enabled) {
            envVol = this.instrument.volumeEnvelope.calculateAmpl(this.volEnvTick);
        }
        if ((vol = this.volume + this.tremoloAdd) > 64) {
            vol = 64;
        }
        if (vol < 0) {
            vol = 0;
        }
        vol = vol * this.module.gain * 32768 >> 13;
        vol = vol * this.fadeOutVol >> 15;
        this.ampl = vol * this.globalVol.volume * envVol >> 12;
        int envPan = 32;
        if (this.instrument.panningEnvelope.enabled) {
            envPan = this.instrument.panningEnvelope.calculateAmpl(this.panEnvTick);
        }
        int panRange = this.panning < 128 ? this.panning : 255 - this.panning;
        this.pann = this.panning + (panRange * (envPan - 32) >> 5);
    }

    private void trigger() {
        if (this.noteIns > 0 && this.noteIns <= this.module.numInstruments) {
            this.instrument = this.module.instruments[this.noteIns];
            Sample sam = this.instrument.samples[this.instrument.keyToSample[this.noteKey < 97 ? this.noteKey : 0]];
            int n = this.volume = sam.volume >= 64 ? 64 : sam.volume & 0x3F;
            if (sam.panning >= 0) {
                this.panning = sam.panning & 0xFF;
            }
            if (this.period > 0 && sam.looped()) {
                this.sample = sam;
            }
            this.panEnvTick = 0;
            this.volEnvTick = 0;
            this.sampleOffset = 0;
            this.fadeOutVol = 32768;
            this.keyOn = true;
        }
        if (this.noteEffect == 9 || this.noteEffect == 143) {
            if (this.noteParam > 0) {
                this.offsetParam = this.noteParam;
            }
            this.sampleOffset = this.offsetParam << 8;
        }
        if (this.noteVol >= 16 && this.noteVol < 96) {
            this.volume = this.noteVol < 80 ? this.noteVol - 16 : 64;
        }
        switch (this.noteVol & 0xF0) {
            case 128: {
                this.volume -= this.noteVol & 0xF;
                if (this.volume >= 0) break;
                this.volume = 0;
                break;
            }
            case 144: {
                this.volume += this.noteVol & 0xF;
                if (this.volume <= 64) break;
                this.volume = 64;
                break;
            }
            case 160: {
                if ((this.noteVol & 0xF) <= 0) break;
                this.vibratoSpeed = this.noteVol & 0xF;
                break;
            }
            case 176: {
                if ((this.noteVol & 0xF) > 0) {
                    this.vibratoDepth = this.noteVol & 0xF;
                }
                this.vibrato(false);
                break;
            }
            case 192: {
                this.panning = (this.noteVol & 0xF) * 17;
                break;
            }
            case 240: {
                if ((this.noteVol & 0xF) <= 0) break;
                this.tonePortaParam = this.noteVol & 0xF;
            }
        }
        if (this.noteKey > 0) {
            if (this.noteKey > 96) {
                this.keyOn = false;
            } else {
                int key;
                boolean isPorta;
                boolean bl = isPorta = (this.noteVol & 0xF0) == 240 || this.noteEffect == 3 || this.noteEffect == 5 || this.noteEffect == 135 || this.noteEffect == 140;
                if (!isPorta) {
                    this.sample = this.instrument.samples[this.instrument.keyToSample[this.noteKey]];
                }
                int fineTune = this.sample.fineTune;
                if (this.noteEffect == 117 || this.noteEffect == 242) {
                    fineTune = ((this.noteParam & 0xF) << 4) - 128;
                }
                if ((key = this.noteKey + this.sample.relNote) < 1) {
                    key = 1;
                }
                if (key > 120) {
                    key = 120;
                }
                int per = (key << 6) + (fineTune >> 1);
                this.portaPeriod = this.module.linearPeriods ? 7744 - per : 29021 * Channel.exp2((per << 15) / -768) >> 15;
                if (!isPorta) {
                    this.period = this.portaPeriod;
                    this.sampleIdx = this.sampleOffset;
                    this.sampleFra = 0;
                    if (this.vibratoType < 4) {
                        this.vibratoPhase = 0;
                    }
                    if (this.tremoloType < 4) {
                        this.tremoloPhase = 0;
                    }
                    this.autoVibratoCount = 0;
                    this.retrigCount = 0;
                }
            }
        }
    }

    public static int exp2(int x) {
        int x0 = (x & Short.MAX_VALUE) >> 8;
        int c = exp2Table[x0];
        int m = exp2Table[x0 + 1] - c;
        int y = (m * (x & 0xFF) >> 8) + c;
        return y << 15 >> 15 - (x >> 15);
    }

    public static int log2(int x) {
        int y;
        for (int step = y = 524288; step > 0; step >>= 1) {
            if (Channel.exp2(y - step) < x) continue;
            y -= step;
        }
        return y;
    }
}

