/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.network.concrete;

import com.unascribed.yttr.network.concrete.DefaultMarshallers;
import com.unascribed.yttr.network.concrete.ImmutableMarshallable;
import com.unascribed.yttr.network.concrete.ImmutableMarshallableMarshaller;
import com.unascribed.yttr.network.concrete.Marshallable;
import com.unascribed.yttr.network.concrete.MarshallableMarshaller;
import com.unascribed.yttr.network.concrete.Marshaller;
import com.unascribed.yttr.network.concrete.annotation.field.MarshalledAs;
import com.unascribed.yttr.network.concrete.annotation.field.Optional;
import com.unascribed.yttr.network.concrete.exception.BadMessageException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.class_2540;

class WireField<T> {
    private final Field f;
    private final MethodHandle getter;
    private final MethodHandle setter;
    private final Marshaller<T> marshaller;
    private final Class<T> type;
    private final boolean optional;

    public WireField(Field f) {
        Class paramClazz;
        Type param;
        ParameterizedType pt;
        f.setAccessible(true);
        this.f = f;
        try {
            this.getter = MethodHandles.lookup().unreflectGetter(f);
            this.setter = MethodHandles.lookup().unreflectSetter(f);
            this.type = f.getType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MarshalledAs ma = f.getAnnotation(MarshalledAs.class);
        this.marshaller = ma != null ? DefaultMarshallers.getByName(ma.value()) : (Marshallable.class.isAssignableFrom(this.type) ? new MarshallableMarshaller<T>(this.type) : (ImmutableMarshallable.class.isAssignableFrom(this.type) ? new ImmutableMarshallableMarshaller<T>(this.type) : (this.type == List.class && f.getGenericType() instanceof ParameterizedType ? ((pt = (ParameterizedType)f.getGenericType()).getActualTypeArguments().length == 1 ? ((param = pt.getActualTypeArguments()[0]) instanceof Class ? (Marshallable.class.isAssignableFrom(paramClazz = (Class)param) ? new DefaultMarshallers.ListMarshaller(new MarshallableMarshaller(paramClazz)) : (ImmutableMarshallable.class.isAssignableFrom(paramClazz) ? new DefaultMarshallers.ListMarshaller(new ImmutableMarshallableMarshaller(paramClazz)) : DefaultMarshallers.getByType(this.type))) : DefaultMarshallers.getByType(this.type)) : DefaultMarshallers.getByType(this.type)) : DefaultMarshallers.getByType(this.type))));
        boolean bl = this.optional = f.getAnnotation(Optional.class) != null;
        if (this.marshaller == null && this.type != Boolean.TYPE) {
            Object annot = "";
            if (ma != null) {
                annot = "@MarshalledAs(\"" + ma.value().replace("\"", "\\\"") + "\") ";
            }
            if (this.optional) {
                annot = (String)annot + "@Optional ";
            }
            throw new BadMessageException("Cannot find an appropriate marshaller for field " + (String)annot + this.type + " " + f.getDeclaringClass().getName() + "." + f.getName());
        }
    }

    public T get(Object owner) {
        try {
            return (T)this.getter.invoke(owner);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Object owner, T value) {
        try {
            this.setter.invoke(owner, value);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void marshal(Object owner, class_2540 out) {
        T value = this.get(owner);
        if (value == null) {
            if (this.isOptional()) {
                return;
            }
            throw new BadMessageException("Wire fields cannot be null (in " + this.type + " " + this.f.getDeclaringClass().getName() + "." + this.f.getName() + ") - did you want to make it @Optional?");
        }
        this.marshaller.marshal(out, value);
    }

    public void unmarshal(Object owner, class_2540 in) {
        this.set(owner, this.marshaller.unmarshal(in));
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Class<? extends T> getType() {
        return this.type;
    }
}

