/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.network.concrete;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.unascribed.yttr.mixin.accessor.AccessorCustomPayload;
import com.unascribed.yttr.network.concrete.Message;
import com.unascribed.yttr.network.concrete.WireField;
import com.unascribed.yttr.network.concrete.annotation.field.Optional;
import com.unascribed.yttr.network.concrete.exception.BadMessageException;
import com.unascribed.yttr.network.concrete.exception.WrongSideException;
import com.unascribed.yttr.util.YLog;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_634;

public final class NetworkContext {
    public static final List<NetworkContext> contexts = new ArrayList<NetworkContext>();
    protected static final Map<Class<? extends Message>, MethodHandle> instanciators = Maps.newHashMap();
    protected final BiMap<Class<? extends Message>, Integer> packetIds = HashBiMap.create();
    protected final Map<Class<? extends Message>, List<WireField<?>>> marshallers = Maps.newHashMap();
    protected final Multiset<Class<? extends Message>> booleanCount = HashMultiset.create();
    protected final Multiset<Class<? extends Message>> optionalCount = HashMultiset.create();
    protected final class_2960 channel;
    private int nextPacketId = 0;

    private NetworkContext(class_2960 channel) {
        this.channel = channel;
        contexts.add(this);
    }

    public NetworkContext register(Class<? extends Message> clazz) {
        if (this.packetIds.containsKey(clazz)) {
            return this;
        }
        this.packetIds.put(clazz, (Object)this.nextPacketId++);
        ArrayList fields = Lists.newArrayList();
        for (Class<? extends Message> cursor = clazz; cursor != null && cursor != Object.class; cursor = cursor.getSuperclass()) {
            for (Field f : cursor.getDeclaredFields()) {
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                if (f.getType() == Boolean.TYPE) {
                    this.booleanCount.add(clazz);
                }
                if (f.getAnnotation(Optional.class) != null) {
                    this.optionalCount.add(clazz);
                }
                WireField wf = new WireField(f);
                fields.add(wf);
            }
        }
        this.marshallers.put(clazz, fields);
        return this;
    }

    public class_2960 getChannel() {
        return this.channel;
    }

    protected class_2540 getPayloadFrom(Message m) {
        if (!this.packetIds.containsKey(m.getClass())) {
            throw new BadMessageException(m.getClass() + " is not registered");
        }
        class_2540 payload = new class_2540(Unpooled.buffer());
        payload.writeByte(((Integer)this.packetIds.get(m.getClass())).intValue());
        int bools = this.booleanCount.count(m.getClass()) + this.optionalCount.count(m.getClass());
        if (bools > 0) {
            ArrayList li = Lists.newArrayListWithCapacity((int)bools);
            for (WireField<?> wf : this.marshallers.get(m.getClass())) {
                if (wf.getType() == Boolean.TYPE) {
                    li.add((Boolean)wf.get(m));
                    continue;
                }
                if (!wf.isOptional()) continue;
                li.add(wf.get(m) != null);
            }
            for (int i = 0; i < (bools + 7) / 8; ++i) {
                int by = 0;
                for (int j = i * 8; j < Math.min(li.size(), i + 8); ++j) {
                    if (!((Boolean)li.get(j)).booleanValue()) continue;
                    by |= 1 << j;
                }
                payload.writeByte(by);
            }
        }
        this.marshallers.get(m.getClass()).stream().filter(it -> it.getType() != Boolean.TYPE).forEach(it -> it.marshal(m, payload));
        return payload;
    }

    public boolean handleCustomPacket(class_3244 handler, class_2817 pkt) {
        if (((AccessorCustomPayload)pkt).yttr$getChannel().equals((Object)this.channel)) {
            try {
                class_2540 payload = ((AccessorCustomPayload)pkt).yttr$getData();
                Message m = this.readPacket(EnvType.SERVER, payload);
                m.doHandleServer((class_1657)handler.field_14140);
            }
            catch (Throwable t) {
                YLog.warn("Exception thrown during packet handling, kicking player", t);
                handler.method_14367((class_2561)new class_2585("Internal server error"));
            }
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean handleCustomPacket(class_634 handler, class_2658 pkt) {
        if (pkt.method_11456().equals((Object)this.channel)) {
            class_2540 payload = pkt.method_11458();
            Message m = this.readPacket(EnvType.CLIENT, payload);
            m.doHandleClient();
            return true;
        }
        return false;
    }

    private Message readPacket(EnvType env, class_2540 payload) {
        Message m;
        short id = payload.readUnsignedByte();
        if (!this.packetIds.containsValue((Object)id)) {
            throw new IllegalArgumentException("Unknown packet id " + id);
        }
        Class clazz = (Class)this.packetIds.inverse().get((Object)id);
        try {
            m = this.instantiateMessage(clazz);
        }
        catch (Throwable t) {
            throw new BadMessageException("Cannot instanciate message class " + clazz, t);
        }
        if (m.getEnv() != env) {
            throw new WrongSideException("Cannot receive packet of type " + clazz + " in environment " + env);
        }
        HashSet present = Sets.newHashSetWithExpectedSize((int)this.marshallers.get(m.getClass()).size());
        int bools = this.booleanCount.count(m.getClass()) + this.optionalCount.count(m.getClass());
        if (bools > 0) {
            ArrayList li = Lists.newArrayListWithCapacity((int)bools);
            for (WireField<?> wf : this.marshallers.get(m.getClass())) {
                if (wf.getType() == Boolean.TYPE) {
                    li.add(b -> wf.set(m, b));
                    present.add(wf);
                    continue;
                }
                if (wf.isOptional()) {
                    li.add(b -> {
                        if (b.booleanValue()) {
                            present.add(wf);
                        }
                    });
                    continue;
                }
                present.add(wf);
            }
            for (int i = 0; i < (bools + 7) / 8; ++i) {
                short by = payload.readUnsignedByte();
                for (int j = i * 8; j < Math.min(li.size(), i + 8); ++j) {
                    boolean val = (by & 1 << j - i) != 0;
                    ((Consumer)li.get(j)).accept(val);
                }
            }
        } else {
            present.addAll((Collection)this.marshallers.get(m.getClass()));
        }
        this.marshallers.get(m.getClass()).stream().filter(it -> it.getType() != Boolean.TYPE && present.contains(it)).forEach(it -> it.unmarshal(m, payload));
        return m;
    }

    private Message instantiateMessage(Class<? extends Message> clazz) throws Throwable {
        MethodHandle instanciator = instanciators.get(clazz);
        if (instanciator == null) {
            Constructor<? extends Message> cons;
            try {
                cons = clazz.getDeclaredConstructor(NetworkContext.class);
            }
            catch (Throwable t) {
                cons = clazz.getDeclaredConstructor(new Class[0]);
            }
            instanciator = MethodHandles.lookup().unreflectConstructor(cons);
            instanciators.put(clazz, instanciator);
        }
        try {
            return instanciator.invoke(this);
        }
        catch (Throwable t) {
            return instanciator.invoke();
        }
    }

    public static NetworkContext forChannel(String channel) {
        return new NetworkContext(new class_2960(channel));
    }
}

