/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.network;

import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.content.item.SuitArmorItem;
import com.unascribed.yttr.init.YNetwork;
import com.unascribed.yttr.init.YStats;
import com.unascribed.yttr.mechanics.SuitResource;
import com.unascribed.yttr.mixinsupport.DiverPlayer;
import com.unascribed.yttr.network.MessageS2CAnimateFastDive;
import com.unascribed.yttr.network.MessageS2CDiveError;
import com.unascribed.yttr.network.concrete.C2SMessage;
import com.unascribed.yttr.network.concrete.NetworkContext;
import com.unascribed.yttr.world.Geyser;
import com.unascribed.yttr.world.GeysersState;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class MessageC2SDiveTo
extends C2SMessage {
    public UUID id;

    public MessageC2SDiveTo(NetworkContext ctx) {
        super(ctx);
    }

    public MessageC2SDiveTo(UUID id) {
        super(YNetwork.CONTEXT);
        this.id = id;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void handle(class_3222 player) {
        if (!(player instanceof DiverPlayer)) return;
        DiverPlayer diver = (DiverPlayer)player;
        if (diver.yttr$isDiving() && diver.yttr$getFastDiveTarget() == null && diver.yttr$getKnownGeysers().contains(this.id)) {
            Geyser g = GeysersState.get(player.method_14220()).getGeyser(this.id);
            if (g == null) {
                new MessageS2CDiveError("unknown geyser").sendTo((class_1657)player);
                return;
            }
            double distance = Math.sqrt(g.pos.method_40081((double)diver.yttr$getDivePos().x, (double)g.pos.method_10264(), (double)diver.yttr$getDivePos().z));
            Multiset<SuitResource> resourcesNeeded = Yttr.determineNeededResourcesForFastDive(distance);
            Multiset<SuitResource> resourcesAvailable = Yttr.determineAvailableResources((class_1657)player);
            if (!player.method_7337()) {
                for (SuitResource sr : SuitResource.VALUES) {
                    if (resourcesAvailable.count((Object)sr) >= resourcesNeeded.count((Object)sr)) continue;
                    new MessageS2CDiveError("not enough " + sr.name().toLowerCase(Locale.ROOT)).sendTo((class_1657)player);
                    return;
                }
            }
            class_1799 is = player.method_6118(class_1304.field_6174);
            SuitArmorItem sai = (SuitArmorItem)is.method_7909();
            UnmodifiableIterator unmodifiableIterator = SuitResource.VALUES.iterator();
            while (true) {
                if (!unmodifiableIterator.hasNext()) {
                    int time = (int)(distance / 2.0 / 5.0);
                    diver.yttr$setFastDiveTarget(g.pos);
                    diver.yttr$setFastDiveTime(time);
                    YStats.add((class_1309)player, YStats.BLOCKS_DOVE, (int)(distance * 100.0));
                    new MessageS2CAnimateFastDive(resourcesNeeded, g.pos.method_10263(), g.pos.method_10260(), time).sendTo((class_1657)player);
                    return;
                }
                SuitResource sr = (SuitResource)((Object)unmodifiableIterator.next());
                sai.consumeResource(is, sr, resourcesNeeded.count((Object)sr));
            }
        }
        new MessageS2CDiveError("bad state").sendTo((class_1657)player);
    }
}

