/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.network;

import com.google.common.collect.UnmodifiableIterator;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.content.item.SuitArmorItem;
import com.unascribed.yttr.init.YNetwork;
import com.unascribed.yttr.init.YStats;
import com.unascribed.yttr.mechanics.SuitResource;
import com.unascribed.yttr.mixinsupport.DiverPlayer;
import com.unascribed.yttr.network.MessageS2CDivePos;
import com.unascribed.yttr.network.MessageS2CDivePressure;
import com.unascribed.yttr.network.concrete.C2SMessage;
import com.unascribed.yttr.network.concrete.NetworkContext;
import com.unascribed.yttr.network.concrete.annotation.field.MarshalledAs;
import com.unascribed.yttr.util.YLog;
import com.unascribed.yttr.util.math.Vec2i;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class MessageC2SDivePos
extends C2SMessage {
    @MarshalledAs(value="varint")
    public int x;
    @MarshalledAs(value="varint")
    public int z;

    public MessageC2SDivePos(NetworkContext ctx) {
        super(ctx);
    }

    public MessageC2SDivePos(int x, int z) {
        super(YNetwork.CONTEXT);
        this.x = x;
        this.z = z;
    }

    @Override
    protected void handle(class_3222 player) {
        if (!(player instanceof DiverPlayer)) {
            return;
        }
        DiverPlayer diver = (DiverPlayer)player;
        if (diver.yttr$isDiving()) {
            int ticks = player.method_5682().method_3780();
            int lastUpdate = diver.yttr$getLastDivePosUpdate();
            int diff = ticks - lastUpdate;
            diver.yttr$setLastDivePosUpdate(ticks);
            if (lastUpdate != 0 && diff < 4) {
                YLog.warn("{} is updating their dive pos too quickly!", (Object)player.method_5477().getString());
                new MessageS2CDivePos(diver.yttr$getDivePos().x, diver.yttr$getDivePos().z).sendTo((class_1657)player);
                return;
            }
            Vec2i vec = new Vec2i(this.x, this.z);
            int distSq = vec.squaredDistanceTo(diver.yttr$getDivePos());
            if (distSq == 0) {
                return;
            }
            int moveSpeed = 2;
            class_1799 is = player.method_6118(class_1304.field_6174);
            if (!(is.method_7909() instanceof SuitArmorItem)) {
                return;
            }
            SuitArmorItem sai = (SuitArmorItem)is.method_7909();
            UnmodifiableIterator unmodifiableIterator = SuitResource.VALUES.iterator();
            while (unmodifiableIterator.hasNext()) {
                SuitResource sr;
                moveSpeed /= sr.getSpeedDivider(sai.getResourceAmount(is, sr = (SuitResource)((Object)unmodifiableIterator.next())) <= 0);
            }
            int max = (moveSpeed + 1) * diff;
            if (distSq > max * max) {
                YLog.warn("{} dove too quickly! {}, {}", player.method_5477().getString(), this.x - diver.yttr$getDivePos().x, this.z - diver.yttr$getDivePos().z);
                new MessageS2CDivePos(diver.yttr$getDivePos().x, diver.yttr$getDivePos().z).sendTo((class_1657)player);
                return;
            }
            double dist = class_3532.method_15355((float)distSq);
            int pressure = Yttr.calculatePressure(player.method_14220(), diver.yttr$getDivePos().x, diver.yttr$getDivePos().z);
            for (SuitResource sr : SuitResource.VALUES) {
                sai.consumeResource(is, sr, sr.getConsumptionPerBlock(pressure) * (int)dist);
            }
            YStats.add((class_1309)player, YStats.BLOCKS_DOVE, (int)(dist * 100.0));
            diver.yttr$setDivePos(vec);
            new MessageS2CDivePressure(pressure).sendTo((class_1657)player);
        }
    }
}

