/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.mixin.effector;

import com.google.common.collect.Maps;
import com.unascribed.yttr.mixinsupport.PhaseQueueEntry;
import com.unascribed.yttr.mixinsupport.YttrWorld;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1937.class})
public abstract class MixinWorld
implements YttrWorld {
    private final StampedLock yttr$phaseLock = new StampedLock();
    private final Map<class_2338, AtomicInteger> yttr$phase = Maps.newHashMap();
    private final Map<class_2338, UUID> yttr$phaseOwners = Maps.newHashMap();
    private final Map<class_2338, PhaseQueueEntry> yttr$phaseQueue = Maps.newHashMap();
    private final ThreadLocal<class_2338.class_2339> yttr$scratchPos = ThreadLocal.withInitial(class_2338.class_2339::new);
    private boolean yttr$unmasked;

    @Shadow
    public abstract class_2680 method_8320(class_2338 var1);

    @Shadow
    public abstract void method_8413(class_2338 var1, class_2680 var2, class_2680 var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"tickBlockEntities()V"})
    public void tickBlockEntities(CallbackInfo ci) {
        boolean writing = false;
        long stamp = this.yttr$phaseLock.readLock();
        try {
            long wstamp;
            Map.Entry<class_2338, Object> en;
            Iterator<Map.Entry<class_2338, Object>> iter;
            if (!this.yttr$phase.isEmpty()) {
                iter = this.yttr$phase.entrySet().iterator();
                while (iter.hasNext()) {
                    en = iter.next();
                    if (en.getValue().decrementAndGet() > 0) continue;
                    if (!writing) {
                        wstamp = this.yttr$phaseLock.tryConvertToWriteLock(stamp);
                        if (wstamp == 0L) {
                            this.yttr$phaseLock.unlockRead(stamp);
                            stamp = this.yttr$phaseLock.writeLock();
                        } else {
                            stamp = wstamp;
                        }
                        writing = true;
                    }
                    iter.remove();
                    this.yttr$phaseOwners.remove(en.getKey());
                    this.yttr$scheduleRenderUpdate(en.getKey());
                }
            }
            if (!this.yttr$phaseQueue.isEmpty()) {
                iter = this.yttr$phaseQueue.entrySet().iterator();
                while (iter.hasNext()) {
                    en = iter.next();
                    if (((PhaseQueueEntry)en.getValue()).delayLeft.decrementAndGet() > 0) continue;
                    if (!writing) {
                        wstamp = this.yttr$phaseLock.tryConvertToWriteLock(stamp);
                        if (wstamp == 0L) {
                            this.yttr$phaseLock.unlockRead(stamp);
                            stamp = this.yttr$phaseLock.writeLock();
                        } else {
                            stamp = wstamp;
                        }
                        writing = true;
                    }
                    iter.remove();
                    this.yttr$addPhaseBlock(en.getKey(), ((PhaseQueueEntry)en.getValue()).lifetime, -1, ((PhaseQueueEntry)en.getValue()).owner);
                }
            }
        }
        finally {
            this.yttr$phaseLock.unlock(stamp);
        }
    }

    @Override
    public void yttr$scheduleRenderUpdate(class_2338 pos) {
    }

    @Override
    public boolean yttr$isPhased(class_1923 chunkPos, class_2338 pos) {
        if (this.yttr$unmasked) {
            return false;
        }
        return this.yttr$isPhased((class_2338)this.yttr$scratchPos.get().method_10103(chunkPos.method_8326(), 0, chunkPos.method_8328()).method_10100(pos.method_10263() & 0xF, pos.method_10264(), pos.method_10260() & 0xF));
    }

    @Override
    public boolean yttr$isPhased(int x, int y, int z) {
        return this.yttr$isPhased((class_2338)this.yttr$scratchPos.get().method_10103(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean yttr$isPhased(class_2338 pos) {
        long stamp = this.yttr$phaseLock.tryOptimisticRead();
        boolean phased = this.yttr$phase.containsKey(pos);
        if (!this.yttr$phaseLock.validate(stamp)) {
            stamp = this.yttr$phaseLock.readLock();
            try {
                phased = this.yttr$phase.containsKey(pos);
            }
            finally {
                this.yttr$phaseLock.unlockRead(stamp);
            }
        }
        return phased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public UUID yttr$getPhaser(class_2338 pos) {
        long stamp = this.yttr$phaseLock.readLock();
        try {
            UUID uUID = this.yttr$phaseOwners.get(pos);
            return uUID;
        }
        finally {
            this.yttr$phaseLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void yttr$addPhaseBlock(class_2338 pos, int lifetime, int delay, UUID owner) {
        long stamp = this.yttr$phaseLock.writeLock();
        try {
            class_2338 imm = pos.method_10062();
            if (delay <= 0) {
                this.yttr$phase.put(imm, new AtomicInteger(lifetime));
                if (owner != null) {
                    this.yttr$phaseOwners.put(imm, owner);
                }
                this.yttr$scheduleRenderUpdate(pos);
            } else {
                this.yttr$phaseQueue.put(imm, new PhaseQueueEntry(lifetime, delay, owner));
            }
        }
        finally {
            this.yttr$phaseLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void yttr$removePhaseBlock(class_2338 pos) {
        long stamp = this.yttr$phaseLock.writeLock();
        try {
            this.yttr$phase.remove(pos);
        }
        finally {
            this.yttr$phaseLock.unlockWrite(stamp);
        }
    }

    @Override
    public void yttr$setUnmask(boolean unmask) {
        this.yttr$unmasked = unmask;
    }
}

